/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.util;

import java.awt.EventQueue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class IncrementalComboKeyHandler
extends KeyAdapter {
    private final JComboBox comboBox;
    private final Vector<String> list = new Vector();
    private boolean shouldHide = false;

    public IncrementalComboKeyHandler(JComboBox combo) {
        this.comboBox = combo;
        int i = 0;
        while (i < this.comboBox.getModel().getSize()) {
            this.list.addElement((String)this.comboBox.getItemAt(i));
            ++i;
        }
    }

    @Override
    public void keyTyped(final KeyEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String text = ((JTextField)e.getSource()).getText();
                if (text.length() == 0) {
                    IncrementalComboKeyHandler.setSuggestionModel(IncrementalComboKeyHandler.this.comboBox, new DefaultComboBoxModel(IncrementalComboKeyHandler.this.list), "");
                    IncrementalComboKeyHandler.this.comboBox.hidePopup();
                } else {
                    ComboBoxModel m = IncrementalComboKeyHandler.getSuggestedModel(IncrementalComboKeyHandler.this.list, text);
                    if (m.getSize() == 0 || IncrementalComboKeyHandler.this.shouldHide) {
                        IncrementalComboKeyHandler.this.comboBox.hidePopup();
                    } else {
                        IncrementalComboKeyHandler.setSuggestionModel(IncrementalComboKeyHandler.this.comboBox, m, text);
                        IncrementalComboKeyHandler.this.comboBox.showPopup();
                    }
                }
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent e) {
        JTextField textField = (JTextField)e.getSource();
        String text = textField.getText();
        this.shouldHide = false;
        switch (e.getKeyCode()) {
            case 10: 
            case 39: {
                for (String s : this.list) {
                    if (!s.startsWith(text)) continue;
                    textField.setText(s);
                    this.shouldHide = true;
                    return;
                }
                break;
            }
            case 107: {
                if (!this.list.contains(text)) {
                    this.list.addElement(text);
                    Collections.sort(this.list);
                    IncrementalComboKeyHandler.setSuggestionModel(this.comboBox, IncrementalComboKeyHandler.getSuggestedModel(this.list, text), text);
                }
                this.shouldHide = true;
                break;
            }
            case 27: {
                this.shouldHide = true;
            }
        }
    }

    private static void setSuggestionModel(JComboBox comboBox, ComboBoxModel mdl, String str) {
        comboBox.setModel(mdl);
        comboBox.setSelectedIndex(-1);
        ((JTextField)comboBox.getEditor().getEditorComponent()).setText(str);
    }

    private static ComboBoxModel getSuggestedModel(Vector<String> list, String text) {
        DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>();
        for (String s : list) {
            if (!s.startsWith(text)) continue;
            m.addElement(s);
        }
        return m;
    }
}

