/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.fric.util.StringUtilities;
import jp.sbi.celldesigner.Application;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FileFormatValidator {
    public static final String schema = "schema/CellDesigner.xsd";
    public static ArrayList sbmlFiles = new ArrayList();

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            String[] parsed;
            File f = new File(args[i]);
            if (f.isDirectory()) {
                FileFormatValidator.traverseDirectory(f);
            } else if (f.isFile() && (parsed = f.getName().split("\\."))[parsed.length - 1].equalsIgnoreCase("xml")) {
                sbmlFiles.add(f);
            }
            ++i;
        }
        FileFormatValidator.testValidate();
        System.out.println("Validation finished.");
    }

    private static void traverseDirectory(File f) {
        if (!f.isDirectory()) {
            return;
        }
        File[] files = f.listFiles();
        int i = 0;
        while (i < files.length) {
            String[] parsed;
            File file = files[i];
            if (file.isDirectory()) {
                FileFormatValidator.traverseDirectory(file);
            } else if (file.isFile() && (parsed = file.getName().split("\\."))[parsed.length - 1].equalsIgnoreCase("xml")) {
                sbmlFiles.add(file);
            }
            ++i;
        }
    }

    public static void testValidate() {
        FileFormatValidator validator = new FileFormatValidator();
        int i = 0;
        while (i < sbmlFiles.size()) {
            File file = (File)sbmlFiles.get(i);
            System.out.println(file.getAbsolutePath());
            if (validator.validate(file)) {
                System.out.println("   SUCCESS");
            }
            System.out.println();
            ++i;
        }
    }

    public boolean validate(File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            this.parse(is);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    private Document parse(InputStream is) throws Exception {
        InputSource schemaPaths = new InputSource(new BufferedInputStream(Application.class.getResourceAsStream(schema)));
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        docfactory.setNamespaceAware(true);
        docfactory.setIgnoringElementContentWhitespace(true);
        String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
        String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
        String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
        if (schemaPaths != null) {
            schemaPaths.setSystemId(Application.class.getResource(schema).toExternalForm());
            docfactory.setValidating(true);
            try {
                docfactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            catch (IllegalArgumentException x) {
                System.err.println("Error: JAXP DocumentBuilderFactory attribute not recognized: " + JAXP_SCHEMA_LANGUAGE);
                System.err.println("Check to see if parser conforms to JAXP 1.2 spec.");
            }
            docfactory.setAttribute(JAXP_SCHEMA_SOURCE, schemaPaths);
        } else {
            System.err.println("Schema does not exist. Set validation off.");
        }
        DocumentBuilder builder = docfactory.newDocumentBuilder();
        OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
        builder.setErrorHandler(new MyErrorHandler(new PrintWriter((Writer)errorWriter, true)));
        Document doc = builder.parse(is);
        return doc;
    }

    public static class MyErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        public MyErrorHandler(PrintWriter out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            if (spe.getMessage().matches(".*'notes'.*")) {
                this.out.println("Error(notes): " + this.getParseExceptionInfo(spe));
                return;
            }
            throw new SAXException(StringUtilities.wrap(message, 80));
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

