/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.util;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnResizer {
    public static void adjustColumnPreferredWidths(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        int col = 0;
        while (col < table.getColumnCount()) {
            int maxwidth = 0;
            int row = 0;
            while (row < table.getRowCount()) {
                TableCellRenderer rend = table.getCellRenderer(row, col);
                Object value = table.getValueAt(row, col);
                Component comp = rend.getTableCellRendererComponent(table, value, false, false, row, col);
                maxwidth = Math.max(comp.getPreferredSize().width + 15, maxwidth);
                ++row;
            }
            TableColumn column = columnModel.getColumn(col);
            column.setPreferredWidth(maxwidth);
            ++col;
        }
    }

    public static void adjustColumnPreferredWidthsWithHeader(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        int col = 0;
        while (col < table.getColumnCount()) {
            int maxwidth = 0;
            int row = 0;
            while (row < table.getRowCount()) {
                TableCellRenderer rend = table.getCellRenderer(row, col);
                Object value = table.getValueAt(row, col);
                Component comp = rend.getTableCellRendererComponent(table, value, false, false, row, col);
                maxwidth = Math.max(comp.getPreferredSize().width, maxwidth);
                ++row;
            }
            TableColumn column = columnModel.getColumn(col);
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (headerRenderer == null) {
                headerRenderer = table.getTableHeader().getDefaultRenderer();
            }
            Object headerValue = column.getHeaderValue();
            Component headerComp = headerRenderer.getTableCellRendererComponent(table, headerValue, false, false, 0, col);
            maxwidth = Math.max(maxwidth, headerComp.getPreferredSize().width);
            column.setPreferredWidth(maxwidth);
            ++col;
        }
    }
}

