/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.util;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ComplexSpeciesShape;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.SBMLFiler;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.sbmlExtension.Notes;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.util.SBaseComparator;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.AlgebraicRule;
import org.sbml.libsbml.AssignmentRule;
import org.sbml.libsbml.Constraint;
import org.sbml.libsbml.Delay;
import org.sbml.libsbml.Event;
import org.sbml.libsbml.InitialAssignment;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfCompartmentTypes;
import org.sbml.libsbml.ListOfCompartments;
import org.sbml.libsbml.ListOfConstraints;
import org.sbml.libsbml.ListOfEventAssignments;
import org.sbml.libsbml.ListOfEvents;
import org.sbml.libsbml.ListOfFunctionDefinitions;
import org.sbml.libsbml.ListOfInitialAssignments;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.ListOfRules;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.ListOfSpeciesReferences;
import org.sbml.libsbml.ListOfSpeciesTypes;
import org.sbml.libsbml.ListOfUnitDefinitions;
import org.sbml.libsbml.ListOfUnits;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.RateRule;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.Rule;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.SpeciesType;
import org.sbml.libsbml.Trigger;
import org.sbml.libsbml.UnitDefinition;
import org.sbml.libsbml.XMLNode;
import org.sbml.libsbml.libsbml;

public final class CelldUtil {
    public static final String strEqualSearching = "equal";
    public static final String strIncludeSearching = "include";
    public static final String strBeginWithSearching = "begin with";
    public static final String strEndWithSearching = "end with";
    private static final double dMShapeMarginInSBGNViewer = 3.0;

    public static final List getDataFromExcelFile(Object file) {
        ArrayList rtn = new ArrayList();
        if (file == null) {
            return rtn;
        }
        try {
            FileInputStream input = null;
            if (file instanceof String) {
                input = new FileInputStream((String)file);
            } else if (file instanceof File) {
                input = new FileInputStream((File)file);
            } else {
                return rtn;
            }
            POIFSFileSystem filein = new POIFSFileSystem((InputStream)input);
            HSSFWorkbook wb = new HSSFWorkbook(filein);
            int iSheetCnt = wb.getNumberOfSheets();
            ArrayList datas = new ArrayList();
            int i = 0;
            while (i < iSheetCnt) {
                HSSFSheet sheet = wb.getSheetAt(i);
                String sSheetName = wb.getSheetName(i);
                int iFirstRowNum = sheet.getFirstRowNum();
                int iLastRowNum = sheet.getLastRowNum();
                List sheetDatas = new ArrayList();
                ArrayList blankCols = new ArrayList();
                int EffectiveRowCount = 0;
                int j = iFirstRowNum;
                while (j <= iLastRowNum) {
                    HSSFRow row = sheet.getRow(j);
                    if (row != null) {
                        int iFirstCellNum = row.getFirstCellNum();
                        short iLastCellNum = row.getLastCellNum();
                        ArrayList<String> rowDatas = new ArrayList<String>();
                        ArrayList<Integer> blankCells = new ArrayList<Integer>();
                        boolean isNotBalnkRow = false;
                        int k = iFirstCellNum;
                        while (k <= iLastCellNum) {
                            HSSFCell cell = row.getCell((short)k);
                            Object value = null;
                            if (cell == null) {
                                value = "";
                            } else if (cell.getCellType() == 3) {
                                value = "";
                            } else if (cell.getCellType() == 4) {
                                value = cell.getBooleanCellValue();
                                isNotBalnkRow = true;
                            } else {
                                if (cell.getCellType() == 5) {
                                    return rtn;
                                }
                                if (cell.getCellType() == 2) {
                                    value = "";
                                } else if (cell.getCellType() == 0) {
                                    value = cell.getNumericCellValue();
                                    isNotBalnkRow = true;
                                } else if (cell.getCellType() == 1) {
                                    value = cell.getRichStringCellValue();
                                    isNotBalnkRow = true;
                                } else {
                                    value = "";
                                }
                            }
                            if (value != null && "".equals(value)) {
                                blankCells.add(k - iFirstCellNum);
                            }
                            rowDatas.add((String)value);
                            ++k;
                        }
                        if (EffectiveRowCount == 0) {
                            blankCols = blankCells;
                        } else {
                            ArrayList<Integer> blankColsTemp = new ArrayList<Integer>();
                            int ct = 0;
                            while (ct < blankCells.size()) {
                                int col = Integer.parseInt(((Integer)blankCells.get(ct)).toString());
                                if (blankCols != null && blankCols.contains(col)) {
                                    blankColsTemp.add(col);
                                }
                                ++ct;
                            }
                            blankCols = blankColsTemp;
                        }
                        if (isNotBalnkRow) {
                            sheetDatas.add(rowDatas);
                            ++EffectiveRowCount;
                        }
                    }
                    ++j;
                }
                sheetDatas = CelldUtil.deleteBlankCol(blankCols, sheetDatas);
                HashMap hashdatas = new HashMap();
                hashdatas.put(sSheetName, sheetDatas);
                datas.add(hashdatas);
                ++i;
            }
            return datas;
        }
        catch (Exception e) {
            return rtn;
        }
    }

    private static final List deleteBlankCol(List blankColNum, List sheetDatas) {
        if (blankColNum == null || sheetDatas == null) {
            return sheetDatas;
        }
        ArrayList bak = new ArrayList(sheetDatas);
        try {
            int cnt = blankColNum.size() - 1;
            while (cnt >= 0) {
                int intBlankRowNum = Integer.parseInt(blankColNum.get(cnt).toString());
                int ct = 0;
                while (ct < sheetDatas.size()) {
                    List rowdata = (List)sheetDatas.get(ct);
                    try {
                        rowdata.remove(intBlankRowNum);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++ct;
                }
                --cnt;
            }
        }
        catch (Exception ex) {
            return bak;
        }
        return sheetDatas;
    }

    public static final String getHtmlText(String input) {
        String context = "";
        if (input != null) {
            context = input;
        }
        context = input.replaceAll(" ", "&nbsp;");
        String tooltipString = "<html>\t<body>" + context + "\t</body>" + "</html>";
        return tooltipString;
    }

    public static final SBModelFrame getAimSBModelFrame(Object oneObj) {
        SBModelFrame aim = null;
        try {
            Model model = CelldUtil.getAimModel(oneObj);
            if (model == null) {
                return aim;
            }
            Vector models = MainWindow.getLastInstance().getModels();
            int i = 0;
            while (i < models.size()) {
                if (((SBModelFrame)models.get(i)).getSBModel().getModel() == model) {
                    aim = (SBModelFrame)models.get(i);
                    break;
                }
                ++i;
            }
        }
        catch (Exception myErr) {
            aim = null;
        }
        return aim;
    }

    public static final SBModel getAimSBModel(Object oneObj) {
        SBModel aim = null;
        try {
            aim = CelldUtil.getAimSBModelFrame(oneObj).getSBModel();
        }
        catch (Exception myErr) {
            aim = null;
        }
        return aim;
    }

    /*
     * Exception decompiling
     */
    public static final Model getAimModel(Object oneObj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean isInListof(Object oneObj, ListOf lstof) {
        if (oneObj == null) {
            return false;
        }
        if (lstof == null) {
            return false;
        }
        try {
            int j = 0;
            while (true) {
                if ((long)j >= lstof.size()) {
                    return false;
                }
                if (SBaseComparator.equals(lstof.get((long)j), (SBase)oneObj)) {
                    return true;
                }
                ++j;
            }
        }
        catch (Exception myErr) {
            return false;
        }
    }

    public static final void confirmNoteHashMapValue(SBase sbase, HashMap hmSbase) {
        CelldUtil.confirmNoteHashMapValue(sbase, null, hmSbase);
    }

    public static final void confirmNoteHashMapValue(SBase sbase, Object objAux, HashMap hmSbase) {
        if (sbase == null) {
            return;
        }
        if (hmSbase == null) {
            return;
        }
        try {
            String key = sbase.getId();
            if (sbase instanceof Rule) {
                Rule rule = (Rule)sbase;
                key = rule.getFormula();
            } else if (sbase instanceof InitialAssignment) {
                InitialAssignment initialAssignment = (InitialAssignment)sbase;
                key = initialAssignment.getSymbol();
            } else if (sbase instanceof Constraint) {
                Constraint constraint = (Constraint)sbase;
                ASTNode math = constraint.getMath();
                key = math != null ? libsbml.formulaToString((ASTNode)math) : "";
            } else if (sbase instanceof KineticLaw) {
                if (objAux instanceof Reaction) {
                    key = ((Reaction)objAux).getId();
                } else {
                    return;
                }
            }
            if (key == null) {
                return;
            }
            Notes notesSbase = (Notes)hmSbase.get(key);
            if (notesSbase != null) {
                notesSbase.setText(LibSBMLUtil.getCDNotesBodyString(notesSbase.getCDNotes(sbase)));
            } else if (sbase.getNotesString() != null && !"".equals(sbase.getNotesString())) {
                XMLNode xn = XMLNode.convertStringToXMLNode((String)sbase.getNotesString());
                sbase.setNotes(LibSBMLUtil.convertNotesToCDNotes(xn));
                Notes nt = new Notes();
                nt.setText(LibSBMLUtil.getCDNotesBodyString(sbase.getNotes()));
                hmSbase.put(key, nt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void mergeNewAndOldNotes(SBModel sbmodel) {
        if (sbmodel == null) {
            return;
        }
        Model model = sbmodel.getModel();
        if (model == null) {
            return;
        }
        HashMap hmSbase = null;
        HashMap hmSubSbase = null;
        try {
            hmSbase = sbmodel.getHashModelNotes();
            CelldUtil.confirmNoteHashMapValue((SBase)model, hmSbase);
            hmSbase = sbmodel.getHashCompartmentNotes();
            int i = 0;
            while ((long)i < model.getNumCompartments()) {
                CelldUtil.confirmNoteHashMapValue((SBase)model.getCompartment((long)i), hmSbase);
                ++i;
            }
            hmSbase = sbmodel.getHashSpeciesNotes();
            i = 0;
            while ((long)i < model.getNumSpecies()) {
                CelldUtil.confirmNoteHashMapValue((SBase)model.getSpecies((long)i), hmSbase);
                ++i;
            }
            hmSbase = sbmodel.getHashReactionNotes();
            hmSubSbase = sbmodel.getHashKineticLawNotes();
            i = 0;
            while ((long)i < model.getNumReactions()) {
                Reaction reaction = model.getReaction((long)i);
                CelldUtil.confirmNoteHashMapValue((SBase)reaction, hmSbase);
                CelldUtil.confirmNoteHashMapValue((SBase)reaction.getKineticLaw(), reaction, hmSubSbase);
                ++i;
            }
            hmSbase = sbmodel.getHashParameterNotes();
            i = 0;
            while ((long)i < model.getNumParameters()) {
                CelldUtil.confirmNoteHashMapValue((SBase)model.getParameter((long)i), hmSbase);
                ++i;
            }
            hmSbase = sbmodel.getHashFunctionNotes();
            i = 0;
            while ((long)i < model.getNumFunctionDefinitions()) {
                CelldUtil.confirmNoteHashMapValue((SBase)model.getFunctionDefinition((long)i), hmSbase);
                ++i;
            }
            hmSbase = sbmodel.getHashUnitNotes();
            i = 0;
            while ((long)i < model.getNumUnitDefinitions()) {
                CelldUtil.confirmNoteHashMapValue((SBase)model.getUnitDefinition((long)i), hmSbase);
                ++i;
            }
            hmSbase = sbmodel.getHashRuleNotes();
            i = 0;
            while ((long)i < model.getNumRules()) {
                CelldUtil.confirmNoteHashMapValue((SBase)model.getRule((long)i), hmSbase);
                ++i;
            }
            hmSbase = sbmodel.getHashEventNotes();
            i = 0;
            while ((long)i < model.getNumEvents()) {
                CelldUtil.confirmNoteHashMapValue((SBase)model.getEvent((long)i), hmSbase);
                ++i;
            }
            hmSbase = sbmodel.getHashSpeciesTypeNotes();
            i = 0;
            while ((long)i < model.getNumSpeciesTypes()) {
                CelldUtil.confirmNoteHashMapValue((SBase)model.getSpeciesType((long)i), hmSbase);
                ++i;
            }
            hmSbase = sbmodel.getHashCompartmentTypeNotes();
            i = 0;
            while ((long)i < model.getNumCompartmentTypes()) {
                CelldUtil.confirmNoteHashMapValue((SBase)model.getCompartmentType((long)i), hmSbase);
                ++i;
            }
            hmSbase = sbmodel.getHashInitialAssignmentNotes();
            i = 0;
            while ((long)i < model.getNumInitialAssignments()) {
                CelldUtil.confirmNoteHashMapValue((SBase)model.getInitialAssignment((long)i), hmSbase);
                ++i;
            }
            hmSbase = sbmodel.getHashConstraintNotes();
            i = 0;
            while ((long)i < model.getNumConstraints()) {
                CelldUtil.confirmNoteHashMapValue((SBase)model.getConstraint((long)i), hmSbase);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final boolean isSpeciesBeUsedInReactionLinks(SBModel sbm, Species species) {
        if (sbm == null) {
            return false;
        }
        if (sbm.getModel() == null) {
            return false;
        }
        if (sbm.getModel().getListOfReactions() == null) {
            return false;
        }
        if (species == null) {
            return false;
        }
        if (species.getId() == null) {
            return false;
        }
        String sID = species.getId();
        ListOfReactions lst = sbm.getModel().getListOfReactions();
        int i = 0;
        while ((long)i < lst.size()) {
            SpeciesReference ssr;
            int j;
            Reaction rection = (Reaction)lst.get((long)i);
            if (rection.getListOfReactants() != null) {
                j = 0;
                while ((long)j < rection.getNumReactants()) {
                    ssr = rection.getReactant((long)j);
                    if (sID.equals(ssr.getSpecies())) {
                        return true;
                    }
                    ++j;
                }
            }
            if (rection.getListOfProducts() != null) {
                j = 0;
                while ((long)j < rection.getNumProducts()) {
                    ssr = rection.getProduct((long)j);
                    if (sID.equals(ssr.getSpecies())) {
                        return true;
                    }
                    ++j;
                }
            }
            if (rection.getListOfModifiers() != null) {
                j = 0;
                while ((long)j < rection.getNumModifiers()) {
                    ssr = rection.getModifier((long)j);
                    if (sID.equals(ssr.getSpecies())) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public static final void resetSBGNViewerPosOfMShapes(MonoSpeciesShape monoSpeciesShape) {
        if (monoSpeciesShape == null) {
            return;
        }
        SpeciesSymbol symbol = monoSpeciesShape.getSpeciesSymbol();
        if (symbol == null) {
            return;
        }
        Vector mShapes = monoSpeciesShape.getMShapes();
        if (mShapes == null || mShapes.size() == 0) {
            return;
        }
        if (!CelldUtil.isMShapesIntersects(mShapes)) {
            return;
        }
        double width = symbol.getSymbolBounds().getWidth();
        double intervalPercent = 3.0 / width;
        if (!CelldUtil.isSpeciesSymbolLengthEnough(mShapes, symbol, intervalPercent)) {
            return;
        }
        if (!CelldUtil.intersectsAfterAverageAdjustmented(mShapes, symbol)) {
            CelldUtil.averageAdjustmentPosOfMShapes(mShapes, symbol);
        } else {
            CelldUtil.oneafteroneAdjustmentPosOfMShapes(mShapes, symbol, intervalPercent);
        }
    }

    public static final boolean isMShapesIntersects(Vector mShapes) {
        if (mShapes == null || mShapes.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < mShapes.size()) {
            if (mShapes.get(i) instanceof ModificationShape) {
                ModificationShape m = (ModificationShape)mShapes.get(i);
                Rectangle2D.Double rect = m.getCircleBounds();
                int u = i + 1;
                while (u < mShapes.size()) {
                    ModificationShape ms;
                    Rectangle2D.Double recttemp;
                    if (mShapes.get(u) instanceof ModificationShape && rect.intersects(recttemp = (ms = (ModificationShape)mShapes.get(u)).getCircleBounds())) {
                        return true;
                    }
                    ++u;
                }
            }
            ++i;
        }
        return false;
    }

    public static final boolean isSpeciesSymbolLengthEnough(Vector mShapes, SpeciesSymbol symbol, double intervalBuffer) {
        if (mShapes == null || mShapes.size() == 0) {
            return false;
        }
        if (symbol == null || symbol.getSymbolBounds() == null) {
            return false;
        }
        if (symbol.getSymbolBounds().getWidth() == 0.0) {
            return false;
        }
        double allsize = 0.0;
        int i = 0;
        while (i < mShapes.size()) {
            ModificationShape m;
            if (mShapes.get(i) instanceof ModificationShape && (m = (ModificationShape)mShapes.get(i)).getModificationRegion() != null) {
                if (i > 0) {
                    allsize += intervalBuffer;
                }
                allsize = "Modification Site".equals(m.getModificationRegion().getType()) ? (allsize += 17.6 / symbol.getSymbolBounds().getWidth()) : (allsize += m.getModificationRegion().getSize());
            }
            ++i;
        }
        return !(allsize > 1.0);
    }

    public static final boolean intersectsAfterAverageAdjustmented(Vector mShapes, SpeciesSymbol symbol) {
        if (mShapes == null || mShapes.size() == 0) {
            return false;
        }
        if (symbol == null || symbol.getSymbolBounds() == null) {
            return true;
        }
        if (symbol.getSymbolBounds().getWidth() == 0.0) {
            return true;
        }
        int sizeM = mShapes.size();
        double rangPer = 1.0 / (double)sizeM;
        int i = 0;
        while (i < mShapes.size()) {
            ModificationShape m;
            if (mShapes.get(i) instanceof ModificationShape && (m = (ModificationShape)mShapes.get(i)).getModificationRegion() != null) {
                double size = m.getModificationRegion().getSize();
                if ("Modification Site".equals(m.getModificationRegion().getType())) {
                    size = 17.6 / symbol.getSymbolBounds().getWidth();
                }
                if (size > rangPer) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static final void averageAdjustmentPosOfMShapes(Vector mShapes, SpeciesSymbol symbol) {
        if (mShapes == null || mShapes.size() == 0) {
            return;
        }
        if (symbol == null || symbol.getSymbolBounds() == null) {
            return;
        }
        if (symbol.getSymbolBounds().getWidth() == 0.0) {
            return;
        }
        int sizeM = mShapes.size();
        double rangPer = 1.0 / ((double)sizeM * 2.0);
        Vector dms = CelldUtil.sortMShapeByDistance(mShapes);
        int i = 0;
        while (i < sizeM) {
            if (dms.get(i) instanceof ModificationShape) {
                ModificationShape ms = (ModificationShape)dms.get(i);
                double pos = (double)(i * 2 + 1) * rangPer;
                if (ms.getModificationRegion() != null) {
                    double size = ms.getModificationRegion().getSize();
                    if ("Modification Site".equals(ms.getModificationRegion().getType())) {
                        size = 17.6 / symbol.getSymbolBounds().getWidth();
                    }
                    ms.getModificationRegion().setPos(pos -= size / 2.0);
                    ms.updateCircleBounds();
                }
            }
            ++i;
        }
    }

    public static final void oneafteroneAdjustmentPosOfMShapes(Vector mShapes, SpeciesSymbol symbol, double intervalBuffer) {
        if (mShapes == null || mShapes.size() == 0) {
            return;
        }
        if (symbol == null || symbol.getSymbolBounds() == null) {
            return;
        }
        if (symbol.getSymbolBounds().getWidth() == 0.0) {
            return;
        }
        Vector dms = CelldUtil.sortMShapeByDistance(mShapes);
        int sizeM = mShapes.size();
        double pos = 0.0;
        int i = 0;
        while (i < sizeM) {
            if (dms.get(i) instanceof ModificationShape) {
                ModificationShape ms = (ModificationShape)dms.get(i);
                if (i > 0) {
                    pos += intervalBuffer;
                }
                ms.getModificationRegion().setPos(pos);
                ms.updateCircleBounds();
                pos = "Modification Site".equals(ms.getModificationRegion().getType()) ? (pos += 17.6 / symbol.getSymbolBounds().getWidth()) : (pos += ms.getModificationRegion().getSize());
            }
            ++i;
        }
    }

    public static final Vector sortMShapeByDistance(Vector mShapes) {
        Vector rtnVector = new Vector();
        if (mShapes == null || mShapes.size() == 0) {
            return rtnVector;
        }
        ModificationShape ms = null;
        try {
            rtnVector.add(mShapes.get(0));
            int i = 1;
            while (i < mShapes.size()) {
                ms = (ModificationShape)mShapes.get(i);
                double distanceCur = ms.getModificationRegion().getPos();
                int j = 0;
                while (j < rtnVector.size()) {
                    ModificationShape m = (ModificationShape)rtnVector.get(j);
                    double distance = m.getModificationRegion().getPos();
                    if (distanceCur < distance) {
                        rtnVector.add(j, ms);
                        break;
                    }
                    ++j;
                }
                if (!rtnVector.contains(ms)) {
                    rtnVector.add(ms);
                }
                ++i;
            }
        }
        catch (Exception e) {
            return mShapes;
        }
        return rtnVector;
    }

    public static final boolean mshapsIntersectsInforBox(MonoSpeciesShape monoSpeciesShape, Rectangle2D.Double infoBoxRect) {
        if (monoSpeciesShape == null || infoBoxRect == null) {
            return false;
        }
        Vector mShapes = monoSpeciesShape.getMShapes();
        if (mShapes == null || mShapes.size() == 0) {
            return false;
        }
        int u = 0;
        while (u < mShapes.size()) {
            ModificationShape ms = (ModificationShape)mShapes.get(u);
            Rectangle2D.Double recttemp = ms.getCircleBounds();
            if (infoBoxRect.intersects(recttemp)) {
                return true;
            }
            ++u;
        }
        return false;
    }

    public static final boolean isMatch(String anyInput, String searchingforInput, boolean casesensitive, String matchFlag) {
        if (anyInput == null || searchingforInput == null) {
            return false;
        }
        String any = new String(anyInput);
        String searchingfor = new String(searchingforInput);
        if (!casesensitive) {
            any = new String(anyInput.toLowerCase());
            searchingfor = new String(searchingforInput.toLowerCase());
        }
        return strEqualSearching.equals(matchFlag) ? any.equals(searchingfor) : (strIncludeSearching.equals(matchFlag) ? any.indexOf(searchingfor) != -1 : (strBeginWithSearching.equals(matchFlag) ? any.startsWith(searchingfor) : strEndWithSearching.equals(matchFlag) && any.endsWith(searchingfor)));
    }

    public static final void autoUpdateListofSpeciesType(SBModel sbmd) {
        try {
            String id;
            Vector vAutoSpeciesType = sbmd.getAutoCreatedSpeciesTypes();
            if (vAutoSpeciesType == null || vAutoSpeciesType.size() <= 0) {
                return;
            }
            GStructure gstru = sbmd.getGStructure();
            Vector vAllSpecies = new Vector();
            vAllSpecies.addAll(gstru.getAtoms());
            vAllSpecies.addAll(gstru.getContainableAtoms());
            Vector<String> vAllSpeciesTypesID = new Vector<String>();
            Vector<String> vAllSpeciesTypesName = new Vector<String>();
            int i = 0;
            while (i < vAllSpecies.size()) {
                block16: {
                    SpeciesAlias alias = (SpeciesAlias)vAllSpecies.get(i);
                    String spstype = alias.getOriginalSpecies().getSpeciesType();
                    if (spstype != null && !spstype.equals("") && !vAllSpeciesTypesID.contains(spstype)) {
                        String name = "";
                        try {
                            MonoSpeciesProperty mono = null;
                            GFramedShape frmshp = alias.getGFramedShape();
                            if (frmshp instanceof MonoSpeciesShape) {
                                mono = (MonoSpeciesProperty)((MonoSpeciesShape)frmshp).getProperty();
                            } else if (frmshp instanceof ComplexSpeciesShape) {
                                mono = (MonoSpeciesProperty)((ComplexSpeciesShape)frmshp).getProperty();
                            }
                            name = mono.getName();
                        }
                        catch (Exception myErr) {
                            break block16;
                        }
                        vAllSpeciesTypesID.add(spstype);
                        vAllSpeciesTypesName.add(name);
                    }
                }
                ++i;
            }
            ListOf sbsList = sbmd.getSBMLPanelLists().getSBaseListPanel(14).getSBaseList();
            long i2 = sbsList.size() - 1L;
            while (i2 >= 0L) {
                id = sbsList.get(i2).getId();
                if (vAutoSpeciesType.contains(id) && !vAllSpeciesTypesID.contains(id)) {
                    sbsList.remove(i2);
                }
                --i2;
            }
            int i22 = 0;
            while (i22 < vAllSpeciesTypesID.size()) {
                boolean had = false;
                id = (String)vAllSpeciesTypesID.get(i22);
                String name = (String)vAllSpeciesTypesName.get(i22);
                int j = 0;
                while ((long)j < sbsList.size()) {
                    if (sbsList.get((long)j).getId().equals(id)) {
                        had = true;
                        break;
                    }
                    ++j;
                }
                if (!had) {
                    SpeciesType spstype = new SpeciesType();
                    spstype.setId(id);
                    spstype.setName(name);
                    sbsList.appendAndOwn((SBase)spstype);
                }
                ++i22;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void remakeAutoCreatedSpeciesTypes(SBModel sbModel, Vector atoms, Vector complexs) {
    }

    public static final boolean canSeemAsDefaultSpeciesType(String speciestype, boolean buildsbmodel, Object any, MonoSpeciesProperty monoprop) {
        if (speciestype == null) {
            return false;
        }
        try {
            SpeciesType defaultType = CelldUtil.createDefaultSpeciesType(buildsbmodel, any, monoprop);
            return speciestype.equals(defaultType.getId());
        }
        catch (Exception myErr) {
            return false;
        }
    }

    public static final SpeciesType createDefaultSpeciesType(boolean buildsbmodel, Object any, MonoSpeciesProperty monoprop) {
        SpeciesAlias alias = null;
        Species species = null;
        MonoSpeciesProperty mono = monoprop;
        if (buildsbmodel && any instanceof SpeciesAlias) {
            alias = (SpeciesAlias)any;
            species = alias.getOriginalSpecies();
        } else if (!buildsbmodel && any instanceof Species) {
            species = (Species)any;
        } else {
            return null;
        }
        String newspeciestypeId = null;
        String newspeciestypeName = null;
        String strJoin = "_";
        try {
            newspeciestypeName = mono.getName();
            if (buildsbmodel) {
                try {
                    newspeciestypeName = ((MonoSpeciesProperty)((MonoSpeciesShape)alias.getGFramedShape()).getProperty()).getName();
                }
                catch (Exception myErr) {
                    newspeciestypeName = mono.getName();
                }
            }
            String id = null;
            String type = mono.getType();
            String symboltype = null;
            if (type.equals("PROTEIN")) {
                Protein protein = mono.getProtein();
                if (buildsbmodel) {
                    if (protein != null) {
                        id = protein.getId();
                    }
                    if (id == null || id.trim().equals("")) {
                        id = mono.getReadingSomeId();
                    }
                    if (protein != null) {
                        symboltype = protein.getType();
                    } else {
                        SpeciesSymbol symbol = ((MonoSpeciesShape)alias.getGFramedShape()).getSpeciesSymbol();
                        symboltype = ((SBSymbol)((Object)symbol)).getCode();
                    }
                } else {
                    id = protein.getId();
                    symboltype = protein.getType();
                }
                newspeciestypeId = String.valueOf("PROTEIN".toLowerCase()) + "_" + symboltype.toLowerCase() + "_" + id;
            } else if (type.equals("GENE")) {
                Gene gene = mono.getGene();
                if (buildsbmodel) {
                    if (gene != null) {
                        id = gene.getId();
                    }
                    if (id == null || id.trim().equals("")) {
                        id = mono.getReadingSomeId();
                    }
                } else {
                    id = gene.getId();
                }
                newspeciestypeId = String.valueOf("GENE".toLowerCase()) + "_" + id;
            } else if (type.equals("RNA")) {
                RNA rna = mono.getRNA();
                if (buildsbmodel) {
                    if (rna != null) {
                        id = rna.getId();
                    }
                    if (id == null || id.trim().equals("")) {
                        id = mono.getReadingSomeId();
                    }
                } else {
                    id = rna.getId();
                }
                newspeciestypeId = String.valueOf("RNA".toLowerCase()) + "_" + id;
            } else if (type.equals("ANTISENSE_RNA")) {
                AntiSenseRNA arna = mono.getAntiSenseRNA();
                if (buildsbmodel) {
                    if (arna != null) {
                        id = arna.getId();
                    }
                    if (id == null || id.trim().equals("")) {
                        id = mono.getReadingSomeId();
                    }
                } else {
                    id = arna.getId();
                }
                newspeciestypeId = String.valueOf("ANTISENSE_RNA".toLowerCase()) + "_" + id;
            } else {
                newspeciestypeId = String.valueOf(mono.getType().toLowerCase()) + "_" + species.getId();
            }
        }
        catch (Exception myErr) {
            return null;
        }
        SpeciesType spstype = null;
        if (newspeciestypeId != null && !newspeciestypeId.equals("")) {
            spstype = new SpeciesType();
            spstype.setId(newspeciestypeId);
            spstype.setName(newspeciestypeName);
        }
        return spstype;
    }

    public static final SBModelFrame getSBModelFrame(Object oneObj) {
        try {
            Model aModel = CelldUtil.getAimModel(oneObj);
            if (aModel == null) {
                if (oneObj instanceof SBModel) {
                    aModel = ((SBModel)oneObj).getModel();
                } else if (oneObj instanceof PluginModel) {
                    return MainWindow.getTargetSBModelFrame((PluginModel)oneObj);
                }
            }
            if (aModel != null) {
                return MainWindow.getTargetSBModelFrame(aModel);
            }
            return null;
        }
        catch (Exception myErr) {
            return null;
        }
    }

    public static final SpeciesAlias getRealSpeciesAlias(SBModel sbModel, PluginSpeciesAlias pSpeciesAlias) {
        SpeciesAlias alias = null;
        try {
            Species origin = sbModel.getModel().getSpecies(pSpeciesAlias.getSpecies().getId());
            if (origin == null) {
                return alias;
            }
            SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)origin, null);
            Vector listOfReferingAliases = annotation.getReferingAliases();
            int i = 0;
            while (i < listOfReferingAliases.size()) {
                SpeciesAlias aliass = (SpeciesAlias)listOfReferingAliases.get(i);
                if (aliass.getName().equals(pSpeciesAlias.getAliasID())) {
                    alias = aliass;
                    break;
                }
                ++i;
            }
            return alias;
        }
        catch (Exception myErr) {
            return null;
        }
    }

    public static final boolean resetMetaidAndAnnotationOfMiriam(SBModel sbModel) {
        Model model;
        block3: {
            try {
                sbModel.resetMetaIDs();
                model = sbModel.getModel();
                if (CelldUtil.resetMetaId(sbModel, (SBase)model)) break block3;
                return false;
            }
            catch (Exception myErr) {
                return false;
            }
        }
        ListOfSpecies listOfSpecies = model.getListOfSpecies();
        ListOfReactions listOfReactions = model.getListOfReactions();
        ListOfCompartments listOfCompartments = model.getListOfCompartments();
        ListOfParameters listOfParameters = model.getListOfParameters();
        ListOfFunctionDefinitions listOfFunctionDefinitions = model.getListOfFunctionDefinitions();
        ListOfUnitDefinitions listOfUnitDefinitions = model.getListOfUnitDefinitions();
        ListOfRules listOfRules = model.getListOfRules();
        ListOfEvents listOfEvents = model.getListOfEvents();
        ListOfSpeciesTypes listOfSpeciesTypes = model.getListOfSpeciesTypes();
        ListOfCompartmentTypes listOfCompartmentTypes = model.getListOfCompartmentTypes();
        ListOfInitialAssignments listOfInitialAssignments = model.getListOfInitialAssignments();
        ListOfConstraints listOfConstraints = model.getListOfConstraints();
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfSpecies);
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfReactions);
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfCompartments);
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfParameters);
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfFunctionDefinitions);
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfUnitDefinitions);
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfRules);
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfEvents);
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfSpeciesTypes);
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfCompartmentTypes);
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfInitialAssignments);
        CelldUtil.resetMetaId(sbModel, (ListOf)listOfConstraints);
        return true;
    }

    public static final boolean resetMetaId(SBModel sbModel, SBase sbase) {
        return CelldUtil.resetMetaId(sbModel, sbase, true);
    }

    public static final boolean resetMetaId(SBModel sbModel, SBase sbase, boolean addtoVector) {
        try {
            Vector vectMetaids = sbModel.getMetaIDs();
            if (vectMetaids == null) {
                vectMetaids = sbModel.resetMetaIDs();
            }
            String metaid = sbase.getMetaId();
            boolean needNewMetaId = false;
            if (metaid == null || metaid.trim().equals("")) {
                needNewMetaId = true;
            } else if (vectMetaids.contains(metaid)) {
                needNewMetaId = true;
            }
            if (needNewMetaId) {
                String id = sbase.getId();
                if (id != null && !id.trim().equals("") && !vectMetaids.contains(id)) {
                    sbase.setMetaId(id);
                } else {
                    sbase.setMetaId(sbModel.CreateNewMetaID(vectMetaids));
                }
            }
            if (addtoVector) {
                vectMetaids.add(sbase.getMetaId());
            }
            SBMLFiler.resetAnnotationOfMiriam(sbase);
        }
        catch (Exception myErr) {
            return false;
        }
        return true;
    }

    private static final void resetMetaId(SBModel sbModel, ListOf list) {
        if (list == null || list.size() <= 0L) {
            return;
        }
        int cnt = 0;
        while ((long)cnt < list.size()) {
            SBase sbase = list.get((long)cnt);
            if (sbase instanceof Reaction) {
                Reaction reaction = (Reaction)sbase;
                CelldUtil.resetMetaId(sbModel, (SBase)reaction);
                ListOfSpeciesReferences lst1 = reaction.getListOfReactants();
                ListOfSpeciesReferences lst2 = reaction.getListOfProducts();
                ListOfSpeciesReferences lst3 = reaction.getListOfModifiers();
                CelldUtil.resetMetaId(sbModel, (ListOf)lst1);
                CelldUtil.resetMetaId(sbModel, (ListOf)lst2);
                CelldUtil.resetMetaId(sbModel, (ListOf)lst3);
                KineticLaw kineticLaw = reaction.getKineticLaw();
                if (kineticLaw != null) {
                    CelldUtil.resetMetaId(sbModel, (SBase)kineticLaw);
                    ListOfParameters listOfParameters = kineticLaw.getListOfParameters();
                    CelldUtil.resetMetaId(sbModel, (ListOf)listOfParameters);
                }
            } else if (sbase instanceof UnitDefinition) {
                UnitDefinition unitdef = (UnitDefinition)sbase;
                CelldUtil.resetMetaId(sbModel, (SBase)unitdef);
                ListOfUnits listOfUnits = unitdef.getListOfUnits();
                CelldUtil.resetMetaId(sbModel, (ListOf)listOfUnits);
            } else if (sbase instanceof Rule) {
                if (sbase instanceof AlgebraicRule) {
                    AlgebraicRule algebraicRule = (AlgebraicRule)sbase;
                    CelldUtil.resetMetaId(sbModel, (SBase)algebraicRule);
                } else if (sbase instanceof AssignmentRule) {
                    AssignmentRule assignmentRule = (AssignmentRule)sbase;
                    CelldUtil.resetMetaId(sbModel, (SBase)assignmentRule);
                } else if (sbase instanceof RateRule) {
                    RateRule rateRule = (RateRule)sbase;
                    CelldUtil.resetMetaId(sbModel, (SBase)rateRule);
                } else {
                    CelldUtil.resetMetaId(sbModel, sbase);
                }
            } else if (sbase instanceof Event) {
                Delay delay;
                Event event = (Event)sbase;
                CelldUtil.resetMetaId(sbModel, sbase);
                Trigger trigger = event.getTrigger();
                if (trigger != null) {
                    CelldUtil.resetMetaId(sbModel, (SBase)trigger);
                }
                if ((delay = event.getDelay()) != null) {
                    CelldUtil.resetMetaId(sbModel, (SBase)delay);
                }
                ListOfEventAssignments listOfEventAssignments = event.getListOfEventAssignments();
                CelldUtil.resetMetaId(sbModel, (ListOf)listOfEventAssignments);
            } else {
                CelldUtil.resetMetaId(sbModel, sbase);
            }
            ++cnt;
        }
    }

    public static final Vector foundAllParentComplexNodes(GElement alias) {
        if (!(alias instanceof SpeciesAlias)) {
            return null;
        }
        return CelldUtil.foundAllParentComplexNodes((SpeciesAlias)alias, null);
    }

    public static final Vector foundAllParentComplexNodes(SpeciesAlias alias, Vector v) {
        if (v == null) {
            v = new Vector<GContainer>();
        }
        if (alias == null) {
            return v;
        }
        GContainer container = alias.getContainer();
        if (container instanceof ComplexSpeciesAlias) {
            v.add(container);
            return CelldUtil.foundAllParentComplexNodes((ComplexSpeciesAlias)container, v);
        }
        return v;
    }

    public static final ComplexSpeciesAlias getBottomParentComplex(Vector v) {
        if (v == null || v.size() <= 0) {
            return null;
        }
        Object alias = v.get(v.size() - 1);
        if (alias instanceof ComplexSpeciesAlias) {
            return (ComplexSpeciesAlias)alias;
        }
        return null;
    }

    public static final boolean issameIgnoreCase(String a, String b) {
        try {
            if (a.compareToIgnoreCase(b) == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static final boolean issameIgnoreCaseIgnoreSpace(String a, String b) {
        return CelldUtil.issameIgnoreCase(a.trim(), b.trim());
    }

    public static final boolean beginwithIgnoreCase(String strAny, String strAnyBegin) {
        try {
            if (strAny.toLowerCase().startsWith(strAnyBegin.toLowerCase())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static final boolean beginwithIgnoreCaseIgnoreSpace(String strAny, String strAnyBegin) {
        return CelldUtil.beginwithIgnoreCase(strAny.trim(), strAnyBegin.trim());
    }

    public static final boolean containsIgnoreCase(String strAny, String strAnyInner) {
        try {
            if (strAny.toLowerCase().contains(strAnyInner.toLowerCase())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static final boolean containsIgnoreCaseIgnoreSpace(String strAny, String strAnyInner) {
        return CelldUtil.containsIgnoreCase(strAny.trim(), strAnyInner.trim());
    }

    public static final int dotInWhereOfLine(Point2D.Double start, Point2D.Double end, Point2D.Double any) {
        double dLENofStartPointNewPoint = 0.0;
        double dLENofEndPointNewPoint = 0.0;
        try {
            double x1 = any.x;
            double y1 = any.y;
            dLENofStartPointNewPoint = start.distance(x1, y1);
            dLENofEndPointNewPoint = end.distance(x1, y1);
        }
        catch (Exception myErr) {
            dLENofStartPointNewPoint = 0.0;
            dLENofEndPointNewPoint = 0.0;
        }
        if (dLENofStartPointNewPoint == dLENofEndPointNewPoint) {
            return 0;
        }
        if (dLENofStartPointNewPoint < dLENofEndPointNewPoint) {
            return -1;
        }
        return 1;
    }
}

