/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesSbgnViewerSymbol;
import jp.sbi.celldesigner.SpeciesShadeSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class Truncated
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol,
SpeciesSbgnViewerSymbol,
SpeciesShadeSymbol {
    public static final String CODENAME = "TRUNCATED";
    private boolean isDrawShade = false;
    private Area shapeShade = null;
    private static final double ROUND_RADIUS = 10.0;
    GeneralPath inner;
    GeneralPath a;
    GeneralPath af;
    Rectangle2D.Double rect = null;
    Point2D.Double[] points = new Point2D.Double[10];
    RoundRectangle2D.Double viewerinner;
    RoundRectangle2D.Double viewera;
    RoundRectangle2D.Double vieweraf;
    private PaintScheme painter = null;
    public static final double defaultAngle = -1.5707963267948966;

    public Truncated() {
        this.inner = new GeneralPath();
        this.a = new GeneralPath();
        this.af = new GeneralPath();
        this.rect = new Rectangle2D.Double();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean isProtein() {
        return true;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(80, 40);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            if (this.isInSBGNViewer()) {
                return this.viewerinner.contains(x, y);
            }
            return this.a.contains(x, y);
        }
        if (this.isInSBGNViewer()) {
            return this.viewerinner.contains(x, y);
        }
        return this.inner.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        if (this.isInSBGNViewer()) {
            return this.viewerinner.contains(x, y);
        }
        if (x < this.rect.x + 0.8 * this.rect.width || y < this.rect.y + 0.4 * this.rect.height) {
            return this.inner.contains(x, y);
        }
        return x <= this.rect.x + this.rect.width && y <= this.rect.y + 0.5 * this.rect.height;
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        this.setPath(this.inner, x, y, w, h, 10.0, 0.2 * w, 0.6 * h, 0.4 * h);
        this.setPath(this.a, x - 4.0, y - 4.0, w + 8.0, h + 8.0, 14.0, 0.2 * w, 0.6 * h, 0.4 * h);
        this.setPath(this.af, x - 3.0, y - 3.0, w + 6.0, h + 6.0, 13.0, 0.2 * w, 0.6 * h, 0.4 * h);
        this.rect.setFrame(x, y, w, h);
        GUtil2.setEdgePoints(this.rect, this.inner, this.points);
        this.points[8].x = x + w - 0.6 * h;
        this.points[8].y = y + h;
        this.points[9].x = x + w;
        this.points[9].y = y + 0.75 * h;
        if (this.isInSBGNViewer()) {
            this.viewerinner = new RoundRectangle2D.Double();
            this.viewera = new RoundRectangle2D.Double();
            this.vieweraf = new RoundRectangle2D.Double();
            this.rect = new Rectangle2D.Double();
            this.viewerinner.setRoundRect(x, y, w, h, 10.0, 10.0);
            this.viewera = (RoundRectangle2D.Double)this.viewerinner.clone();
            this.vieweraf = (RoundRectangle2D.Double)this.viewerinner.clone();
            this.rect.setFrame(x, y, w, h);
            GUtil2.setEdgePoints(this.rect, this.viewerinner, this.points);
            this.points[8].x = this.points[7].x;
            this.points[8].y = this.points[7].y;
            this.points[9].x = this.points[7].x;
            this.points[9].y = this.points[7].y;
        }
        Rectangle2D.Double rectTemp = new Rectangle2D.Double(x, y, w, h * 0.75);
        RoundRectangle2D.Double innerTemp = new RoundRectangle2D.Double();
        innerTemp.setRoundRect(x, y, w, h, 10.0, 10.0);
        this.shapeShade = new Area(innerTemp);
        Area areaTwo = new Area(rectTemp);
        this.shapeShade.subtract(areaTwo);
    }

    private void setPath(GeneralPath path, double X, double Y, double W, double H, double R, double S, double T1, double T2) {
        float x = (float)X;
        float y = (float)Y;
        float w = (float)W;
        float h = (float)H;
        float r = (float)R;
        float s = (float)S;
        float t1 = (float)T1;
        float t2 = (float)T2;
        path.reset();
        path.moveTo(x + r, y);
        path.quadTo(x, y, x, y + r);
        path.lineTo(x, y + h - r);
        path.quadTo(x, y + h, x + r, y + h);
        path.lineTo(x + w - s, y + h);
        path.lineTo(x + w - s, y + h - t1);
        path.lineTo(x + w, y + h - t2);
        path.lineTo(x + w, y);
        path.lineTo(x + r, y);
        path.closePath();
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        if (this.isInSBGNViewer()) {
            Rectangle rect = this.viewerinner.getBounds();
            return new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        }
        Rectangle2D.Float r = (Rectangle2D.Float)this.inner.getBounds2D();
        return new Rectangle2D.Double(r.x, r.y, r.width, r.height);
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        if (this.isInSBGNViewer()) {
            Rectangle r = this.viewerinner.getBounds();
            return new Rectangle2D.Double(r.x, r.y, r.width, r.height);
        }
        Rectangle2D.Float r = (Rectangle2D.Float)this.a.getBounds2D();
        return new Rectangle2D.Double(r.x, r.y, r.width, r.height);
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        if (!this.isInSBGNViewer()) {
            g2.draw(this.a);
        }
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        if (!this.isInSBGNViewer()) {
            g2.fill(this.af);
        }
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        if (this.bPaintSymbolFrameUsingSpecifiedColor) {
            if (this.colorSpecified != null) {
                Color originalColor = g2.getColor();
                g2.setColor(this.colorSpecified);
                if (this.isInSBGNViewer()) {
                    g2.fill(this.viewerinner);
                } else {
                    g2.fill(this.inner);
                }
                g2.setColor(originalColor);
                if (this.isInSBGNViewer()) {
                    this.painter.drawDefaultColorEdge(g2, this.viewerinner, colorflg);
                } else {
                    this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
                }
            }
            return;
        }
        if (this.isInSBGNViewer()) {
            this.painter.fillPaint(g2, this.viewerinner, colorflg);
            if (this.isDrawShade) {
                Color colorBak = g2.getColor();
                g2.setColor(SHADE_COLOR);
                g2.fill(this.shapeShade);
                g2.setColor(colorBak);
            }
            this.painter.drawDefaultColorEdge(g2, this.viewerinner, colorflg);
        } else {
            this.painter.fillPaint(g2, this.inner, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
        }
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        if (this.isInSBGNViewer()) {
            Point2D.Double p = Truncated.getCoordinatesOfLinkPositionByInternalIndex(this.getSymbolBounds(), index);
            switch (index) {
                case 0: {
                    p.x += 1.0;
                    p.y += 1.0;
                    break;
                }
                case 4: {
                    p.x -= 1.0;
                    p.y += 1.0;
                    break;
                }
                case 8: {
                    p.x -= 1.0;
                    p.y -= 1.0;
                    break;
                }
                case 12: {
                    p.x += 1.0;
                    p.y -= 1.0;
                }
            }
            return p;
        }
        Rectangle2D.Double r = this.getSymbolBounds();
        Point2D.Double p = Truncated.getCoordinatesOfLinkPositionByInternalIndex(r, index);
        switch (index) {
            case 0: {
                p.x += 2.0;
                p.y += 2.0;
                break;
            }
            case 5: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width, r.y);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width, r.y + r.height * 0.6);
                return this.meanPoint(p1, p2, 0.5);
            }
            case 6: {
                Point2D.Double p2 = new Point2D.Double(r.x + r.width, r.y + r.height * 0.6);
                return p2;
            }
            case 7: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width * 0.8, r.y + r.height * 0.4);
                return p1;
            }
            case 8: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width * 0.8, r.y + r.height * 0.4);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width * 0.8, r.y + r.height);
                return this.meanPoint(p1, p2, 0.5);
            }
            case 9: {
                Point2D.Double p2 = new Point2D.Double(r.x + r.width * 0.8, r.y + r.height);
                return p2;
            }
            case 10: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width * 0.8, r.y + r.height);
                Point2D.Double p2 = new Point2D.Double(r.x, r.y + r.height);
                return this.meanPoint(p1, p2, 0.666666666666666);
            }
            case 11: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width * 0.8, r.y + r.height);
                Point2D.Double p2 = new Point2D.Double(r.x, r.y + r.height);
                return this.meanPoint(p1, p2, 0.333333333333333);
            }
            case 12: {
                p.x += 2.0;
                p.y -= 2.0;
            }
        }
        return p;
    }

    @Override
    public void setIsDrawShade(boolean isDrawShade) {
        this.isDrawShade = isDrawShade;
    }

    @Override
    public boolean isDrawShade() {
        return this.isDrawShade;
    }

    @Override
    public Area getOutterShape() {
        if (this.isInSBGNViewer()) {
            return new Area(this.viewerinner);
        }
        return new Area(this.inner);
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }
}

