/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class Tag
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol {
    public static final String CODENAME = "TAG";
    private Line2D.Double line1 = new Line2D.Double();
    private Line2D.Double line2 = new Line2D.Double();
    private Line2D.Double line3 = new Line2D.Double();
    private Line2D.Double line4 = new Line2D.Double();
    private Line2D.Double line5 = new Line2D.Double();
    private Polygon inner = new Polygon();
    private Polygon a = new Polygon();
    private Polygon af = new Polygon();
    private Rectangle2D.Double rect = new Rectangle2D.Double();
    private Point2D.Double[] inouttershapeKeypositions = new Point2D.Double[8];
    private Point2D.Double[] anchorpointPositions = new Point2D.Double[16];
    private PaintScheme painter = null;
    private GeneralPath paintpath = new GeneralPath();
    public static final String xmlfileFieldname_TagDirect = "direct";
    public static final String tagDirectUP = "UP";
    public static final String tagDirectDOWN = "DOWN";
    public static final String tagDirectLEFT = "LEFT";
    public static final String tagDirectRIGHT = "RIGHT";
    public static final String tagDirectAUTO = "AUTO";
    public static final Vector AllAagDirect = new Vector();
    public static final String tagDirectDEFAULT = "RIGHT";
    private String tagdirect = "RIGHT";
    private SharpPoint sharppoint = new SharpPoint();
    public static final double defaultAngle = -1.5707963267948966;

    static {
        AllAagDirect.add(tagDirectUP);
        AllAagDirect.add(tagDirectDOWN);
        AllAagDirect.add(tagDirectLEFT);
        AllAagDirect.add("RIGHT");
        AllAagDirect.add(tagDirectAUTO);
    }

    public String getTagDirect() {
        return this.tagdirect;
    }

    public void setTagDirect(String direct) {
        if (direct == null) {
            return;
        }
        if (!AllAagDirect.contains(direct)) {
            return;
        }
        this.tagdirect = direct;
    }

    public SharpPoint getSharpPoint() {
        return this.sharppoint;
    }

    public Tag() {
        int i = 0;
        while (i < this.inouttershapeKeypositions.length) {
            this.inouttershapeKeypositions[i] = new Point2D.Double();
            ++i;
        }
        i = 0;
        while (i < this.anchorpointPositions.length) {
            this.anchorpointPositions[i] = new Point2D.Double();
            ++i;
        }
    }

    public Tag(double x, double y, double w, double h) {
        new Tag(x, y, w, h, "RIGHT");
    }

    public Tag(double x, double y, double w, double h, String direct) {
        Tag tag = new Tag();
        tag.resetSymbolBounds(x, y, w, h, direct);
    }

    public void resetSymbolBounds(double x, double y, double w, double h, String direct) {
        this.setTagDirect(direct);
        this.setSymbolBounds(x, y, w, h);
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public boolean isProtein() {
        return false;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(80, 40);
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public int pointsSize() {
        return this.inouttershapeKeypositions.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.inouttershapeKeypositions;
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        Rectangle rect = this.inner.getBounds();
        return new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        this.buildShape(x, y, w, h);
        this.inner = this.createPolygon((int)x, (int)y, (int)w, (int)h);
        this.a = this.createPolygon((int)(x - 4.0), (int)(y - 4.0), (int)(w + 8.0), (int)(h + 8.0));
        this.af = this.createPolygon((int)(x - 3.0), (int)(y - 3.0), (int)(w + 6.0), (int)(h + 6.0));
        this.rect.setFrame(x, y, w, h);
        GUtil2.setEdgePoints(this.rect, this.inner, this.inouttershapeKeypositions);
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        Rectangle rect = this.a.getBounds();
        return new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public boolean inInner(double x, double y) {
        return this.inner.contains(x, y);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            return this.a.contains(x, y);
        }
        return this.inner.contains(x, y);
    }

    public boolean intersectsShape(Rectangle2D rec, boolean isActive) {
        if (isActive) {
            return this.a.intersects(rec);
        }
        return this.inner.intersects(rec);
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        if (index < 0 || index > 15) {
            return null;
        }
        return this.anchorpointPositions[index];
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        g2.draw(this.a);
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        g2.fill(this.af);
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        this.painter.fillPaint(g2, this.paintpath, colorflg);
        this.painter.drawDefaultColorEdge(g2, this.paintpath, colorflg);
    }

    private void buildShape(double x, double y, double w, double h) {
        if (w < 0.0 || h < 0.0) {
            return;
        }
        Vector vect = this.calcKeyPointsUsingFrameBound(x, y, w, h);
        if (vect == null) {
            return;
        }
        Point2D.Double[] positions = (Point2D.Double[])vect.get(0);
        if (positions == null) {
            return;
        }
        int pointer = 0;
        Point2D.Double p1 = positions[pointer++];
        Point2D.Double p2 = positions[pointer++];
        Point2D.Double p3 = positions[pointer++];
        Point2D.Double p4 = positions[pointer++];
        Point2D.Double p5 = positions[pointer++];
        this.line1.setLine(new Point2D.Double(p1.x, p1.y), new Point2D.Double(p2.x, p2.y));
        this.line2.setLine(new Point2D.Double(p2.x, p2.y), new Point2D.Double(p3.x, p3.y));
        this.line3.setLine(new Point2D.Double(p3.x, p3.y), new Point2D.Double(p4.x, p4.y));
        this.line4.setLine(new Point2D.Double(p4.x, p4.y), new Point2D.Double(p5.x, p5.y));
        this.line5.setLine(new Point2D.Double(p5.x, p5.y), new Point2D.Double(p1.x, p1.y));
        this.paintpath = new GeneralPath();
        this.paintpath.reset();
        this.paintpath.moveTo((float)this.line1.x1, (float)this.line1.y1);
        this.paintpath.lineTo((float)this.line2.x1, (float)this.line2.y1);
        this.paintpath.lineTo((float)this.line3.x1, (float)this.line3.y1);
        this.paintpath.lineTo((float)this.line4.x1, (float)this.line4.y1);
        this.paintpath.lineTo((float)this.line5.x1, (float)this.line5.y1);
        this.paintpath.lineTo((float)this.line1.x1, (float)this.line1.y1);
        this.paintpath.closePath();
        positions = (Point2D.Double[])vect.get(1);
        if (positions == null) {
            return;
        }
        this.anchorpointPositions = positions;
        this.anchorpointPositions = Tag.changePositionOrder(this.anchorpointPositions);
        this.sharppoint.indexAnchorpoint = 4;
        if (this.tagdirect.equals(tagDirectUP)) {
            this.sharppoint.indexAnchorpoint = 0;
        } else if (this.tagdirect.equals(tagDirectDOWN)) {
            this.sharppoint.indexAnchorpoint = 8;
        } else if (this.tagdirect.equals(tagDirectLEFT)) {
            this.sharppoint.indexAnchorpoint = 12;
        } else if (this.tagdirect.equals("RIGHT")) {
            this.sharppoint.indexAnchorpoint = 4;
        }
        this.sharppoint.SharpPoint = (Point2D.Double)this.anchorpointPositions[this.sharppoint.indexAnchorpoint].clone();
    }

    public static Point2D.Double[] changePositionOrder(Point2D.Double[] input) {
        Point2D.Double[] positions = new Point2D.Double[]{(Point2D.Double)input[14].clone(), (Point2D.Double)input[15].clone(), (Point2D.Double)input[0].clone(), (Point2D.Double)input[1].clone(), (Point2D.Double)input[2].clone(), (Point2D.Double)input[3].clone(), (Point2D.Double)input[4].clone(), (Point2D.Double)input[5].clone(), (Point2D.Double)input[6].clone(), (Point2D.Double)input[7].clone(), (Point2D.Double)input[8].clone(), (Point2D.Double)input[9].clone(), (Point2D.Double)input[10].clone(), (Point2D.Double)input[11].clone(), (Point2D.Double)input[12].clone(), (Point2D.Double)input[13].clone()};
        return positions;
    }

    protected Polygon createPolygon(double x, double y, double w, double h) {
        Vector vect = this.calcKeyPointsUsingFrameBound(x, y, w, h);
        if (vect == null) {
            return new Polygon();
        }
        Point2D.Double[] positions = (Point2D.Double[])vect.get(0);
        if (positions == null) {
            return new Polygon();
        }
        int pointer = 0;
        Point2D.Double p1 = positions[pointer++];
        Point2D.Double p2 = positions[pointer++];
        Point2D.Double p3 = positions[pointer++];
        Point2D.Double p4 = positions[pointer++];
        Point2D.Double p5 = positions[pointer++];
        Polygon inner = new Polygon();
        inner.addPoint((int)p1.x, (int)p1.y);
        inner.addPoint((int)p2.x, (int)p2.y);
        inner.addPoint((int)p3.x, (int)p3.y);
        inner.addPoint((int)p4.x, (int)p4.y);
        inner.addPoint((int)p5.x, (int)p5.y);
        return inner;
    }

    private Vector calcKeyPointsUsingFrameBound(double x, double y, double w, double h) {
        return this.calcKeyPointsUsingFrameBound(x, y, w, h, this.tagdirect);
    }

    private Vector calcKeyPointsUsingFrameBound(double x, double y, double w, double h, String direct) {
        Vector<Point2D.Double[]> rtn = new Vector<Point2D.Double[]>();
        if (w < 0.0 || h < 0.0) {
            return null;
        }
        Point2D.Double[] frameKeyPoints = new Point2D.Double[5];
        int i = 0;
        while (i < frameKeyPoints.length) {
            frameKeyPoints[i] = new Point2D.Double();
            ++i;
        }
        Point2D.Double[] anchorKeyPoints = new Point2D.Double[16];
        int i2 = 0;
        while (i2 < anchorKeyPoints.length) {
            anchorKeyPoints[i2] = new Point2D.Double();
            ++i2;
        }
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        Point2D.Double p3 = new Point2D.Double();
        Point2D.Double p4 = new Point2D.Double();
        Point2D.Double p5 = new Point2D.Double();
        if (this.tagdirect.equals(tagDirectUP)) {
            p1 = new Point2D.Double(x, y + h);
            p2 = new Point2D.Double(p1.x, p1.y - h * 4.0 / 6.0);
            p3 = new Point2D.Double(p1.x + w / 2.0, p1.y - h);
            p4 = new Point2D.Double(p1.x + w, p2.y);
            p5 = new Point2D.Double(p4.x, p1.y);
        } else if (this.tagdirect.equals(tagDirectDOWN)) {
            p1 = new Point2D.Double(x + w, y);
            p2 = new Point2D.Double(p1.x, p1.y + h * 4.0 / 6.0);
            p3 = new Point2D.Double(p1.x - w / 2.0, p1.y + h);
            p4 = new Point2D.Double(p1.x - w, p2.y);
            p5 = new Point2D.Double(p4.x, p1.y);
        } else if (this.tagdirect.equals(tagDirectLEFT)) {
            p1 = new Point2D.Double(x + w, y + h);
            p2 = new Point2D.Double(p1.x - w * 4.0 / 6.0, p1.y);
            p3 = new Point2D.Double(p1.x - w, p1.y - h / 2.0);
            p4 = new Point2D.Double(p2.x, p2.y - h);
            p5 = new Point2D.Double(p1.x, p4.y);
        } else if (this.tagdirect.equals("RIGHT")) {
            p1 = new Point2D.Double(x, y);
            p2 = new Point2D.Double(p1.x + w * 4.0 / 6.0, p1.y);
            p3 = new Point2D.Double(p1.x + w, p1.y + h / 2.0);
            p4 = new Point2D.Double(p2.x, p2.y + h);
            p5 = new Point2D.Double(p1.x, p4.y);
        }
        int pointer = 0;
        frameKeyPoints[pointer++] = p1;
        frameKeyPoints[pointer++] = p2;
        frameKeyPoints[pointer++] = p3;
        frameKeyPoints[pointer++] = p4;
        frameKeyPoints[pointer++] = p5;
        rtn.add(frameKeyPoints);
        if (this.tagdirect.equals(tagDirectUP)) {
            anchorKeyPoints[0] = p3;
            anchorKeyPoints[1] = new Point2D.Double((p4.x + p3.x) / 2.0, (p4.y + p3.y) / 2.0);
            anchorKeyPoints[2] = p4;
            anchorKeyPoints[3] = new Point2D.Double(p4.x, p4.y + h * 1.0 / 6.0);
            anchorKeyPoints[4] = new Point2D.Double(p4.x, p4.y + h * 2.0 / 6.0);
            anchorKeyPoints[5] = new Point2D.Double(p4.x, p4.y + h * 3.0 / 6.0);
            anchorKeyPoints[6] = p5;
            anchorKeyPoints[7] = new Point2D.Double(p5.x - w * 1.0 / 4.0, p5.y);
            anchorKeyPoints[8] = new Point2D.Double(p5.x - w * 2.0 / 4.0, p5.y);
            anchorKeyPoints[9] = new Point2D.Double(p5.x - w * 3.0 / 4.0, p5.y);
            anchorKeyPoints[10] = p1;
            anchorKeyPoints[11] = new Point2D.Double(p2.x, p2.y + h * 3.0 / 6.0);
            anchorKeyPoints[12] = new Point2D.Double(p2.x, p2.y + h * 2.0 / 6.0);
            anchorKeyPoints[13] = new Point2D.Double(p2.x, p2.y + h * 1.0 / 6.0);
            anchorKeyPoints[14] = p2;
            anchorKeyPoints[15] = new Point2D.Double((p2.x + p3.x) / 2.0, (p2.y + p3.y) / 2.0);
        } else if (this.tagdirect.equals(tagDirectDOWN)) {
            anchorKeyPoints[0] = new Point2D.Double(p5.x + w * 2.0 / 4.0, p5.y);
            anchorKeyPoints[1] = new Point2D.Double(p5.x + w * 3.0 / 4.0, p5.y);
            anchorKeyPoints[2] = p1;
            anchorKeyPoints[3] = new Point2D.Double(p1.x, p1.y + h * 1.0 / 6.0);
            anchorKeyPoints[4] = new Point2D.Double(p1.x, p1.y + h * 2.0 / 6.0);
            anchorKeyPoints[5] = new Point2D.Double(p1.x, p1.y + h * 3.0 / 6.0);
            anchorKeyPoints[6] = p2;
            anchorKeyPoints[7] = new Point2D.Double((p2.x + p3.x) / 2.0, (p2.y + p3.y) / 2.0);
            anchorKeyPoints[8] = p3;
            anchorKeyPoints[9] = new Point2D.Double((p4.x + p3.x) / 2.0, (p4.y + p3.y) / 2.0);
            anchorKeyPoints[10] = p4;
            anchorKeyPoints[11] = new Point2D.Double(p5.x, p5.y + h * 3.0 / 6.0);
            anchorKeyPoints[12] = new Point2D.Double(p5.x, p5.y + h * 2.0 / 6.0);
            anchorKeyPoints[13] = new Point2D.Double(p5.x, p5.y + h * 1.0 / 6.0);
            anchorKeyPoints[14] = p5;
            anchorKeyPoints[15] = new Point2D.Double(p5.x + w * 1.0 / 4.0, p5.y);
        } else if (this.tagdirect.equals(tagDirectLEFT)) {
            anchorKeyPoints[0] = new Point2D.Double(p4.x + w * 2.0 / 6.0, p4.y);
            anchorKeyPoints[1] = new Point2D.Double(p4.x + w * 3.0 / 6.0, p4.y);
            anchorKeyPoints[2] = p5;
            anchorKeyPoints[3] = new Point2D.Double(p5.x, p5.y + h * 1.0 / 4.0);
            anchorKeyPoints[4] = new Point2D.Double(p5.x, p5.y + h * 2.0 / 4.0);
            anchorKeyPoints[5] = new Point2D.Double(p5.x, p5.y + h * 3.0 / 4.0);
            anchorKeyPoints[6] = p1;
            anchorKeyPoints[7] = new Point2D.Double(p1.x - w * 1.0 / 6.0, p1.y);
            anchorKeyPoints[8] = new Point2D.Double(p1.x - w * 2.0 / 6.0, p1.y);
            anchorKeyPoints[9] = new Point2D.Double(p1.x - w * 3.0 / 6.0, p1.y);
            anchorKeyPoints[10] = p2;
            anchorKeyPoints[11] = new Point2D.Double((p2.x + p3.x) / 2.0, (p2.y + p3.y) / 2.0);
            anchorKeyPoints[12] = p3;
            anchorKeyPoints[13] = new Point2D.Double((p4.x + p3.x) / 2.0, (p4.y + p3.y) / 2.0);
            anchorKeyPoints[14] = p4;
            anchorKeyPoints[15] = new Point2D.Double(p4.x + w * 1.0 / 6.0, p4.y);
        } else if (this.tagdirect.equals("RIGHT")) {
            anchorKeyPoints[0] = new Point2D.Double(p1.x + w * 2.0 / 6.0, p1.y);
            anchorKeyPoints[1] = new Point2D.Double(p1.x + w * 3.0 / 6.0, p1.y);
            anchorKeyPoints[2] = p2;
            anchorKeyPoints[3] = new Point2D.Double((p2.x + p3.x) / 2.0, (p2.y + p3.y) / 2.0);
            anchorKeyPoints[4] = p3;
            anchorKeyPoints[5] = new Point2D.Double((p4.x + p3.x) / 2.0, (p4.y + p3.y) / 2.0);
            anchorKeyPoints[6] = p4;
            anchorKeyPoints[7] = new Point2D.Double(p5.x + w * 3.0 / 6.0, p5.y);
            anchorKeyPoints[8] = new Point2D.Double(p5.x + w * 2.0 / 6.0, p5.y);
            anchorKeyPoints[9] = new Point2D.Double(p5.x + w * 1.0 / 6.0, p5.y);
            anchorKeyPoints[10] = p5;
            anchorKeyPoints[11] = new Point2D.Double(p1.x, p1.y + h * 3.0 / 4.0);
            anchorKeyPoints[12] = new Point2D.Double(p1.x, p1.y + h * 2.0 / 4.0);
            anchorKeyPoints[13] = new Point2D.Double(p1.x, p1.y + h * 1.0 / 4.0);
            anchorKeyPoints[14] = p1;
            anchorKeyPoints[15] = new Point2D.Double(p1.x + w * 1.0 / 6.0, p1.y);
        }
        rtn.add(anchorKeyPoints);
        return rtn;
    }

    @Override
    public Area getOutterShape() {
        return new Area(this.inner);
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }

    public class SharpPoint {
        public int indexAnchorpoint = 4;
        public Point2D.Double SharpPoint = new Point2D.Double();
    }
}

