/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesShadeSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class SimpleMolecule
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol,
SpeciesShadeSymbol {
    public static final String CODENAME = "SIMPLE_MOLECULE";
    public static final int CHORD = 1;
    private boolean isDrawShade = false;
    Ellipse2D.Double inner;
    Ellipse2D.Double a;
    Ellipse2D.Double af;
    Rectangle2D.Double rect = null;
    Point2D.Double[] points = new Point2D.Double[8];
    private PaintScheme painter = null;
    Area shapeShade = null;
    public static final double defaultAngle = -1.5707963267948966;

    public SimpleMolecule() {
        this.inner = new Ellipse2D.Double();
        this.a = new Ellipse2D.Double();
        this.af = new Ellipse2D.Double();
        this.rect = new Rectangle2D.Double();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean isProtein() {
        return false;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(70, 25);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            return this.a.contains(x, y);
        }
        return this.inner.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        return this.inner.contains(x, y);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        if (this.isInSBGNViewer()) {
            this.inner.setFrame(w > h ? x + w / 2.0 - h / 2.0 : x, w > h ? y : y + h / 2.0 - w / 2.0, w > h ? h : w, w > h ? h : w);
        } else {
            this.inner.setFrame(x, y, w, h);
        }
        this.a.setFrame(x - 4.0, y - 4.0, w + 8.0, h + 8.0);
        this.af.setFrame(x - 3.0, y - 3.0, w + 6.0, h + 6.0);
        this.rect.setFrame(x, y, w, h);
        GUtil2.setEdgePoints(this.rect, this.inner, this.points);
        Rectangle2D.Double rectTemp = new Rectangle2D.Double(x, y, w, w > h ? h * 0.75 : (w + h) / 2.0 - w * 0.25);
        this.shapeShade = new Area(this.inner);
        Area areaTwo = new Area(rectTemp);
        this.shapeShade.subtract(areaTwo);
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        return new Rectangle2D.Double(this.inner.getX(), this.inner.getY(), this.inner.getWidth(), this.inner.getHeight());
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        return new Rectangle2D.Double(this.a.getX(), this.a.getY(), this.a.getWidth(), this.a.getHeight());
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        g2.draw(this.a);
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        g2.fill(this.af);
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        if (this.bPaintSymbolFrameUsingSpecifiedColor) {
            if (this.colorSpecified != null) {
                Color originalColor = g2.getColor();
                g2.setColor(this.colorSpecified);
                g2.fill(this.inner);
                g2.setColor(originalColor);
                this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
            }
            return;
        }
        this.painter.fillPaint(g2, this.inner, colorflg);
        if (this.isInSBGNViewer() && this.isDrawShade) {
            Color colorBak = g2.getColor();
            g2.setColor(SHADE_COLOR);
            g2.fill(this.shapeShade);
            g2.setColor(colorBak);
        }
        this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    protected static Point2D.Double getCoordinatesOfLinkPositionByInternalIndexStatic(Rectangle2D.Double r, int index) {
        double radiusw = r.width * 0.5;
        double radiush = r.height * 0.5;
        double radius = radiusw;
        Point2D.Double p0 = new Point2D.Double(r.x + radiusw, r.y + radiush);
        switch (index) {
            case 0: {
                double d1 = radiusw * sin_45;
                double d2 = radiush * sin_45;
                p0.x -= d1;
                p0.y -= d2;
                return p0;
            }
            case 1: {
                double d1 = radiusw * sin_225;
                double d2 = radiush * sin_675;
                p0.x -= d1;
                p0.y -= d2;
                return p0;
            }
            case 2: {
                p0.y -= radiush;
                return p0;
            }
            case 3: {
                double d1 = radiusw * sin_225;
                double d2 = radiush * sin_675;
                p0.x += d1;
                p0.y -= d2;
                return p0;
            }
            case 4: {
                double d1 = radiusw * sin_45;
                double d2 = radiush * sin_45;
                p0.x += d1;
                p0.y -= d2;
                return p0;
            }
            case 5: {
                double d1 = radiusw * sin_675;
                double d2 = radiush * sin_225;
                p0.x += d1;
                p0.y -= d2;
                return p0;
            }
            case 6: {
                p0.x += radiusw;
                return p0;
            }
            case 7: {
                double d1 = radiusw * sin_675;
                double d2 = radiush * sin_225;
                p0.x += d1;
                p0.y += d2;
                return p0;
            }
            case 8: {
                double d1 = radiusw * sin_45;
                double d2 = radiush * sin_45;
                p0.x += d1;
                p0.y += d2;
                return p0;
            }
            case 9: {
                double d1 = radiusw * sin_225;
                double d2 = radiush * sin_675;
                p0.x += d1;
                p0.y += d2;
                return p0;
            }
            case 10: {
                p0.y += radiush;
                return p0;
            }
            case 11: {
                double d1 = radiusw * sin_225;
                double d2 = radiush * sin_675;
                p0.x -= d1;
                p0.y += d2;
                return p0;
            }
            case 12: {
                double d1 = radiusw * sin_45;
                double d2 = radiush * sin_45;
                p0.x -= d1;
                p0.y += d2;
                return p0;
            }
            case 13: {
                double d1 = radiusw * sin_675;
                double d2 = radiush * sin_225;
                p0.x -= d1;
                p0.y += d2;
                return p0;
            }
            case 14: {
                p0.x -= radiusw;
                return p0;
            }
            case 16: {
                p0.x = r.getCenterX();
                p0.y = r.getCenterY();
                return p0;
            }
        }
        double d1 = radiusw * sin_675;
        double d2 = radiush * sin_225;
        p0.x -= d1;
        p0.y -= d2;
        return p0;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        Rectangle2D.Double r = this.getSymbolBounds();
        return SimpleMolecule.getCoordinatesOfLinkPositionByInternalIndexStatic(r, index);
    }

    @Override
    public void setIsDrawShade(boolean isDrawShade) {
        this.isDrawShade = isDrawShade;
    }

    @Override
    public boolean isDrawShade() {
        return this.isDrawShade;
    }

    @Override
    public Area getOutterShape() {
        return new Area(this.inner);
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }
}

