/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesSbgnViewerSymbol;
import jp.sbi.celldesigner.SpeciesShadeSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class Receptor
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol,
SpeciesSbgnViewerSymbol,
SpeciesShadeSymbol {
    public static final String CODENAME = "RECEPTOR";
    private boolean isDrawShade = false;
    private Area shapeShade = null;
    private Polygon inner = new Polygon();
    private Polygon a = new Polygon();
    private Polygon af = new Polygon();
    private Point2D.Double[] points = new Point2D.Double[10];
    private PaintScheme painter = null;
    private static final double ROUND_RADIUS = 10.0;
    RoundRectangle2D.Double viewerinner;
    RoundRectangle2D.Double viewera;
    RoundRectangle2D.Double vieweraf;
    Rectangle2D.Double rect;
    public static final double defaultAngle = -1.5707963267948966;

    public Receptor() {
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean isProtein() {
        return true;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(80, 50);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            if (this.isInSBGNViewer()) {
                return this.viewerinner.contains(x, y);
            }
            return this.a.contains(x, y);
        }
        if (this.isInSBGNViewer()) {
            return this.viewerinner.contains(x, y);
        }
        return this.inner.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        if (this.isInSBGNViewer()) {
            return this.viewerinner.contains(x, y);
        }
        return this.inner.contains(x, y);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        this.inner = this.createPolygon(x, y, w, h);
        this.calcPoints(x, y, w, h);
        this.a = this.createPolygon(x - 4.0, y - 4.0, w + 8.0, h + 8.0);
        this.af = this.createPolygon(x - 3.0, y - 3.0, w + 6.0, h + 6.0);
        if (this.isInSBGNViewer()) {
            this.viewerinner = new RoundRectangle2D.Double();
            this.viewera = new RoundRectangle2D.Double();
            this.vieweraf = new RoundRectangle2D.Double();
            this.rect = new Rectangle2D.Double();
            this.viewerinner.setRoundRect(x, y, w, h, 10.0, 10.0);
            this.viewera = (RoundRectangle2D.Double)this.viewerinner.clone();
            this.vieweraf = (RoundRectangle2D.Double)this.viewerinner.clone();
            this.rect.setFrame(x, y, w, h);
            GUtil2.setEdgePoints(this.rect, this.viewerinner, this.points);
            this.points[8].x = this.points[7].x;
            this.points[8].y = this.points[7].y;
            this.points[9].x = this.points[7].x;
            this.points[9].y = this.points[7].y;
        }
        Rectangle2D.Double rectTemp = new Rectangle2D.Double(x, y, w, h * 0.75);
        RoundRectangle2D.Double innerTemp = new RoundRectangle2D.Double();
        innerTemp.setRoundRect(x, y, w, h, 10.0, 10.0);
        this.shapeShade = new Area(innerTemp);
        Area areaTwo = new Area(rectTemp);
        this.shapeShade.subtract(areaTwo);
    }

    protected Polygon createPolygon(double x, double y, double width, double height) {
        Polygon inner = new Polygon();
        inner.addPoint((int)x, (int)y);
        inner.addPoint((int)x, (int)(y + height * 0.8));
        inner.addPoint((int)(x + width / 2.0), (int)(y + height));
        inner.addPoint((int)(x + width), (int)(y + height * 0.8));
        inner.addPoint((int)(x + width), (int)y);
        inner.addPoint((int)(x + width / 2.0), (int)(y + height * 0.2));
        inner.addPoint((int)x, (int)y);
        return inner;
    }

    protected void calcPoints(double xD, double yD, double wD, double hD) {
        int x = (int)xD;
        int y = (int)yD;
        int width = (int)wD;
        int height = (int)hD;
        this.points[0].x = x;
        this.points[0].y = y;
        this.points[1].x = x;
        this.points[1].y = (double)y + (double)height * 0.8;
        this.points[2].x = (double)x + (double)width / 2.0;
        this.points[2].y = y + height;
        this.points[3].x = x + width;
        this.points[3].y = (double)y + (double)height * 0.8;
        this.points[4].x = x + width;
        this.points[4].y = y;
        this.points[5].x = (double)x + (double)width / 2.0;
        this.points[5].y = (double)y + (double)height * 0.2;
        this.points[6].x = (this.points[0].x + this.points[1].x) / 2.0;
        this.points[6].y = (this.points[0].y + this.points[1].y) / 2.0;
        this.points[7].x = (this.points[1].x + this.points[2].x) / 2.0;
        this.points[7].y = (this.points[1].y + this.points[2].y) / 2.0;
        this.points[8].x = (this.points[2].x + this.points[3].x) / 2.0;
        this.points[8].y = (this.points[2].y + this.points[3].y) / 2.0;
        this.points[9].x = (this.points[3].x + this.points[4].x) / 2.0;
        this.points[9].y = (this.points[3].y + this.points[4].y) / 2.0;
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        Rectangle rect = this.inner.getBounds();
        if (this.isInSBGNViewer()) {
            rect = this.viewerinner.getBounds();
        }
        return new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        Rectangle rect = this.a.getBounds();
        if (this.isInSBGNViewer()) {
            rect = this.viewerinner.getBounds();
        }
        return new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        if (!this.isInSBGNViewer()) {
            g2.draw(this.a);
        }
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        if (!this.isInSBGNViewer()) {
            g2.fill(this.af);
        }
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        if (this.bPaintSymbolFrameUsingSpecifiedColor) {
            if (this.colorSpecified != null) {
                Color originalColor = g2.getColor();
                g2.setColor(this.colorSpecified);
                if (this.isInSBGNViewer()) {
                    g2.fill(this.viewerinner);
                } else {
                    g2.fill(this.inner);
                }
                g2.setColor(originalColor);
                if (this.isInSBGNViewer()) {
                    this.painter.drawDefaultColorEdge(g2, this.viewerinner, colorflg);
                } else {
                    this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
                }
            }
            return;
        }
        if (this.isInSBGNViewer()) {
            this.painter.fillPaint(g2, this.viewerinner, colorflg);
            if (this.isDrawShade) {
                Color colorBak = g2.getColor();
                g2.setColor(SHADE_COLOR);
                g2.fill(this.shapeShade);
                g2.setColor(colorBak);
            }
            this.painter.drawDefaultColorEdge(g2, this.viewerinner, colorflg);
        } else {
            this.painter.fillPaint(g2, this.inner, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
        }
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    private Point2D.Double meanPoint(int index1, int index2, double ratio) {
        return this.meanPoint(this.points[index1], this.points[index2], ratio);
    }

    private Point2D.Double copyPoint(int i) {
        return (Point2D.Double)this.points[i].clone();
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        if (this.isInSBGNViewer()) {
            Point2D.Double p = Receptor.getCoordinatesOfLinkPositionByInternalIndex(this.getSymbolBounds(), index);
            switch (index) {
                case 0: {
                    p.x += 1.0;
                    p.y += 1.0;
                    break;
                }
                case 4: {
                    p.x -= 1.0;
                    p.y += 1.0;
                    break;
                }
                case 8: {
                    p.x -= 1.0;
                    p.y -= 1.0;
                    break;
                }
                case 12: {
                    p.x += 1.0;
                    p.y -= 1.0;
                }
            }
            return p;
        }
        switch (index) {
            case 0: {
                return this.copyPoint(0);
            }
            case 1: {
                return this.meanPoint(0, 5, 0.5);
            }
            case 2: {
                return this.copyPoint(5);
            }
            case 3: {
                return this.meanPoint(5, 4, 0.5);
            }
            case 4: {
                return this.copyPoint(4);
            }
            case 5: {
                return this.meanPoint(4, 3, 0.75);
            }
            case 6: {
                return this.meanPoint(4, 3, 0.5);
            }
            case 7: {
                return this.meanPoint(4, 3, 0.25);
            }
            case 8: {
                return this.copyPoint(3);
            }
            case 9: {
                return this.meanPoint(3, 2, 0.5);
            }
            case 10: {
                return this.copyPoint(2);
            }
            case 11: {
                return this.meanPoint(2, 1, 0.5);
            }
            case 12: {
                return this.copyPoint(1);
            }
            case 13: {
                return this.meanPoint(1, 0, 0.75);
            }
            case 14: {
                return this.meanPoint(1, 0, 0.5);
            }
            case 16: {
                return new Point2D.Double(this.points[2].x, (this.points[0].y + this.points[2].y) / 2.0);
            }
        }
        return this.meanPoint(1, 0, 0.25);
    }

    @Override
    public void setIsDrawShade(boolean isDrawShade) {
        this.isDrawShade = isDrawShade;
    }

    @Override
    public boolean isDrawShade() {
        return this.isDrawShade;
    }

    @Override
    public Area getOutterShape() {
        if (this.isInSBGNViewer()) {
            return new Area(this.viewerinner);
        }
        return new Area(this.inner);
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }
}

