/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class Phenotype
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol {
    public static final String CODENAME = "PHENOTYPE";
    static final Color NG_COLOR = new Color(-1118482);
    private boolean isNG = false;
    private Polygon inner = new Polygon();
    private Polygon a = new Polygon();
    private Polygon af = new Polygon();
    private Point2D.Double[] points = new Point2D.Double[8];
    private PaintScheme painter = null;
    public static final double defaultAngle = -1.5707963267948966;

    public Phenotype() {
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean isProtein() {
        return false;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(80, 30);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            return this.a.contains(x, y);
        }
        return this.inner.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        return this.inner.contains(x, y);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        this.isNG = h >= w;
        this.inner = this.createPolygon(x, y, w, h);
        this.calcPoints(x, y, w, h);
        this.a = this.createPolygon(x - 8.0, y - 4.0, w + 16.0, h + 8.0);
        this.af = this.createPolygon(x - 3.0, y - 3.0, w + 6.0, h + 6.0);
    }

    protected Polygon createPolygon(double x, double y, double width, double height) {
        return this.createPolygon((int)x, (int)y, (int)width, (int)height);
    }

    protected Polygon createPolygon(int x, int y, int width, int height) {
        Polygon inner = new Polygon();
        inner.addPoint(x + height / 2, y);
        inner.addPoint(x, y + height / 2);
        inner.addPoint(x + height / 2, y + height);
        inner.addPoint(x + width - height / 2, y + height);
        inner.addPoint(x + width, y + height / 2);
        inner.addPoint(x + width - height / 2, y);
        return inner;
    }

    protected void calcPoints(double xD, double yD, double wD, double hD) {
        int x = (int)xD;
        int y = (int)yD;
        int width = (int)wD;
        int height = (int)hD;
        this.points[0].x = x + height / 2;
        this.points[0].y = y;
        this.points[1].x = x;
        this.points[1].y = y + height / 2;
        this.points[2].x = x + height / 2;
        this.points[2].y = y + height;
        this.points[4].x = x + width - height / 2;
        this.points[4].y = y + height;
        this.points[5].x = x + width;
        this.points[5].y = y + height / 2;
        this.points[6].x = x + width - height / 2;
        this.points[6].y = y;
        this.points[3].x = (this.points[2].x + this.points[4].x) / 2.0;
        this.points[3].y = (this.points[2].y + this.points[4].y) / 2.0;
        this.points[7].x = (this.points[6].x + this.points[0].x) / 2.0;
        this.points[7].y = (this.points[6].y + this.points[0].y) / 2.0;
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        Rectangle rect = this.inner.getBounds();
        return new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        Rectangle rect = this.a.getBounds();
        return new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        if (!this.isNG) {
            g2.draw(this.a);
        }
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        if (!this.isNG) {
            g2.fill(this.af);
        }
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        if (!this.isNG) {
            if (this.bPaintSymbolFrameUsingSpecifiedColor) {
                if (this.colorSpecified != null) {
                    Color originalColor = g2.getColor();
                    g2.setColor(this.colorSpecified);
                    g2.fill(this.inner);
                    g2.setColor(originalColor);
                    this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
                }
                return;
            }
            this.painter.fillPaint(g2, this.inner, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
        } else {
            Color originalColor = g2.getColor();
            g2.setColor(NG_COLOR);
            g2.fill(this.inner.getBounds());
            g2.setColor(originalColor);
        }
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        Rectangle2D.Double r = this.getSymbolBounds();
        switch (index) {
            case 0: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.height * 0.5, r.y);
                return p1;
            }
            case 1: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.height * 0.5, r.y);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width - r.height * 0.5, r.y);
                return this.meanPoint(p1, p2, 0.75);
            }
            case 2: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.height * 0.5, r.y);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width - r.height * 0.5, r.y);
                return this.meanPoint(p1, p2, 0.5);
            }
            case 3: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.height * 0.5, r.y);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width - r.height * 0.5, r.y);
                return this.meanPoint(p1, p2, 0.25);
            }
            case 4: {
                Point2D.Double p2 = new Point2D.Double(r.x + r.width - r.height * 0.5, r.y);
                return p2;
            }
            case 5: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width - r.height * 0.5, r.y);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width, r.y + r.height * 0.5);
                return this.meanPoint(p1, p2, 0.5);
            }
            case 6: {
                Point2D.Double p2 = new Point2D.Double(r.x + r.width, r.y + r.height * 0.5);
                return p2;
            }
            case 7: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width, r.y + r.height * 0.5);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width - r.height * 0.5, r.y + r.height);
                return this.meanPoint(p1, p2, 0.5);
            }
            case 8: {
                Point2D.Double p2 = new Point2D.Double(r.x + r.width - r.height * 0.5, r.y + r.height);
                return p2;
            }
            case 9: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width - r.height * 0.5, r.y + r.height);
                Point2D.Double p2 = new Point2D.Double(r.x + r.height * 0.5, r.y + r.height);
                return this.meanPoint(p1, p2, 0.75);
            }
            case 10: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width - r.height * 0.5, r.y + r.height);
                Point2D.Double p2 = new Point2D.Double(r.x + r.height * 0.5, r.y + r.height);
                return this.meanPoint(p1, p2, 0.5);
            }
            case 11: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width - r.height * 0.5, r.y + r.height);
                Point2D.Double p2 = new Point2D.Double(r.x + r.height * 0.5, r.y + r.height);
                return this.meanPoint(p1, p2, 0.25);
            }
            case 12: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.height * 0.5, r.y + r.height);
                return p1;
            }
            case 13: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.height * 0.5, r.y + r.height);
                Point2D.Double p2 = new Point2D.Double(r.x, r.y + r.height * 0.5);
                return this.meanPoint(p1, p2, 0.5);
            }
            case 14: {
                Point2D.Double p1 = new Point2D.Double(r.x, r.y + r.height * 0.5);
                return p1;
            }
            case 16: {
                Point2D.Double p1 = new Point2D.Double(r.getCenterX(), r.getCenterY());
                return p1;
            }
        }
        Point2D.Double p1 = new Point2D.Double(r.x, r.y + r.height * 0.5);
        Point2D.Double p2 = new Point2D.Double(r.x + r.height * 0.5, r.y);
        return this.meanPoint(p1, p2, 0.5);
    }

    @Override
    public Area getOutterShape() {
        return new Area(this.inner);
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }
}

