/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesSbgnViewerSymbol;
import jp.sbi.celldesigner.SpeciesShadeSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class IonChannel
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol,
SpeciesSbgnViewerSymbol,
SpeciesShadeSymbol {
    public static final String CODENAME = "ION_CHANNEL";
    private boolean isDrawShade = false;
    private Area shapeShade = null;
    private static final double ROUND_RADIUS = 10.0;
    private static final double W2 = 20.0;
    RoundRectangle2D.Double inner1;
    RoundRectangle2D.Double a1;
    RoundRectangle2D.Double af1;
    RoundRectangle2D.Double inner2;
    RoundRectangle2D.Double a2;
    RoundRectangle2D.Double af2;
    Rectangle2D.Double rect = null;
    RoundRectangle2D.Double innerAll;
    Point2D.Double[] points = new Point2D.Double[8];
    boolean isOpen = false;
    private PaintScheme painter = null;
    public static final double defaultAngle = -1.5707963267948966;

    public IonChannel() {
        this.inner1 = new RoundRectangle2D.Double();
        this.a1 = new RoundRectangle2D.Double();
        this.af1 = new RoundRectangle2D.Double();
        this.inner2 = new RoundRectangle2D.Double();
        this.a2 = new RoundRectangle2D.Double();
        this.af2 = new RoundRectangle2D.Double();
        this.rect = new Rectangle2D.Double();
        this.innerAll = new RoundRectangle2D.Double();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Rectangle2D.Double getLeftBounds() {
        if (this.isInSBGNViewer()) {
            return (Rectangle2D.Double)this.innerAll.getBounds2D();
        }
        return (Rectangle2D.Double)this.inner1.getBounds2D();
    }

    public Rectangle2D.Double getModificatinSBGNViewerLeftBounds() {
        return (Rectangle2D.Double)this.inner1.getBounds2D();
    }

    public Rectangle2D.Double getRightBounds() {
        if (this.isInSBGNViewer()) {
            return (Rectangle2D.Double)this.innerAll.getBounds2D();
        }
        return (Rectangle2D.Double)this.inner2.getBounds2D();
    }

    public Rectangle2D.Double getModificatinSBGNViewerBounds() {
        return (Rectangle2D.Double)this.innerAll.getBounds2D();
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean isProtein() {
        return true;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(80, 40);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            if (this.isInSBGNViewer()) {
                return this.a1.contains(x, y);
            }
            return this.a1.contains(x, y) || this.a2.contains(x, y);
        }
        if (this.isInSBGNViewer()) {
            return this.innerAll.contains(x, y);
        }
        return this.inner1.contains(x, y) || this.inner2.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        if (this.isInSBGNViewer()) {
            return this.innerAll.contains(x, y);
        }
        return this.inner1.contains(x, y) || this.inner2.contains(x, y);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        double s = 0.0;
        if (this.isOpen) {
            s = 20.0;
        }
        double w1 = w - 20.0 - s;
        this.inner1.setRoundRect(x, y, w1, h, 10.0, 10.0);
        this.a1.setRoundRect(x - 4.0, y - 4.0, w1 + 8.0, h + 8.0, 18.0, 18.0);
        this.af1.setRoundRect(x - 3.0, y - 3.0, w1 + 6.0, h + 6.0, 16.0, 16.0);
        this.inner2.setRoundRect(x + w1 + s, y, 20.0, h, 10.0, 10.0);
        this.a2.setRoundRect(x + w1 + s - 4.0, y - 4.0, 28.0, h + 8.0, 18.0, 18.0);
        this.af2.setRoundRect(x + w1 + s - 3.0, y - 3.0, 26.0, h + 6.0, 16.0, 16.0);
        this.rect.setFrame(x, y, w, h);
        this.innerAll.setRoundRect(x, y, w, h, 10.0, 10.0);
        GUtil2.setEdgePoints(this.rect, this.innerAll, this.points);
        if (this.isInSBGNViewer()) {
            this.a1.setRoundRect(x - 4.0, y - 4.0, w + 8.0, h + 8.0, 18.0, 18.0);
            this.af1.setRoundRect(x - 3.0, y - 3.0, w + 6.0, h + 6.0, 16.0, 16.0);
            this.rect.setFrame(x, y, w, h);
            GUtil2.setEdgePoints(this.rect, this.innerAll, this.points);
        }
        Rectangle2D.Double rectTemp = new Rectangle2D.Double(x, y, w, h * 0.75);
        this.shapeShade = new Area(this.innerAll);
        Area areaTwo = new Area(rectTemp);
        this.shapeShade.subtract(areaTwo);
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        if (this.isInSBGNViewer()) {
            Rectangle rect = this.innerAll.getBounds();
            return new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        }
        return new Rectangle2D.Double(this.inner1.getX(), this.inner1.getY(), this.inner2.getX() - this.inner1.getX() + this.inner2.getWidth(), this.inner1.getHeight());
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        return new Rectangle2D.Double(this.a1.getX(), this.a1.getY(), this.a2.getX() - this.a1.getX() + this.a2.getWidth(), this.a1.getHeight());
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        g2.draw(this.a1);
        if (!this.isInSBGNViewer()) {
            g2.draw(this.a2);
        }
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        g2.fill(this.af1);
        if (!this.isInSBGNViewer()) {
            g2.fill(this.af2);
        }
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        if (this.bPaintSymbolFrameUsingSpecifiedColor) {
            if (this.colorSpecified != null) {
                Color originalColor = g2.getColor();
                g2.setColor(this.colorSpecified);
                if (this.isInSBGNViewer()) {
                    g2.fill(this.innerAll);
                } else {
                    g2.fill(this.inner1);
                    g2.fill(this.inner2);
                }
                g2.setColor(originalColor);
                if (this.isInSBGNViewer()) {
                    this.painter.drawDefaultColorEdge(g2, this.innerAll, colorflg);
                } else {
                    this.painter.drawDefaultColorEdge(g2, this.inner1, colorflg);
                    this.painter.drawDefaultColorEdge(g2, this.inner2, colorflg);
                }
            }
            return;
        }
        if (this.isInSBGNViewer()) {
            this.painter.fillPaint(g2, this.innerAll, colorflg);
        } else {
            this.painter.fillPaint(g2, this.inner1, colorflg);
            this.painter.fillPaint(g2, this.inner2, colorflg);
        }
        if (this.isInSBGNViewer()) {
            if (this.isDrawShade) {
                Color colorBak = g2.getColor();
                g2.setColor(SHADE_COLOR);
                g2.fill(this.shapeShade);
                g2.setColor(colorBak);
            }
            this.painter.drawDefaultColorEdge(g2, this.innerAll, colorflg);
        } else {
            this.painter.drawDefaultColorEdge(g2, this.inner1, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.inner2, colorflg);
        }
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        Point2D.Double p = IonChannel.getCoordinatesOfLinkPositionByInternalIndex(this.getSymbolBounds(), index);
        switch (index) {
            case 0: {
                p.x += 1.0;
                p.y += 1.0;
                break;
            }
            case 4: {
                p.x -= 1.0;
                p.y += 1.0;
                break;
            }
            case 8: {
                p.x -= 1.0;
                p.y -= 1.0;
                break;
            }
            case 12: {
                p.x += 1.0;
                p.y -= 1.0;
            }
        }
        return p;
    }

    @Override
    public void setIsDrawShade(boolean isDrawShade) {
        this.isDrawShade = isDrawShade;
    }

    @Override
    public boolean isDrawShade() {
        return this.isDrawShade;
    }

    @Override
    public Area getOutterShape() {
        if (this.isInSBGNViewer()) {
            return new Area(this.innerAll);
        }
        return new Area(GUtil.union(this.inner1.getBounds2D(), this.inner2.getBounds2D()));
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }

    public RoundRectangle2D.Double getInner1() {
        return this.inner1;
    }

    public RoundRectangle2D.Double getInner2() {
        return this.inner2;
    }
}

