/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesShadeSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class Ion
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol,
SpeciesShadeSymbol {
    public static final String CODENAME = "ION";
    public static final int CHORD = 1;
    private boolean isDrawShade = false;
    Ellipse2D.Double inner;
    Ellipse2D.Double a;
    Ellipse2D.Double af;
    Rectangle2D.Double rect = null;
    Point2D.Double[] points = new Point2D.Double[8];
    private PaintScheme painter = null;
    private Area shapeShade = null;
    public static final double defaultAngle = -1.5707963267948966;

    public Ion() {
        this.inner = new Ellipse2D.Double();
        this.a = new Ellipse2D.Double();
        this.af = new Ellipse2D.Double();
        this.rect = new Rectangle2D.Double();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean isProtein() {
        return false;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(25, 25);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            return this.a.contains(x, y);
        }
        return this.inner.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        return this.inner.contains(x, y);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        double myH;
        double myW;
        double myY;
        double myX;
        if (w >= h) {
            myX = x + (w - h) / 2.0;
            myY = y;
            myW = h;
            myH = h;
        } else {
            myX = x;
            myY = y;
            myW = w;
            myH = w;
        }
        this.inner.setFrame(myX, myY, myW, myH);
        this.a.setFrame(myX - 4.0, myY - 4.0, myW + 8.0, myH + 8.0);
        this.af.setFrame(myX - 3.0, myY - 3.0, myW + 6.0, myH + 6.0);
        this.rect.setFrame(myX, myY, myW, myH);
        GUtil2.setEdgePoints(this.rect, this.inner, this.points);
        Rectangle2D.Double rectTemp = new Rectangle2D.Double(myX, myY, myW, myH * 0.75);
        this.shapeShade = new Area(this.inner);
        Area areaTwo = new Area(rectTemp);
        this.shapeShade.subtract(areaTwo);
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        return new Rectangle2D.Double(this.inner.getX(), this.inner.getY(), this.inner.getWidth(), this.inner.getHeight());
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        return new Rectangle2D.Double(this.a.getX(), this.a.getY(), this.a.getWidth(), this.a.getHeight());
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        g2.draw(this.a);
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        g2.fill(this.af);
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        if (this.bPaintSymbolFrameUsingSpecifiedColor) {
            if (this.colorSpecified != null) {
                Color originalColor = g2.getColor();
                g2.setColor(this.colorSpecified);
                g2.fill(this.inner);
                g2.setColor(originalColor);
                this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
            }
            return;
        }
        this.painter.fillPaint(g2, this.inner, colorflg);
        if (this.isInSBGNViewer() && this.isDrawShade) {
            Color colorBak = g2.getColor();
            g2.setColor(SHADE_COLOR);
            g2.fill(this.shapeShade);
            g2.setColor(colorBak);
        }
        this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        Rectangle2D.Double r = this.getSymbolBounds();
        double radius = r.width * 0.5;
        Point2D.Double p0 = new Point2D.Double(r.x + radius, r.y + radius);
        switch (index) {
            case 0: {
                double d1 = radius * sin_45;
                p0.x -= d1;
                p0.y -= d1;
                return p0;
            }
            case 1: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x -= d1;
                p0.y -= d2;
                return p0;
            }
            case 2: {
                p0.y -= radius;
                return p0;
            }
            case 3: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x += d1;
                p0.y -= d2;
                return p0;
            }
            case 4: {
                double d1 = radius * sin_45;
                p0.x += d1;
                p0.y -= d1;
                return p0;
            }
            case 5: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x += d2;
                p0.y -= d1;
                return p0;
            }
            case 6: {
                p0.x += radius;
                return p0;
            }
            case 7: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x += d2;
                p0.y += d1;
                return p0;
            }
            case 8: {
                double d1 = radius * sin_45;
                p0.x += d1;
                p0.y += d1;
                return p0;
            }
            case 9: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x += d1;
                p0.y += d2;
                return p0;
            }
            case 10: {
                p0.y += radius;
                return p0;
            }
            case 11: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x -= d1;
                p0.y += d2;
                return p0;
            }
            case 12: {
                double d1 = radius * sin_45;
                p0.x -= d1;
                p0.y += d1;
                return p0;
            }
            case 13: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x -= d2;
                p0.y += d1;
                return p0;
            }
            case 14: {
                p0.x -= radius;
                return p0;
            }
            case 16: {
                p0.x = r.getCenterX();
                p0.y = r.getCenterY();
                return p0;
            }
        }
        double d1 = radius * sin_225;
        double d2 = radius * sin_675;
        p0.x -= d2;
        p0.y -= d1;
        return p0;
    }

    @Override
    public void setIsDrawShade(boolean isDrawShade) {
        this.isDrawShade = isDrawShade;
    }

    @Override
    public boolean isDrawShade() {
        return this.isDrawShade;
    }

    @Override
    public Area getOutterShape() {
        return new Area(this.inner);
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }
}

