/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesSbgnViewerSymbol;
import jp.sbi.celldesigner.SpeciesShadeSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class Generic
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol,
SpeciesSbgnViewerSymbol,
SpeciesShadeSymbol {
    public static final String CODENAME = "GENERIC";
    private boolean isDrawShade = false;
    private Area shapeShade = null;
    private static final double ROUND_RADIUS = 10.0;
    RoundRectangle2D.Double inner;
    RoundRectangle2D.Double a;
    RoundRectangle2D.Double af;
    Rectangle2D.Double rect = null;
    Point2D.Double[] points = new Point2D.Double[8];
    private PaintScheme painter = null;
    public static final double defaultAngle = -1.5707963267948966;

    public Generic() {
        this.inner = new RoundRectangle2D.Double();
        this.a = new RoundRectangle2D.Double();
        this.af = new RoundRectangle2D.Double();
        this.rect = new Rectangle2D.Double();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean isProtein() {
        return true;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(80, 40);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            if (this.isInSBGNViewer()) {
                return this.inner.contains(x, y);
            }
            return this.a.contains(x, y);
        }
        return this.inner.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        return this.inner.contains(x, y);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        this.inner.setRoundRect(x, y, w, h, 10.0, 10.0);
        this.a.setRoundRect(x - 4.0, y - 4.0, w + 8.0, h + 8.0, 18.0, 18.0);
        this.af.setRoundRect(x - 3.0, y - 3.0, w + 6.0, h + 6.0, 16.0, 16.0);
        if (this.isInSBGNViewer()) {
            this.a = (RoundRectangle2D.Double)this.inner.clone();
            this.af = (RoundRectangle2D.Double)this.inner.clone();
        }
        Rectangle2D.Double rectTemp = new Rectangle2D.Double(x, y, w, h * 0.75);
        this.shapeShade = new Area(this.inner);
        Area areaTwo = new Area(rectTemp);
        this.shapeShade.subtract(areaTwo);
        this.rect.setFrame(x, y, w, h);
        GUtil2.setEdgePoints(this.rect, this.inner, this.points);
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        return new Rectangle2D.Double(this.inner.getX(), this.inner.getY(), this.inner.getWidth(), this.inner.getHeight());
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        if (this.isInSBGNViewer()) {
            return new Rectangle2D.Double(this.inner.getX(), this.inner.getY(), this.inner.getWidth(), this.inner.getHeight());
        }
        return new Rectangle2D.Double(this.a.getX(), this.a.getY(), this.a.getWidth(), this.a.getHeight());
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        if (this.isInSBGNViewer()) {
            return;
        }
        g2.draw(this.a);
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        if (this.isInSBGNViewer()) {
            return;
        }
        g2.fill(this.af);
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        if (this.bPaintSymbolFrameUsingSpecifiedColor) {
            if (this.colorSpecified != null) {
                Color originalColor = g2.getColor();
                g2.setColor(this.colorSpecified);
                g2.fill(this.inner);
                g2.setColor(originalColor);
                this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
            }
            return;
        }
        this.painter.fillPaint(g2, this.inner, colorflg);
        if (this.isInSBGNViewer() && this.isDrawShade) {
            Color colorBak = g2.getColor();
            g2.setColor(SHADE_COLOR);
            g2.fill(this.shapeShade);
            g2.setColor(colorBak);
        }
        this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        Point2D.Double p = Generic.getCoordinatesOfLinkPositionByInternalIndex(this.getSymbolBounds(), index);
        switch (index) {
            case 0: {
                p.x += 1.0;
                p.y += 1.0;
                break;
            }
            case 4: {
                p.x -= 1.0;
                p.y += 1.0;
                break;
            }
            case 8: {
                p.x -= 1.0;
                p.y -= 1.0;
                break;
            }
            case 12: {
                p.x += 1.0;
                p.y -= 1.0;
            }
        }
        return p;
    }

    @Override
    public void setIsDrawShade(boolean isDrawShade) {
        this.isDrawShade = isDrawShade;
    }

    @Override
    public boolean isDrawShade() {
        return this.isDrawShade;
    }

    @Override
    public Area getOutterShape() {
        return new Area(this.inner);
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }
}

