/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class GeneralBrief
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol {
    public static final String CODENAME = "GENERAL_BRIEF_VIEW";
    private static final double ROUND_RADIUS = 5.0;
    RoundRectangle2D.Double body;
    Rectangle2D.Double rect = null;
    Point2D.Double[] points = new Point2D.Double[8];
    private PaintScheme painter = null;
    public static final double defaultAngle = -1.5707963267948966;

    public GeneralBrief() {
        this.body = new RoundRectangle2D.Double();
        this.rect = new Rectangle2D.Double();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean isProtein() {
        return false;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(80, 60);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        return this.body.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        return this.body.contains(x, y);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        this.body.setRoundRect(x, y, w, h, 5.0, 5.0);
        this.rect.setFrame(x, y, w, h);
        GUtil2.setEdgePoints(this.rect, this.body, this.points);
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        return new Rectangle2D.Double(this.body.getX(), this.body.getY(), this.body.getWidth(), this.body.getHeight());
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        return new Rectangle2D.Double(this.body.getX(), this.body.getY(), this.body.getWidth(), this.body.getHeight());
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        if (this.bPaintSymbolFrameUsingSpecifiedColor) {
            if (this.colorSpecified != null) {
                Color originalColor = g2.getColor();
                g2.setColor(this.colorSpecified);
                g2.fill(this.body);
                g2.setColor(originalColor);
                this.painter.drawDefaultColorEdge(g2, this.body, colorflg);
            }
            return;
        }
        if (Preference.isDebug) {
            this.painter.fillPaint(g2, this.body, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.body, colorflg);
        }
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        Point2D.Double p = GeneralBrief.getCoordinatesOfLinkPositionByInternalIndex(this.getSymbolBounds(), index);
        switch (index) {
            case 0: {
                p.x += 3.0;
                p.y += 3.0;
                break;
            }
            case 4: {
                p.x -= 3.0;
                p.y += 3.0;
                break;
            }
            case 8: {
                p.x -= 3.0;
                p.y -= 3.0;
                break;
            }
            case 12: {
                p.x += 3.0;
                p.y -= 3.0;
            }
        }
        return p;
    }

    @Override
    public Area getOutterShape() {
        return new Area(this.body);
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }
}

