/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesShadeSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class Gene
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol,
SpeciesShadeSymbol {
    public static final String CODENAME = "GENE";
    private boolean isDrawShade = false;
    Rectangle2D.Double inner;
    Rectangle2D.Double a;
    Rectangle2D.Double af;
    Rectangle2D.Double rect = null;
    Point2D.Double[] points = new Point2D.Double[8];
    private PaintScheme painter = null;
    private static final double ROUND_RADIUS = 10.0;
    private Area shapeShade = null;
    public static final double defaultAngle = -1.5707963267948966;

    public Gene() {
        this.inner = new Rectangle2D.Double();
        this.a = new Rectangle2D.Double();
        this.af = new Rectangle2D.Double();
        this.rect = new Rectangle2D.Double();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    private void calcPoints() {
        double cx = this.rect.x + this.rect.width / 2.0;
        double cy = this.rect.y + this.rect.height / 2.0;
        this.points[0].x = this.rect.x;
        this.points[0].y = this.rect.y;
        this.points[1].x = cx;
        this.points[1].y = this.rect.y;
        this.points[2].x = this.rect.x + this.rect.width;
        this.points[2].y = this.rect.y;
        this.points[3].x = this.rect.x + this.rect.width;
        this.points[3].y = cy;
        this.points[4].x = this.rect.x + this.rect.width;
        this.points[4].y = this.rect.y + this.rect.height;
        this.points[5].x = cx;
        this.points[5].y = this.rect.y + this.rect.height;
        this.points[6].x = this.rect.x;
        this.points[6].y = this.rect.y + this.rect.height;
        this.points[7].x = this.rect.x;
        this.points[7].y = cy;
    }

    @Override
    public boolean isProtein() {
        return false;
    }

    @Override
    public boolean isGene() {
        return true;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(70, 25);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            return this.a.contains(x, y);
        }
        return this.getRoundAreaForSBGNView(this.inner).contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        return this.getRoundAreaForSBGNView(this.inner).contains(x, y);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        this.inner.setFrame(x, y, w, h);
        this.a.setFrame(x - 4.0, y - 4.0, w + 8.0, h + 8.0);
        this.af.setFrame(x - 3.0, y - 3.0, w + 6.0, h + 6.0);
        this.rect.setFrame(x, y, w, h);
        this.calcPoints();
        Rectangle2D.Double rectTemp = new Rectangle2D.Double(x, y, w, h * 0.75);
        this.shapeShade = this.getRoundAreaForSBGNView(this.inner);
        Area areaTwo = new Area(rectTemp);
        this.shapeShade.subtract(areaTwo);
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        return new Rectangle2D.Double(this.inner.getX(), this.inner.getY(), this.inner.getWidth(), this.inner.getHeight());
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        return new Rectangle2D.Double(this.a.getX(), this.a.getY(), this.a.getWidth(), this.a.getHeight());
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        g2.draw(this.a);
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        g2.fill(this.af);
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        Area innerSBGNView = this.getRoundAreaForSBGNView(this.inner);
        if (this.bPaintSymbolFrameUsingSpecifiedColor) {
            if (this.colorSpecified != null) {
                Color originalColor = g2.getColor();
                g2.setColor(this.colorSpecified);
                g2.fill(innerSBGNView);
                g2.setColor(originalColor);
                this.painter.drawDefaultColorEdge(g2, innerSBGNView, colorflg);
            }
            return;
        }
        this.painter.fillPaint(g2, innerSBGNView, colorflg);
        if (this.isInSBGNViewer() && this.isDrawShade) {
            Color colorBak = g2.getColor();
            g2.setColor(SHADE_COLOR);
            g2.fill(this.shapeShade);
            g2.setColor(colorBak);
        }
        this.painter.drawDefaultColorEdge(g2, innerSBGNView, colorflg);
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public void setIsDrawShade(boolean isDrawShade) {
        this.isDrawShade = isDrawShade;
    }

    @Override
    public boolean isDrawShade() {
        return this.isDrawShade;
    }

    @Override
    public Area getOutterShape() {
        return this.getRoundAreaForSBGNView(this.inner);
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }

    private Area getRoundAreaForSBGNView(Rectangle2D.Double inner) {
        if (inner == null) {
            return new Area();
        }
        if (!this.isInSBGNViewer()) {
            return new Area(inner);
        }
        float x = (float)inner.getX();
        float y = (float)inner.getY();
        float w = (float)inner.getWidth();
        float h = (float)inner.getHeight();
        Rectangle2D.Double innertemp1 = new Rectangle2D.Double(x, y, w, h / 2.0f);
        RoundRectangle2D.Double innertemp2 = new RoundRectangle2D.Double(x, y, w, h, 10.0, 10.0);
        Area innertemp = new Area(innertemp1);
        innertemp.add(new Area(innertemp2));
        return innertemp;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        Point2D.Double p = Gene.getCoordinatesOfLinkPositionByInternalIndex(this.getSymbolBounds(), index);
        if (this.isInSBGNViewer()) {
            switch (index) {
                case 8: {
                    p.x -= 1.0;
                    p.y -= 1.0;
                    break;
                }
                case 12: {
                    p.x += 1.0;
                    p.y -= 1.0;
                }
            }
        }
        return p;
    }
}

