/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesShadeSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class Drug
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol,
SpeciesShadeSymbol {
    public static final String CODENAME = "DRUG";
    private boolean isDrawShade = false;
    Arc2D.Double lepOut = new Arc2D.Double();
    Arc2D.Double lepIn = new Arc2D.Double();
    Arc2D.Double repOut = new Arc2D.Double();
    Arc2D.Double repIn = new Arc2D.Double();
    Line2D.Double line1 = new Line2D.Double();
    Line2D.Double line2 = new Line2D.Double();
    Line2D.Double line3 = new Line2D.Double();
    Line2D.Double line4 = new Line2D.Double();
    Rectangle2D.Double outRect = new Rectangle2D.Double();
    Rectangle2D.Double inRect = new Rectangle2D.Double();
    Rectangle2D.Double inner = new Rectangle2D.Double();
    Rectangle2D.Double a = new Rectangle2D.Double();
    Rectangle2D.Double af = new Rectangle2D.Double();
    Rectangle2D.Double rect = null;
    Point2D.Double[] points = new Point2D.Double[8];
    Point2D.Double[] pos = new Point2D.Double[17];
    private PaintScheme painter = null;
    private Area shapeShade = null;
    public static final double defaultAngle = -1.5707963267948966;

    public Drug() {
        this.rect = new Rectangle2D.Double();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    private void getAnchor(Point2D.Double[] pos) {
        pos[0] = new Point2D.Double(this.line1.x1, this.line1.y1);
        pos[1] = new Point2D.Double(this.line1.x1 + (this.line1.x2 - this.line1.x1) / 4.0, this.line1.y1);
        pos[2] = new Point2D.Double(this.line1.x1 + (this.line1.x2 - this.line1.x1) / 2.0, this.line1.y1);
        pos[3] = new Point2D.Double(this.line1.x1 + (this.line1.x2 - this.line1.x1) * 3.0 / 4.0, this.line1.y1);
        pos[4] = new Point2D.Double(this.line1.x2, this.line1.y2);
        pos[12] = new Point2D.Double(this.line2.x1, this.line2.y1);
        pos[11] = new Point2D.Double(this.line2.x1 + (this.line2.x2 - this.line2.x1) / 4.0, this.line2.y1);
        pos[10] = new Point2D.Double(this.line2.x1 + (this.line2.x2 - this.line2.x1) / 2.0, this.line2.y1);
        pos[9] = new Point2D.Double(this.line2.x1 + (this.line2.x2 - this.line2.x1) * 3.0 / 4.0, this.line2.y1);
        pos[8] = new Point2D.Double(this.line2.x2, this.line2.y2);
        pos[16] = new Point2D.Double((this.line1.x1 + this.line1.x2) / 2.0, (this.line2.y1 + this.line1.y2) / 2.0);
    }

    private void setGraphics2DBround(double x, double y, double w, double h) {
        Point2D.Double lc = new Point2D.Double();
        lc.x = x + w / 5.0;
        lc.y = y - h / 2.0;
        AffineTransform at = new AffineTransform();
        at.setToTranslation(lc.x, lc.y);
        this.setCircyeParameter(this.lepOut, at, w, h, 0.0, true);
        this.setCircyeParameter(this.lepIn, at, w, h, 4.0, true);
        Point2D.Double rc = new Point2D.Double();
        rc.x = x + w * 4.0 / 5.0;
        rc.y = y - h / 2.0;
        at.setToTranslation(rc.x, rc.y);
        this.setCircyeParameter(this.repOut, at, w, h, 0.0, false);
        this.setCircyeParameter(this.repIn, at, w, h, 4.0, false);
        this.line1.setLine(this.lepOut.getStartPoint(), this.repOut.getEndPoint());
        this.line2.setLine(this.lepOut.getEndPoint(), this.repOut.getStartPoint());
        this.line3.setLine(this.lepIn.getStartPoint(), this.repIn.getEndPoint());
        this.line4.setLine(this.lepIn.getEndPoint(), this.repIn.getStartPoint());
    }

    private void setCircyeParameter(Arc2D.Double ep, AffineTransform aft, double width, double height, double offset, boolean isleft) {
        double start = 90.0;
        Point2D.Double top = new Point2D.Double(-width / 5.0 + offset, height / 2.0 + offset);
        Point2D.Double top1 = new Point2D.Double();
        aft.transform(top, top1);
        ep.setArc(top1.x, top1.y, 2.0 * (width / 5.0 - offset), 2.0 * (height / 2.0 - offset), isleft ? start : 180.0 + start, 360.0 - 2.0 * start, 0);
        double startAngle = ep.getAngleStart();
        double allAngle = ep.getAngleExtent();
        Arc2D.Double ep1 = new Arc2D.Double();
        ep1.setArc(top1.x, top1.y, 2.0 * (width / 5.0 - offset), 2.0 * (height / 2.0 - offset), startAngle, allAngle / 4.0, 0);
        Point2D.Double p1 = new Point2D.Double();
        p1 = (Point2D.Double)ep1.getEndPoint();
        Arc2D.Double ep2 = new Arc2D.Double();
        ep2.setArc(top1.x, top1.y, 2.0 * (width / 5.0 - offset), 2.0 * (height / 2.0 - offset), startAngle, 2.0 * allAngle / 4.0, 0);
        Point2D.Double p2 = new Point2D.Double();
        p2 = (Point2D.Double)ep2.getEndPoint();
        Arc2D.Double ep3 = new Arc2D.Double();
        ep3.setArc(top1.x, top1.y, 2.0 * (width / 5.0 - offset), 2.0 * (height / 2.0 - offset), startAngle, 3.0 * allAngle / 4.0, 0);
        Point2D.Double p3 = new Point2D.Double();
        p3 = (Point2D.Double)ep3.getEndPoint();
        if (ep == this.lepOut) {
            this.pos[15] = p1;
            this.pos[14] = p2;
            this.pos[13] = p3;
        }
        if (ep == this.repOut) {
            this.pos[7] = p1;
            this.pos[6] = p2;
            this.pos[5] = p3;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean isProtein() {
        return false;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(80, 30);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            return this.a.contains(x, y);
        }
        return this.inner.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        return this.inner.contains(x, y);
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        return new Rectangle2D.Double(this.inner.getX(), this.inner.getY(), this.inner.getWidth(), this.inner.getHeight());
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        return new Rectangle2D.Double(this.a.getX(), this.a.getY(), this.a.getWidth(), this.a.getHeight());
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        this.inner.setFrame(x, y, w, h);
        this.a.setFrame(x - 4.0, y - 4.0, w + 8.0, h + 8.0);
        this.setGraphics2DBround(x, y, w, h);
        this.af.setFrame(x - 3.0, y - 3.0, w + 6.0, h + 6.0);
        this.rect.setFrame(x, y, w, h);
        GUtil2.setEdgePoints(this.rect, this.inner, this.points);
        this.getAnchor(this.pos);
        double x1 = this.lepIn.getStartPoint().getX();
        double x2 = this.repIn.getStartPoint().getX();
        double y1 = this.lepIn.getStartPoint().getY();
        double y2 = this.lepIn.getEndPoint().getY();
        Rectangle2D.Double centreinner = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
        Rectangle2D.Double rectTemp = new Rectangle2D.Double(x, y, w, h * 0.75);
        Area centreArea = new Area(centreinner);
        Area leftArea = new Area(this.lepIn);
        Area rightArea = new Area(this.repIn);
        this.shapeShade = new Area(centreArea);
        this.shapeShade.add(leftArea);
        this.shapeShade.add(rightArea);
        Area areaTwo = new Area(rectTemp);
        this.shapeShade.subtract(areaTwo);
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        g2.draw(this.a);
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        g2.fill(this.af);
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        GeneralPath fillarea = new GeneralPath();
        fillarea.reset();
        fillarea.moveTo((float)this.line1.x1, (float)this.line1.y1);
        fillarea.lineTo((float)this.line2.x1, (float)this.line2.y1);
        fillarea.lineTo((float)this.line2.x2, (float)this.line2.y2);
        fillarea.lineTo((float)this.line1.x2, (float)this.line1.y2);
        fillarea.append(this.lepOut, true);
        fillarea.append(this.repOut, true);
        fillarea.closePath();
        if (this.bPaintSymbolFrameUsingSpecifiedColor) {
            if (this.colorSpecified != null) {
                Color originalColor = g2.getColor();
                g2.setColor(this.colorSpecified);
                g2.fill(fillarea);
                g2.setColor(originalColor);
                this.drawMyDefaultColorEdge(g2, colorflg);
            }
            return;
        }
        if (MainWindow.getLastInstance().isShowingSBGNCompliant()) {
            Color originalColor = g2.getColor();
            g2.setColor(Preference.getNotCompliantSBGNViewerColor());
            g2.fill(fillarea);
            g2.setColor(originalColor);
        } else {
            this.painter.fillPaint(g2, fillarea, colorflg);
        }
        if (this.isInSBGNViewer() && this.isDrawShade) {
            Color colorBak = g2.getColor();
            g2.setColor(SHADE_COLOR);
            g2.fill(this.shapeShade);
            g2.setColor(colorBak);
        }
        this.drawMyDefaultColorEdge(g2, colorflg);
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        return this.pos[index];
    }

    @Override
    public void setIsDrawShade(boolean isDrawShade) {
        this.isDrawShade = isDrawShade;
    }

    @Override
    public boolean isDrawShade() {
        return this.isDrawShade;
    }

    private void drawMyDefaultColorEdge(Graphics2D g2, int colorflg) {
        try {
            this.painter.drawDefaultColorEdge(g2, this.lepOut, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.lepIn, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.repOut, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.repIn, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.line1, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.line2, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.line3, colorflg);
            this.painter.drawDefaultColorEdge(g2, this.line4, colorflg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Area getOutterShape() {
        Area temp = new Area(new Rectangle2D.Double(this.line1.x1, this.line1.y1, this.line1.x2 - this.line1.x1, Math.abs(this.lepOut.getStartPoint().getY() - this.lepOut.getEndPoint().getY())));
        temp.add(new Area(this.lepOut));
        temp.add(new Area(this.repOut));
        return temp;
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }
}

