/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class Degraded
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol {
    public static final String CODENAME = "DEGRADED";
    private Ellipse2D ellipse = null;
    private Line2D line = null;
    Rectangle2D.Double rect = null;
    Point2D.Double[] points = new Point2D.Double[8];
    private PaintScheme painter = null;
    public static final double defaultAngle = -1.5707963267948966;

    public Degraded() {
        this.ellipse = new Ellipse2D.Double();
        this.line = new Line2D.Double();
        this.rect = new Rectangle2D.Double();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean isProtein() {
        return false;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(30, 30);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        return this.ellipse.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        return this.ellipse.contains(x, y);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        double myh = h;
        if (w >= h) {
            double dx = (w - h) / 2.0;
            this.ellipse.setFrame(x + dx + 5.0, y + 5.0, h - 10.0, h - 10.0);
            this.rect.setFrame(x + dx + 5.0, y + 5.0, h - 10.0, h - 10.0);
        } else {
            double dy = (h - w) / 2.0;
            this.ellipse.setFrame(x + 5.0, y + 5.0, w - 10.0, w - 10.0);
            this.rect.setFrame(x + 5.0, y + 5.0, w - 10.0, w - 10.0);
            myh = w;
        }
        GUtil2.setEdgePoints(this.rect, this.ellipse, this.points);
        double p1x = x + w * 0.7;
        double p1y = y;
        double p2x = x + w * 0.3;
        double p2y = y + myh;
        this.line.setLine(p1x, p1y, p2x, p2y);
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        return new Rectangle2D.Double(this.ellipse.getX(), this.ellipse.getY(), this.ellipse.getWidth(), this.ellipse.getHeight());
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        return new Rectangle2D.Double(this.ellipse.getX(), this.ellipse.getY(), this.ellipse.getWidth(), this.ellipse.getHeight());
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        if (this.bPaintSymbolFrameUsingSpecifiedColor) {
            if (this.colorSpecified != null) {
                Color originalColor = g2.getColor();
                g2.setColor(this.colorSpecified);
                g2.fill(this.ellipse);
                g2.setColor(originalColor);
                this.painter.drawDefaultColorEdge(g2, this.ellipse, colorflg);
            }
            return;
        }
        this.painter.fillPaint(g2, this.ellipse, colorflg);
        this.painter.drawDefaultColorEdge(g2, this.ellipse, colorflg);
        this.painter.drawDefaultColorEdge(g2, this.line, colorflg);
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        Rectangle2D.Double r = this.getSymbolBounds();
        double radius = r.width * 0.5;
        Point2D.Double p0 = new Point2D.Double(r.x + radius, r.y + radius);
        switch (index) {
            case 0: {
                double d1 = radius * sin_45;
                p0.x -= d1;
                p0.y -= d1;
                return p0;
            }
            case 1: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x -= d1;
                p0.y -= d2;
                return p0;
            }
            case 2: {
                p0.y -= radius;
                return p0;
            }
            case 3: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x += d1;
                p0.y -= d2;
                return p0;
            }
            case 4: {
                double d1 = radius * sin_45;
                p0.x += d1;
                p0.y -= d1;
                return p0;
            }
            case 5: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x += d2;
                p0.y -= d1;
                return p0;
            }
            case 6: {
                p0.x += radius;
                return p0;
            }
            case 7: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x += d2;
                p0.y += d1;
                return p0;
            }
            case 8: {
                double d1 = radius * sin_45;
                p0.x += d1;
                p0.y += d1;
                return p0;
            }
            case 9: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x += d1;
                p0.y += d2;
                return p0;
            }
            case 10: {
                p0.y += radius;
                return p0;
            }
            case 11: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x -= d1;
                p0.y += d2;
                return p0;
            }
            case 12: {
                double d1 = radius * sin_45;
                p0.x -= d1;
                p0.y += d1;
                return p0;
            }
            case 13: {
                double d1 = radius * sin_225;
                double d2 = radius * sin_675;
                p0.x -= d2;
                p0.y += d1;
                return p0;
            }
            case 14: {
                p0.x -= radius;
                return p0;
            }
            case 16: {
                p0.x = r.getCenterX();
                p0.y = r.getCenterY();
                return p0;
            }
        }
        double d1 = radius * sin_225;
        double d2 = radius * sin_675;
        p0.x -= d2;
        p0.y -= d1;
        return p0;
    }

    @Override
    public Area getOutterShape() {
        return new Area(this.ellipse);
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }
}

