/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesSbgnViewerSymbol;
import jp.sbi.celldesigner.SpeciesShadeSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class ComplexBrief
extends SpeciesSymbolImpl
implements SBSymbol,
SpeciesSymbol,
SpeciesSbgnViewerSymbol,
SpeciesShadeSymbol {
    public static final String CODENAME = "COMPLEX_PACKED";
    private boolean isDrawShade = false;
    private Area shapeShade = null;
    static final double ROUND_RADIUS = 5.0;
    Polygon body;
    Polygon a;
    Polygon af;
    Polygon innerRect;
    Rectangle2D.Double rect = null;
    Point2D.Double[] points = new Point2D.Double[8];
    public static final float[] PATTERN_BREIF_VIEW = new float[]{2.0f, 4.0f, 2.0f, 4.0f};
    public static BasicStroke STROKE_BREIF_VIEW = new BasicStroke(1.0f, 0, 0, 10.0f, PATTERN_BREIF_VIEW, 0.0f);
    private static final double B = 4.0;
    private PaintScheme painter = null;
    public static final double defaultAngle = -1.5707963267948966;

    public ComplexBrief() {
        this.body = new Polygon();
        this.a = new Polygon();
        this.af = new Polygon();
        this.innerRect = new Polygon();
        this.rect = new Rectangle2D.Double();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean isProtein() {
        return false;
    }

    @Override
    public boolean isGene() {
        return false;
    }

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return false;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(80, 60);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            if (this.isInSBGNViewer()) {
                return this.body.contains(x, y);
            }
            return this.a.contains(x, y);
        }
        return this.body.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        return this.body.contains(x, y);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        Point2D.Double point1 = new Point2D.Double(x, y + 5.0);
        Point2D.Double point2 = new Point2D.Double(x + 5.0, y);
        Point2D.Double point3 = new Point2D.Double(x + w - 5.0, y);
        Point2D.Double point4 = new Point2D.Double(x + w, y + 5.0);
        Point2D.Double point5 = new Point2D.Double(x + w, y + h - 5.0);
        Point2D.Double point6 = new Point2D.Double(x + w - 5.0, y + h);
        Point2D.Double point7 = new Point2D.Double(x + 5.0, y + h);
        Point2D.Double point8 = new Point2D.Double(x, y + h - 5.0);
        this.body.reset();
        this.body.addPoint((int)point1.x, (int)point1.y);
        this.body.addPoint((int)point2.x, (int)point2.y);
        this.body.addPoint((int)point3.x, (int)point3.y);
        this.body.addPoint((int)point4.x, (int)point4.y);
        this.body.addPoint((int)point5.x, (int)point5.y);
        this.body.addPoint((int)point6.x, (int)point6.y);
        this.body.addPoint((int)point7.x, (int)point7.y);
        this.body.addPoint((int)point8.x, (int)point8.y);
        this.a.reset();
        this.a.addPoint((int)(point1.x - 4.0), (int)point1.y);
        this.a.addPoint((int)point2.x, (int)(point2.y - 4.0));
        this.a.addPoint((int)point3.x, (int)(point3.y - 4.0));
        this.a.addPoint((int)(point4.x + 4.0), (int)point4.y);
        this.a.addPoint((int)(point5.x + 4.0), (int)point5.y);
        this.a.addPoint((int)point6.x, (int)(point6.y + 4.0));
        this.a.addPoint((int)point7.x, (int)(point7.y + 4.0));
        this.a.addPoint((int)(point8.x - 4.0), (int)point8.y);
        this.af.reset();
        this.af.addPoint((int)(point1.x - 3.0), (int)point1.y);
        this.af.addPoint((int)point2.x, (int)(point2.y - 3.0));
        this.af.addPoint((int)point3.x, (int)(point3.y - 3.0));
        this.af.addPoint((int)(point4.x + 3.0), (int)point4.y);
        this.af.addPoint((int)(point5.x + 3.0), (int)point5.y);
        this.af.addPoint((int)point6.x, (int)(point6.y + 3.0));
        this.af.addPoint((int)point7.x, (int)(point7.y + 3.0));
        this.af.addPoint((int)(point8.x - 3.0), (int)point8.y);
        this.innerRect.reset();
        this.innerRect.addPoint((int)(point1.x + 4.0), (int)point1.y);
        this.innerRect.addPoint((int)point2.x, (int)(point2.y + 4.0));
        this.innerRect.addPoint((int)point3.x, (int)(point3.y + 4.0));
        this.innerRect.addPoint((int)(point4.x - 4.0), (int)point4.y);
        this.innerRect.addPoint((int)(point5.x - 4.0), (int)point5.y);
        this.innerRect.addPoint((int)point6.x, (int)(point6.y - 4.0));
        this.innerRect.addPoint((int)point7.x, (int)(point7.y - 4.0));
        this.innerRect.addPoint((int)(point8.x + 4.0), (int)point8.y);
        if (this.isInSBGNViewer()) {
            this.a.reset();
            this.a.addPoint((int)point1.x, (int)point1.y);
            this.a.addPoint((int)point2.x, (int)point2.y);
            this.a.addPoint((int)point3.x, (int)point3.y);
            this.a.addPoint((int)point4.x, (int)point4.y);
            this.a.addPoint((int)point5.x, (int)point5.y);
            this.a.addPoint((int)point6.x, (int)point6.y);
            this.a.addPoint((int)point7.x, (int)point7.y);
            this.a.addPoint((int)point8.x, (int)point8.y);
            this.af.reset();
            this.af.addPoint((int)point1.x, (int)point1.y);
            this.af.addPoint((int)point2.x, (int)point2.y);
            this.af.addPoint((int)point3.x, (int)point3.y);
            this.af.addPoint((int)point4.x, (int)point4.y);
            this.af.addPoint((int)point5.x, (int)point5.y);
            this.af.addPoint((int)point6.x, (int)point6.y);
            this.af.addPoint((int)point7.x, (int)point7.y);
            this.af.addPoint((int)point8.x, (int)point8.y);
        }
        Rectangle2D.Double rectTemp = new Rectangle2D.Double(x, y, w, h * 0.75);
        this.shapeShade = new Area(this.body);
        Area areaTwo = new Area(rectTemp);
        this.shapeShade.subtract(areaTwo);
        this.rect.setFrame(x, y, w, h);
        GUtil2.setEdgePoints(this.rect, this.body, this.points);
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        double x = this.body.xpoints[0];
        double y = this.body.ypoints[1];
        double width = this.body.xpoints[3] - this.body.xpoints[0];
        double height = this.body.ypoints[6] - this.body.ypoints[1];
        return new Rectangle2D.Double(x, y, width, height);
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        double x = this.a.xpoints[0];
        double y = this.a.ypoints[1];
        double width = this.a.xpoints[3] - this.a.xpoints[0];
        double height = this.a.ypoints[7] - this.a.ypoints[2];
        if (this.isInSBGNViewer()) {
            x = this.body.xpoints[0];
            y = this.body.ypoints[1];
            width = this.body.xpoints[3] - this.body.xpoints[0];
            height = this.body.ypoints[7] - this.body.ypoints[2];
        }
        return new Rectangle2D.Double(x, y, width, height);
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        if (this.isInSBGNViewer()) {
            return;
        }
        g2.draw(this.a);
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        if (this.isInSBGNViewer()) {
            return;
        }
        g2.fill(this.af);
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        if (this.bPaintSymbolFrameUsingSpecifiedColor) {
            if (this.colorSpecified != null) {
                Color originalColor = g2.getColor();
                g2.setColor(this.colorSpecified);
                g2.fill(this.body);
                g2.setColor(originalColor);
                this.painter.drawDefaultColorEdge(g2, this.body, colorflg);
            }
            return;
        }
        this.painter.fillPaint(g2, this.body, colorflg);
        if (this.isInSBGNViewer() && this.isDrawShade) {
            Color colorBak = g2.getColor();
            g2.setColor(SHADE_COLOR);
            g2.fill(this.shapeShade);
            g2.setColor(colorBak);
        }
        this.painter.drawDefaultColorEdge(g2, this.body, colorflg);
        Stroke original = g2.getStroke();
        g2.setStroke(STROKE_BREIF_VIEW);
        g2.draw(this.innerRect);
        g2.setStroke(original);
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        Point2D.Double p = ComplexBrief.getCoordinatesOfLinkPositionByInternalIndex(this.getSymbolBounds(), index);
        double margin = 2.5;
        switch (index) {
            case 0: {
                p.x += margin;
                p.y += margin;
                break;
            }
            case 4: {
                p.x -= margin;
                p.y += margin;
                break;
            }
            case 8: {
                p.x -= margin;
                p.y -= margin;
                break;
            }
            case 12: {
                p.x += margin;
                p.y -= margin;
            }
        }
        return p;
    }

    @Override
    public boolean isActivable() {
        return true;
    }

    @Override
    public void setIsDrawShade(boolean isDrawShade) {
        this.isDrawShade = isDrawShade;
    }

    @Override
    public boolean isDrawShade() {
        return this.isDrawShade;
    }

    @Override
    public Area getOutterShape() {
        return new Area(this.body);
    }

    @Override
    public double getDefaultAngle() {
        return -1.5707963267948966;
    }
}

