/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.species;

import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.sbi.celldesigner.symbol.species.RNA;

public class AntiSenseRNA
extends RNA {
    public static final String CODENAME = "ANTISENSE_RNA";

    @Override
    public boolean isRNA() {
        return false;
    }

    @Override
    public boolean isAntiSenseRNA() {
        return true;
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    protected Polygon createPolygon(int x, int y, int width, int height) {
        Polygon p = new Polygon();
        p.addPoint(x, y);
        p.addPoint(x + height, y + height);
        p.addPoint(x + width, y + height);
        p.addPoint(x + width - height, y);
        p.addPoint(x, y);
        return p;
    }

    @Override
    protected void calcPoints(double xD, double yD, double wD, double hD) {
        int x = (int)xD;
        int y = (int)yD;
        int width = (int)wD;
        int height = (int)hD;
        this.points[0].x = x;
        this.points[0].y = y;
        this.points[2].x = x + height;
        this.points[2].y = y + height;
        this.points[4].x = x + width;
        this.points[4].y = y + height;
        this.points[6].x = x + width - height;
        this.points[6].y = y;
        this.points[1].x = (this.points[0].x + this.points[2].x) / 2.0;
        this.points[1].y = (this.points[0].y + this.points[2].y) / 2.0;
        this.points[3].x = (this.points[2].x + this.points[4].x) / 2.0;
        this.points[3].y = (this.points[2].y + this.points[4].y) / 2.0;
        this.points[5].x = (this.points[4].x + this.points[6].x) / 2.0;
        this.points[5].y = (this.points[4].y + this.points[6].y) / 2.0;
        this.points[7].x = (this.points[6].x + this.points[0].x) / 2.0;
        this.points[7].y = (this.points[6].y + this.points[0].y) / 2.0;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        Rectangle2D.Double r = this.getSymbolBounds();
        if (this.isInSBGNViewer()) {
            Point2D.Double p = AntiSenseRNA.getCoordinatesOfLinkPositionByInternalIndex(this.getSymbolBounds(), index);
            switch (index) {
                case 8: {
                    p.x -= 1.0;
                    p.y -= 1.0;
                    break;
                }
                case 12: {
                    p.x += 1.0;
                    p.y -= 1.0;
                }
            }
            return p;
        }
        switch (index) {
            case 0: {
                Point2D.Double p1 = new Point2D.Double(r.x, r.y);
                return p1;
            }
            case 1: {
                Point2D.Double p1 = new Point2D.Double(r.x, r.y);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width - r.height, r.y);
                return this.meanPoint(p1, p2, 0.75);
            }
            case 2: {
                Point2D.Double p1 = new Point2D.Double(r.x, r.y);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width - r.height, r.y);
                return this.meanPoint(p1, p2, 0.5);
            }
            case 3: {
                Point2D.Double p1 = new Point2D.Double(r.x, r.y);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width - r.height, r.y);
                return this.meanPoint(p1, p2, 0.25);
            }
            case 4: {
                Point2D.Double p2 = new Point2D.Double(r.x + r.width - r.height, r.y);
                return p2;
            }
            case 5: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width - r.height, r.y);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width, r.y + r.height);
                return this.meanPoint(p1, p2, 0.75);
            }
            case 6: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width - r.height, r.y);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width, r.y + r.height);
                return this.meanPoint(p1, p2, 0.5);
            }
            case 7: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width - r.height, r.y);
                Point2D.Double p2 = new Point2D.Double(r.x + r.width, r.y + r.height);
                return this.meanPoint(p1, p2, 0.25);
            }
            case 8: {
                Point2D.Double p2 = new Point2D.Double(r.x + r.width, r.y + r.height);
                return p2;
            }
            case 9: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width, r.y + r.height);
                Point2D.Double p2 = new Point2D.Double(r.x + r.height, r.y + r.height);
                return this.meanPoint(p1, p2, 0.75);
            }
            case 10: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width, r.y + r.height);
                Point2D.Double p2 = new Point2D.Double(r.x + r.height, r.y + r.height);
                return this.meanPoint(p1, p2, 0.5);
            }
            case 11: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.width, r.y + r.height);
                Point2D.Double p2 = new Point2D.Double(r.x + r.height, r.y + r.height);
                return this.meanPoint(p1, p2, 0.25);
            }
            case 12: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.height, r.y + r.height);
                return p1;
            }
            case 13: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.height, r.y + r.height);
                Point2D.Double p2 = new Point2D.Double(r.x, r.y);
                return this.meanPoint(p1, p2, 0.75);
            }
            case 14: {
                Point2D.Double p1 = new Point2D.Double(r.x + r.height, r.y + r.height);
                Point2D.Double p2 = new Point2D.Double(r.x, r.y);
                return this.meanPoint(p1, p2, 0.5);
            }
            case 16: {
                Point2D.Double p1 = new Point2D.Double(r.getCenterX(), r.getCenterY());
                return p1;
            }
        }
        Point2D.Double p1 = new Point2D.Double(r.x + r.height, r.y + r.height);
        Point2D.Double p2 = new Point2D.Double(r.x, r.y);
        return this.meanPoint(p1, p2, 0.25);
    }
}

