/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction.mixednotation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.MixedNotationLineMarkShape;

public class PositiveInferenceLineMarkShape
extends MixedNotationLineMarkShape {
    private GeneralPath poutter = null;
    private static final double dAddtionThickness = 2.0;

    public PositiveInferenceLineMarkShape(LinkedCreaseLine p) {
        super(p);
    }

    public PositiveInferenceLineMarkShape() {
    }

    @Override
    public MixedNotationLineMarkShape createMyNewCopy() {
        return new PositiveInferenceLineMarkShape();
    }

    @Override
    public Rectangle2D.Double resetLineEndMarkPosition(Point2D.Double sp, Point2D.Double ep, double lineWidth) {
        double width = lineWidth + 4.0;
        double length = width * 3.0;
        AffineTransform affinetransform = new AffineTransform();
        affinetransform.translate(ep.x, ep.y);
        GUtil.addRotateAT(affinetransform, sp, ep);
        Point2D.Double top = new Point2D.Double(-width * 2.0 / 2.0, 0.0);
        Point2D.Double bottomR = new Point2D.Double(-length, width);
        Point2D.Double bottomL = new Point2D.Double(-length, -width);
        Point2D.Double topTransformed = new Point2D.Double();
        Point2D.Double bottomRTransformed = new Point2D.Double();
        Point2D.Double bottomLTransformed = new Point2D.Double();
        affinetransform.transform(top, topTransformed);
        affinetransform.transform(bottomR, bottomRTransformed);
        affinetransform.transform(bottomL, bottomLTransformed);
        this.poutter = new GeneralPath();
        this.poutter.reset();
        this.poutter.moveTo((float)bottomRTransformed.x, (float)bottomRTransformed.y);
        this.poutter.lineTo((float)topTransformed.x, (float)topTransformed.y);
        this.poutter.lineTo((float)bottomLTransformed.x, (float)bottomLTransformed.y);
        Point2D.Double sp1 = new Point2D.Double();
        affinetransform.transform(top, sp1);
        this.modifiedPoint = sp1;
        return GUtil.union(this.poutter.getBounds2D(), new Rectangle());
    }

    @Override
    public void drawModification(Graphics2D g2) {
        Color color = g2.getColor();
        BasicStroke org_stroke = (BasicStroke)g2.getStroke();
        this.dobeforeDrawModification(g2);
        this.drawGate(g2);
        if (!this.parent.isSingleLine()) {
            return;
        }
        if (this.polygonBounds != null && this.isVisible) {
            BasicStroke tmp_stroke = new BasicStroke((float)(this.parent.getLineWidth() + 2.0), 0, org_stroke.getLineJoin(), org_stroke.getMiterLimit(), org_stroke.getDashArray(), org_stroke.getDashPhase());
            g2.setStroke(tmp_stroke);
            g2.draw(this.poutter);
        }
        g2.setColor(color);
        g2.setStroke(org_stroke);
        this.doafterDrawModification(g2);
    }
}

