/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction.mixednotation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.MixedNotationLineMarkShape;

public class NegativeInferenceLineMarkShape
extends MixedNotationLineMarkShape {
    private Line2D line = new Line2D.Double();
    private static final Point2D.Double p1 = new Point2D.Double(-6.0, 0.0);
    private static final Point2D.Double p2 = new Point2D.Double(-5.0, 5.0);
    private static final Point2D.Double p3 = new Point2D.Double(-5.0, -5.0);
    private static final double dAddtionThickness = 2.0;

    public NegativeInferenceLineMarkShape() {
    }

    public NegativeInferenceLineMarkShape(LinkedCreaseLine p) {
        super(p);
    }

    @Override
    public MixedNotationLineMarkShape createMyNewCopy() {
        return new NegativeInferenceLineMarkShape();
    }

    @Override
    public Rectangle2D.Double resetLineEndMarkPosition(Point2D.Double start, Point2D.Double end, double lineWidth) {
        if (start == null || end == null) {
            return null;
        }
        double margin = 5.0;
        AffineTransform at = new AffineTransform();
        at.translate(end.x, end.y);
        GUtil.addRotateAT(at, start, end);
        double offset = margin + lineWidth / 2.0;
        NegativeInferenceLineMarkShape.p1.x = -offset;
        NegativeInferenceLineMarkShape.p2.x = NegativeInferenceLineMarkShape.p3.x = NegativeInferenceLineMarkShape.p1.x + 1.0;
        NegativeInferenceLineMarkShape.p2.y = lineWidth + 4.0;
        NegativeInferenceLineMarkShape.p3.y = -NegativeInferenceLineMarkShape.p2.y;
        Point2D.Double sp1 = new Point2D.Double();
        Point2D.Double sp2 = new Point2D.Double();
        Point2D.Double sp3 = new Point2D.Double();
        at.transform(p1, sp1);
        at.transform(p2, sp2);
        at.transform(p3, sp3);
        this.lineLineWidth = lineWidth;
        this.line.setLine(sp2, sp3);
        this.modifiedPoint = sp1;
        return GUtil.union(this.line.getBounds2D(), null);
    }

    @Override
    public void drawModification(Graphics2D g2) {
        Color color = g2.getColor();
        BasicStroke org_stroke = (BasicStroke)g2.getStroke();
        this.dobeforeDrawModification(g2);
        this.drawGate(g2);
        if (!this.parent.isSingleLine()) {
            return;
        }
        if (this.polygonBounds != null && this.isVisible) {
            BasicStroke tmp_stroke = new BasicStroke((float)(this.parent.getLineWidth() + 2.0), 0, org_stroke.getLineJoin(), org_stroke.getMiterLimit(), org_stroke.getDashArray(), org_stroke.getDashPhase());
            g2.setStroke(tmp_stroke);
            g2.draw(this.line);
        }
        g2.setColor(color);
        g2.setStroke(org_stroke);
        this.doafterDrawModification(g2);
    }
}

