/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction.mixednotation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.MixedNotationLineMarkShape;

public class MixedTriggerLineMarkShape
extends MixedNotationLineMarkShape {
    private GeneralPath poutter = null;
    private GeneralPath pinner = null;
    private Line2D.Double ln = null;
    private static final double dAddtionThickness = 2.0;

    public MixedTriggerLineMarkShape() {
    }

    public MixedTriggerLineMarkShape(LinkedCreaseLine p) {
        super(p);
    }

    @Override
    public MixedNotationLineMarkShape createMyNewCopy() {
        return new MixedTriggerLineMarkShape();
    }

    @Override
    public Rectangle2D.Double resetLineEndMarkPosition(Point2D.Double sp, Point2D.Double ep, double lineWidth) {
        double width = lineWidth + 4.0;
        double length = width * 3.0;
        AffineTransform affinetransform = new AffineTransform();
        affinetransform.translate(ep.x, ep.y);
        GUtil.addRotateAT(affinetransform, sp, ep);
        Point2D.Double top = new Point2D.Double(0.0, 0.0);
        Point2D.Double bottomR = new Point2D.Double(-length, width);
        Point2D.Double bottomL = new Point2D.Double(-length, -width);
        Point2D.Double topTransformed = new Point2D.Double();
        Point2D.Double bottomRTransformed = new Point2D.Double();
        Point2D.Double bottomLTransformed = new Point2D.Double();
        affinetransform.transform(top, topTransformed);
        affinetransform.transform(bottomR, bottomRTransformed);
        affinetransform.transform(bottomL, bottomLTransformed);
        this.poutter = new GeneralPath();
        this.poutter.reset();
        this.poutter.moveTo((float)topTransformed.x, (float)topTransformed.y);
        this.poutter.lineTo((float)bottomRTransformed.x, (float)bottomRTransformed.y);
        this.poutter.lineTo((float)bottomLTransformed.x, (float)bottomLTransformed.y);
        this.poutter.lineTo((float)topTransformed.x, (float)topTransformed.y);
        this.poutter.closePath();
        Point2D.Double topinner = new Point2D.Double((-lineWidth - 2.0) * 1.6, 0.0);
        Point2D.Double bottominnerR = new Point2D.Double(-length + (lineWidth + 2.0), width + (-lineWidth - 2.0));
        Point2D.Double bottominnerL = new Point2D.Double(-length + (lineWidth + 2.0), -width + (lineWidth + 2.0));
        Point2D.Double topinnerTransformed = new Point2D.Double();
        Point2D.Double bottominnerRTransformed = new Point2D.Double();
        Point2D.Double bottominnerLTransformed = new Point2D.Double();
        affinetransform.transform(topinner, topinnerTransformed);
        affinetransform.transform(bottominnerR, bottominnerRTransformed);
        affinetransform.transform(bottominnerL, bottominnerLTransformed);
        this.pinner = new GeneralPath();
        this.pinner.reset();
        this.pinner.moveTo((float)topinnerTransformed.x, (float)topinnerTransformed.y);
        this.pinner.lineTo((float)bottominnerRTransformed.x, (float)bottominnerRTransformed.y);
        this.pinner.lineTo((float)bottominnerLTransformed.x, (float)bottominnerLTransformed.y);
        this.pinner.lineTo((float)topinnerTransformed.x, (float)topinnerTransformed.y);
        this.pinner.closePath();
        Point2D.Double tp = new Point2D.Double(-length - 4.0 - lineWidth, -width * 0.5 - 2.0);
        Point2D.Double bottom = new Point2D.Double(-length - 4.0 - lineWidth, width * 0.5 + 2.0);
        Point2D.Double translatedTop = new Point2D.Double();
        Point2D.Double translatedBottom = new Point2D.Double();
        affinetransform.transform(tp, translatedTop);
        affinetransform.transform(bottom, translatedBottom);
        this.ln = new Line2D.Double(translatedTop, translatedBottom);
        Rectangle2D rectangle2d = this.ln.getBounds2D();
        Point2D.Double p1 = new Point2D.Double(-length, 0.0);
        Point2D.Double sp1 = new Point2D.Double();
        affinetransform.transform(p1, sp1);
        this.modifiedPoint = sp1;
        return GUtil.union(this.poutter.getBounds2D(), rectangle2d);
    }

    @Override
    public void drawModification(Graphics2D g2) {
        Color color = g2.getColor();
        BasicStroke org_stroke = (BasicStroke)g2.getStroke();
        this.dobeforeDrawModification(g2);
        this.drawGate(g2);
        if (!this.parent.isSingleLine()) {
            return;
        }
        if (this.polygonBounds != null && this.isVisible) {
            BasicStroke tmp_stroke = new BasicStroke((float)(this.parent.getLineWidth() + 2.0), org_stroke.getEndCap(), org_stroke.getLineJoin(), org_stroke.getMiterLimit(), org_stroke.getDashArray(), org_stroke.getDashPhase());
            g2.setStroke(tmp_stroke);
            g2.fill(this.poutter);
            g2.draw(this.ln);
            g2.setColor(Color.white);
            g2.fill(this.pinner);
        }
        g2.setColor(color);
        g2.setStroke(org_stroke);
        this.doafterDrawModification(g2);
    }
}

