/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction;

import java.awt.geom.Point2D;
import java.util.Map;
import java.util.Vector;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineArrowShape;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.symbol.reaction.AddProduct;
import jp.sbi.celldesigner.symbol.reaction.AddReactant;
import jp.sbi.celldesigner.symbol.reaction.GModificationRectangle;
import jp.sbi.celldesigner.symbol.reaction.KnownTransitionOmitted;
import jp.sbi.celldesigner.symbol.reaction.UnknownTransition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;

public class StateTransition
extends LinkedCreaseLine
implements SBSymbol,
ReactionSymbol {
    public static final String CODENAME = "STATE_TRANSITION";
    private boolean isReversible = false;
    protected GLinkedLineArrowShape arrowShape1;
    protected GLinkedLineArrowShape arrowShape3;
    protected GModificationRectangle rectangShape;
    private static final String KNOWNTRANSITION_MARK = "//";
    private static final String UNKNOWNTRANSITION_MARK = "?";
    private static final String STATETRANSITION_MARK = "";

    @Override
    protected void init1(int newCreaseLineNumber) {
        this.lines = new GLinkedStraightLine[newCreaseLineNumber];
        int i = 0;
        while (i < newCreaseLineNumber) {
            this.lines[i] = new GLinkedStraightLine();
            ++i;
        }
        this.arrowShape1 = new GLinkedLineArrowShape();
        this.arrowShape1.setType(1);
        this.arrowShape1.setReversed(true);
        this.arrowShape1.setVisible(false);
        this.lines[0].addModificationShape(this.arrowShape1);
        this.arrowShape3 = new GLinkedLineArrowShape();
        this.arrowShape3.setType(1);
        this.lines[newCreaseLineNumber - 1].addModificationShape(this.arrowShape3);
        this.arrowShape1.setIndex(1);
        this.arrowShape3.setIndex(3);
        this.rectangShape = new GModificationRectangle();
        int mod = newCreaseLineNumber - newCreaseLineNumber / 2 * 2;
        int index = newCreaseLineNumber / 2 + mod - 1;
        if (index < 0) {
            index = 0;
        }
        if (this instanceof KnownTransitionOmitted) {
            this.rectangShape.setMarkString(KNOWNTRANSITION_MARK);
        } else if (this instanceof UnknownTransition) {
            this.rectangShape.setMarkString(UNKNOWNTRANSITION_MARK);
        } else {
            this.rectangShape.setMarkString(STATETRANSITION_MARK);
        }
        this.rectangShape.setVisible(true);
        this.lines[index].addModificationShape(this.rectangShape);
    }

    @Override
    protected void init2(int newCreaseLineNumber) {
        try {
            super.setLines(this.lines);
            super.setDefaultTargetLineIndex(newCreaseLineNumber / 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void setupNewLinesByAddPoint(Vector vec, int index, GLinkedStraightLine oldLine, GLinkedStraightLine newLine, Map paramMap) {
        for (GLinkedLineModificationShape m : vec) {
            if (m instanceof GLinkedLineArrowShape && ((GLinkedLineArrowShape)m).getIndex() == 1) {
                oldLine.addModificationShape(m);
                continue;
            }
            if (m instanceof GLinkedLineArrowShape && ((GLinkedLineArrowShape)m).getIndex() == 3) {
                newLine.addModificationShape(m);
                continue;
            }
            if (!(m instanceof GModificationRectangle)) continue;
            double originalIndex = (this.lines.length - 1) / 2;
            if ((double)(index + 1) > originalIndex) {
                oldLine.addModificationShape(m);
                continue;
            }
            newLine.addModificationShape(m);
        }
    }

    @Override
    public GLinkedLine createCopiedLine() {
        GLinkedLine line = super.createCopiedLine();
        ((StateTransition)line).resetPorcessNode(this.getOmittedShapeIndex());
        ((StateTransition)line).resetLineArrow();
        ((ReactionSymbol)((Object)line)).setReversible(this.isReversible);
        return line;
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public void setReversible(boolean isReversible) {
        if (isReversible) {
            this.arrowShape1.setVisible(true);
        } else {
            this.arrowShape1.setVisible(false);
        }
        this.isReversible = isReversible;
    }

    @Override
    public boolean isReversible() {
        return this.isReversible;
    }

    @Override
    public int sourceSize() {
        return 1;
    }

    @Override
    public int destinationSize() {
        return 1;
    }

    @Override
    public boolean isLinkable(GLinkTarget elem, int index) {
        if (index == 0) {
            if (elem instanceof SpeciesAlias) {
                return true;
            }
        } else if (index == 1) {
            if (elem instanceof SpeciesAlias) {
                return true;
            }
            if (elem instanceof ReactionLink && ((ReactionLink)elem).isBaseLink() && !(((ReactionLink)elem).getGLinkedShape() instanceof LinkedCreaseLineMixedNotation)) {
                return true;
            }
        }
        return false;
    }

    public int getOmittedShapeIndex() {
        int length = this.lines.length;
        int i = 0;
        while (i < length) {
            Vector modifications = this.lines[i].getLineModifications();
            int size = modifications.size();
            int j = 0;
            while (j < size) {
                if (modifications.elementAt(j) instanceof GModificationRectangle) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public GModificationRectangle getOmittedShape() {
        int index = this.getOmittedShapeIndex();
        if (index < 0 || index > this.lines.length - 1) {
            return null;
        }
        Vector modifications = this.lines[index].getLineModifications();
        int size = modifications.size();
        int i = 0;
        while (i < size) {
            if (modifications.elementAt(i) instanceof GModificationRectangle) {
                return (GModificationRectangle)modifications.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    protected Point2D.Double[] setupLinkAnchorCoord() {
        int index = this.getOmittedShapeIndex();
        GModificationRectangle omittedShape = this.getOmittedShape();
        if (omittedShape != null) {
            return omittedShape.getAnchors(index == 0 || index == this.lines.length - 1);
        }
        return null;
    }

    @Override
    public boolean inLine(double x, double y) {
        if (super.inLine(x, y)) {
            return true;
        }
        GModificationRectangle omittedShape = this.getOmittedShape();
        return omittedShape != null && omittedShape.inShape(x, y);
    }

    public void setRectangleIndex(int index) {
        Vector v = new Vector();
        try {
            v = this.getLines()[this.getOmittedShapeIndex()].getLineModifications();
        }
        catch (Exception myErr) {
            v = new Vector();
        }
        if (v != null && v.size() > 0) {
            Vector tmpVec2 = new Vector();
            int j = 0;
            while (j < v.size()) {
                if (v.get(j) instanceof GModificationRectangle) {
                    tmpVec2.add(v.get(j));
                }
                ++j;
            }
            j = 0;
            while (j < tmpVec2.size()) {
                v.remove(tmpVec2.get(j));
                ++j;
            }
        }
        if (index < 0 || index > this.lines.length - 1) {
            this.getLines()[0].addModificationShape(this.rectangShape);
            return;
        }
        this.getLines()[index].addModificationShape(this.rectangShape);
    }

    private void unloadProcessNode() {
        int i = 0;
        while (i < this.lines.length) {
            Vector tmpVec = this.lines[i].getLineModifications();
            if (tmpVec != null && tmpVec.size() > 0) {
                Vector tmpVec2 = new Vector();
                int j = 0;
                while (j < tmpVec.size()) {
                    if (tmpVec.get(j) instanceof GModificationRectangle) {
                        tmpVec2.add(tmpVec.get(j));
                    }
                    ++j;
                }
                j = 0;
                while (j < tmpVec2.size()) {
                    tmpVec.remove(tmpVec2.get(j));
                    ++j;
                }
            }
            ++i;
        }
    }

    public void resetPorcessNode(int index) {
        this.unloadProcessNode();
        this.setRectangleIndex(index);
    }

    public Point2D.Double getAddReactantAddProductCurvePoint(GLinkedShape shp) {
        try {
            GModificationRectangle processnode = this.getOmittedShape();
            Point2D.Double[] arrTemp = processnode.getAnchorsInLineEnd();
            if (arrTemp == null || arrTemp.length != 8) {
                return new Point2D.Double();
            }
            if (shp != null && shp instanceof AddReactant) {
                return arrTemp[0];
            }
            if (shp != null && shp instanceof AddProduct) {
                return arrTemp[1];
            }
            return new Point2D.Double();
        }
        catch (Exception myErr) {
            return new Point2D.Double();
        }
    }

    private void resetLineArrow() {
        try {
            int i = 0;
            while (i < this.lines.length) {
                Vector tmpVec = this.lines[i].getLineModifications();
                if (tmpVec != null && tmpVec.size() > 0) {
                    Vector tmpVec2 = new Vector();
                    int j = 0;
                    while (j < tmpVec.size()) {
                        if (tmpVec.get(j) instanceof GLinkedLineArrowShape) {
                            tmpVec2.add(tmpVec.get(j));
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < tmpVec2.size()) {
                        tmpVec.remove(tmpVec2.get(j));
                        ++j;
                    }
                }
                ++i;
            }
            this.getLines()[0].addModificationShape(this.arrowShape1);
            this.getLines()[this.lines.length - 1].addModificationShape(this.arrowShape3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

