/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.symbol.reaction.DimerFormation;
import jp.sbi.celldesigner.symbol.reaction.Dissociation;
import jp.sbi.celldesigner.symbol.reaction.Truncation;

public class GModificationRectangle
implements GLinkedLineModificationShape {
    public static final double Percent_FromLineEndPointToCenterPoint = 0.75;
    double rd = 5.01;
    Rectangle2D.Double polygonBounds = null;
    Shape drawshape = null;
    String markTxt = "";
    double cx;
    double cy;
    Point2D.Double[] anchor = new Point2D.Double[8];
    Point2D.Double[] Lineanchor = new Point2D.Double[8];
    Rectangle2D.Double rect = null;
    Rectangle2D.Double inShapeRect = null;
    Shape inShape = null;
    private GeneralPath gpImgMark = new GeneralPath();
    private static final Point2D.Double p1ofTruncationMark = new Point2D.Double(2.0, -5.0);
    private static final Point2D.Double p2ofTruncationMark = new Point2D.Double(2.0, 2.0);
    private static final Point2D.Double p3ofTruncationMark = new Point2D.Double(-2.0, -2.0);
    private static final Point2D.Double p4ofTruncationMark = new Point2D.Double(-2.0, 5.0);
    private Object ownerOfThisProcessNode = new Object();
    private boolean isInSBGNViewer = false;
    private boolean isVisible = true;

    public void setOwnerOfThisProcessNode(Object own) {
        this.ownerOfThisProcessNode = own;
    }

    private void createAnchor(Point2D.Double start, Point2D.Double end, AffineTransform at) {
        this.cx = (end.x + start.x) / 2.0;
        this.cy = (end.y + start.y) / 2.0;
        at.translate(this.cx, this.cy);
        GUtil.addRotateAT(at, start, end);
        Point2D.Double p1 = new Point2D.Double(start.x, start.y);
        Point2D.Double p2 = new Point2D.Double(end.x, end.y);
        Point2D.Double p3 = new Point2D.Double(0.0, -this.rd);
        Point2D.Double p4 = new Point2D.Double(0.0, this.rd);
        Point2D.Double px = new Point2D.Double();
        Point2D.Double py = new Point2D.Double();
        double addreactantpointX = start.x + (this.cx - start.x) * 0.75;
        double addreactantpointY = start.y + (this.cy - start.y) * 0.75;
        double addproductpointX = end.x - (end.x - this.cx) * 0.75;
        double addproductpointY = end.y - (end.y - this.cy) * 0.75;
        Point2D.Double pa = new Point2D.Double(addreactantpointX, addreactantpointY);
        Point2D.Double pb = new Point2D.Double(addproductpointX, addproductpointY);
        this.anchor[0] = p1;
        this.anchor[1] = p2;
        at.transform(p3, px);
        this.anchor[2] = px;
        at.transform(p4, py);
        this.anchor[3] = py;
        this.Lineanchor[0] = pa;
        this.Lineanchor[1] = pb;
        this.Lineanchor[2] = px;
        this.Lineanchor[3] = py;
        Point2D.Double p5 = new Point2D.Double(-this.rd, -this.rd);
        Point2D.Double p6 = new Point2D.Double(this.rd, -this.rd);
        Point2D.Double p7 = new Point2D.Double(-this.rd, this.rd);
        Point2D.Double p8 = new Point2D.Double(this.rd, this.rd);
        Point2D.Double p55 = new Point2D.Double();
        Point2D.Double p66 = new Point2D.Double();
        Point2D.Double p77 = new Point2D.Double();
        Point2D.Double p88 = new Point2D.Double();
        at.transform(p5, p55);
        this.anchor[4] = p55;
        at.transform(p6, p66);
        this.anchor[5] = p66;
        at.transform(p7, p77);
        this.anchor[6] = p77;
        at.transform(p8, p88);
        this.anchor[7] = p88;
        this.Lineanchor[4] = p55;
        this.Lineanchor[5] = p66;
        this.Lineanchor[6] = p77;
        this.Lineanchor[7] = p88;
        if (this.isInSBGNViewer && !(this.ownerOfThisProcessNode instanceof Truncation)) {
            Point2D.Double pCentre;
            this.Lineanchor[0] = p1;
            this.Lineanchor[1] = p2;
            this.Lineanchor[2] = pCentre = new Point2D.Double((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0);
            this.Lineanchor[3] = pCentre;
            this.Lineanchor[4] = pCentre;
            this.Lineanchor[5] = pCentre;
            this.Lineanchor[6] = pCentre;
            this.Lineanchor[7] = pCentre;
        }
    }

    public Point2D.Double[] getAnchors(boolean bPointIsNotEndOfLine) {
        return this.Lineanchor;
    }

    public Point2D.Double[] getAnchorsInLineEnd() {
        return this.anchor;
    }

    public GModificationRectangle() {
        this.rect = new Rectangle2D.Double();
        this.rect.setFrame(-this.rd, -this.rd, 2.0 * this.rd, 2.0 * this.rd);
        this.inShapeRect = new Rectangle2D.Double();
        this.inShapeRect.setFrame(-this.rd - 8.0, -this.rd - 8.0, 2.0 * this.rd + 16.0, 2.0 * this.rd + 16.0);
    }

    @Override
    public Rectangle2D.Double updateModification(Point2D.Double start, Point2D.Double end, double lineWidth) {
        Rectangle2D.Double prev = this.polygonBounds;
        if (start == null || end == null) {
            return null;
        }
        AffineTransform at = new AffineTransform();
        this.createAnchor(start, end, at);
        this.drawshape = at.createTransformedShape(this.rect);
        this.inShape = at.createTransformedShape(this.inShapeRect);
        Rectangle2D rect1 = this.drawshape.getBounds2D();
        double extend = Math.ceil(Math.sqrt(10.0) * 0.5 * lineWidth);
        this.polygonBounds = new Rectangle2D.Double(rect1.getX() - extend, rect1.getY() - extend, rect1.getWidth() + 2.0 * extend, rect1.getHeight() + 2.0 * extend);
        this.buildImgMarkShape(start, end, lineWidth);
        if (prev == null) {
            return this.polygonBounds;
        }
        if (prev.equals(this.polygonBounds)) {
            return null;
        }
        return GUtil.union(prev, this.polygonBounds);
    }

    public Rectangle2D.Double buildImgMarkShape(Point2D.Double start, Point2D.Double end, double lineWidth) {
        Rectangle2D.Double rtn = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        if (start == null || end == null) {
            return rtn;
        }
        this.gpImgMark = new GeneralPath();
        if (this.ownerOfThisProcessNode != null && this.ownerOfThisProcessNode instanceof Truncation) {
            GLinkedStraightLine subline = ((Truncation)this.ownerOfThisProcessNode).getTheSubGLinkedStraightLineHavingProcessNode();
            if (subline == null) {
                return rtn;
            }
            Point2D.Double sublineStart = subline.getStartPoint();
            Point2D.Double sublineEnd = subline.getEndPoint();
            if (sublineStart == null || sublineEnd == null) {
                return rtn;
            }
            AffineTransform at = new AffineTransform();
            this.createAnchor(sublineEnd, sublineStart, at);
            Point2D.Double sp1 = new Point2D.Double();
            Point2D.Double sp2 = new Point2D.Double();
            Point2D.Double sp3 = new Point2D.Double();
            Point2D.Double sp4 = new Point2D.Double();
            at.transform(p1ofTruncationMark, sp1);
            at.transform(p2ofTruncationMark, sp2);
            at.transform(p3ofTruncationMark, sp3);
            at.transform(p4ofTruncationMark, sp4);
            this.gpImgMark.reset();
            this.gpImgMark.moveTo((float)sp1.x, (float)sp1.y);
            this.gpImgMark.lineTo((float)sp2.x, (float)sp2.y);
            this.gpImgMark.lineTo((float)sp3.x, (float)sp3.y);
            this.gpImgMark.lineTo((float)sp4.x, (float)sp4.y);
        }
        Rectangle rect = this.gpImgMark.getBounds();
        return new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public Rectangle2D.Double getModificationBounds() {
        return this.polygonBounds;
    }

    @Override
    public void drawModification(Graphics2D g2) {
        if ((this.ownerOfThisProcessNode instanceof DimerFormation || this.ownerOfThisProcessNode instanceof Dissociation) && this.isInSBGNViewer) {
            return;
        }
        if (this.polygonBounds != null) {
            BasicStroke org_stroke = new BasicStroke();
            org_stroke = (BasicStroke)g2.getStroke();
            BasicStroke tmp_stroke = new BasicStroke(org_stroke.getLineWidth(), 0, org_stroke.getLineJoin(), org_stroke.getMiterLimit(), org_stroke.getDashArray(), org_stroke.getDashPhase());
            Color oldcolor = g2.getColor();
            g2.setColor(Color.white);
            g2.fill(this.drawshape);
            g2.setColor(oldcolor);
            g2.setStroke(tmp_stroke);
            g2.draw(this.drawshape);
            if (this.ownerOfThisProcessNode instanceof Truncation && !this.isInSBGNViewer) {
                BasicStroke imgMark_stroke = new BasicStroke(1.0f, 0, org_stroke.getLineJoin(), org_stroke.getMiterLimit(), org_stroke.getDashArray(), org_stroke.getDashPhase());
                g2.setStroke(imgMark_stroke);
                g2.draw(this.gpImgMark);
                g2.setStroke(tmp_stroke);
            } else {
                this.setTextFont(g2);
            }
            g2.setStroke(org_stroke);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Override
    public GLinkedLineModificationShape createCopy() {
        GModificationRectangle shape = new GModificationRectangle();
        shape.setVisible(this.isVisible);
        shape.setMarkString(this.getMarkString());
        try {
            shape.drawshape = (Shape)this.drawshape.getClass().getMethod("clone", null).invoke((Object)this.drawshape, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return shape;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public Double modifyLine(Double modifiedLine) {
        return modifiedLine;
    }

    private void setTextFont(Graphics2D g2) {
        Font ft = g2.getFont();
        int fontSize = 10;
        g2.setFont(new Font("Times New Roman", 1, fontSize));
        FontMetrics fm = g2.getFontMetrics();
        double stringWidth = fm.stringWidth(this.markTxt);
        double x = this.cx - stringWidth / 2.0;
        double y = this.cy + (double)(fm.getMaxAscent() * 3 / 8);
        g2.drawString(this.markTxt, (float)x, (float)y);
        g2.setFont(ft);
    }

    public boolean inShape(double x, double y) {
        return this.inShape.contains(x, y);
    }

    @Override
    public Line2D.Double modifyLine(Line2D.Double modifiedLine) {
        return modifiedLine;
    }

    public void setMarkString(String value) {
        this.markTxt = value;
    }

    public String getMarkString() {
        return this.markTxt;
    }

    public void setIsInSBGNViewer(boolean flag) {
        this.isInSBGNViewer = flag;
    }

    public boolean isInSBGNViewer() {
        return this.isInSBGNViewer;
    }
}

