/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.MarkInendofModificationLine;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;

class GModificationLozenge
implements GLinkedLineModificationShape {
    private double width = 3.0;
    private double length = 6.0;
    private Polygon p = null;
    private Rectangle2D.Double polygonBounds = null;
    private int type = 0;
    private boolean isVisible = true;
    private GeneralPath pfloatLozengeShape = null;
    private Point2D modifiedPoint = null;
    LinkedCreaseLine parent = null;
    double lineLineWidth = 1.0;
    private Ellipse2D ellipseGate = new Ellipse2D.Double();
    private Rectangle2D.Double ellipse2Bounds = null;
    private Point2D gatePoint;
    private int index = 0;

    private String getLogicGateType() {
        String s = "";
        if (!this.isDrawGate()) {
            return s;
        }
        int type = this.parent.getLogicGate().getLogicType();
        switch (type) {
            case 1: {
                return "&";
            }
            case 2: {
                return "|";
            }
            case 4: {
                return "!";
            }
            case 3: {
                return "?";
            }
        }
        return s;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int indx) {
        this.index = indx;
    }

    public void setParent(LinkedCreaseLine parent) {
        this.parent = parent;
    }

    private boolean isDrawGate() {
        if (!this.parent.isLogicGate()) {
            return false;
        }
        if (this.parent.getLogicGate() == null) {
            return false;
        }
        int type = this.parent.getLogicGate().getLogicType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private void drawGate(Graphics2D g2) {
        if (!this.isDrawGate()) {
            return;
        }
        if (this.ellipseGate != null && this.isVisible) {
            Color bu = g2.getColor();
            BasicStroke org_stroke = (BasicStroke)g2.getStroke();
            Font oldFont = g2.getFont();
            BasicStroke stroke = new BasicStroke((float)this.lineLineWidth);
            g2.setStroke(stroke);
            g2.setColor(Color.WHITE);
            g2.fill(this.ellipseGate);
            g2.setColor(bu);
            g2.draw(this.ellipseGate);
            String family = g2.getFont().getFamily();
            Font font = new Font(family, 0, 11);
            g2.setFont(font);
            String s = this.getLogicGateType();
            if (GLogicGate.isLogicGateInSBGNViewer(this.parent)) {
                s = GLogicGate.getLogicGateTypeInSBGNViewer(this.parent.getLogicGate().getLogicType());
            }
            double h = g2.getFontMetrics().getAscent();
            double h2 = g2.getFontMetrics().getDescent();
            h -= h2;
            double w = 0.0;
            int i = 0;
            while (i < s.toCharArray().length) {
                w += (double)g2.getFontMetrics().charWidth(s.toCharArray()[i]);
                ++i;
            }
            double x = this.gatePoint.getX() - w / 2.0;
            double y = this.gatePoint.getY() + h / 2.0;
            g2.drawString(s, (int)x, (int)y);
            g2.setFont(oldFont);
            g2.setStroke(org_stroke);
        }
    }

    private Rectangle2D.Double updateGate(Point2D.Double start, Point2D.Double end, double lineWidth) {
        this.lineLineWidth = lineWidth;
        if (!this.isDrawGate()) {
            this.ellipse2Bounds = null;
            return null;
        }
        Rectangle2D.Double prev = this.ellipse2Bounds;
        double size = lineWidth + 11.0;
        if (GLogicGate.isLogicGateInSBGNViewer(this.parent)) {
            size = lineWidth + 24.0;
        }
        GLogicGate gate = this.parent.getLogicGate();
        Point2D.Double headerPoint = null;
        headerPoint = gate.getHeaderPoint().getPosition() != null ? new Point2D.Double(gate.getHeaderPoint().getPosition().x, gate.getHeaderPoint().getPosition().y) : start;
        this.ellipseGate.setFrame(headerPoint.x - size / 2.0, headerPoint.y - size / 2.0, size, size);
        this.gatePoint = headerPoint;
        double extend = Math.ceil(0.5 * lineWidth);
        Rectangle2D r2 = this.ellipseGate.getBounds2D();
        this.ellipse2Bounds = new Rectangle2D.Double(r2.getX() - extend, r2.getY() - extend, r2.getWidth() + 2.0 * extend, r2.getHeight() + 2.0 * extend);
        if (prev == null) {
            return this.ellipse2Bounds;
        }
        if (prev.equals(this.ellipse2Bounds)) {
            return null;
        }
        return GUtil.union(prev, this.ellipse2Bounds);
    }

    public GModificationLozenge(LinkedCreaseLine parent) {
        this.parent = parent;
    }

    @Override
    public GLinkedLineModificationShape createCopy() {
        GModificationLozenge copy = new GModificationLozenge(null);
        copy.setLength(this.length);
        copy.setWidth(this.width);
        copy.setVisible(this.isVisible);
        copy.setIndex(this.index);
        return copy;
    }

    public Polygon createPolygon(Point2D.Double p1, Point2D.Double p2, Point2D.Double tip, double height, double base, int type, double lwidth) {
        double xshift = 0.0;
        if (type != 1) {
            xshift = lwidth;
        }
        AffineTransform affinetransform = new AffineTransform();
        affinetransform.translate(tip.x, tip.y);
        GUtil.addRotateAT(affinetransform, p1, p2);
        Point2D.Double top = new Point2D.Double(-xshift, 0.0);
        Point2D.Double bottomR = new Point2D.Double(-height - xshift, base);
        Point2D.Double bottomL = new Point2D.Double(-height - xshift, -base);
        Point2D.Double topL = new Point2D.Double((-height - xshift) * 2.0 + xshift, 0.0);
        Point2D.Double middle = new Point2D.Double(bottomR.x, 0.0);
        Point2D.Double topTransformed = new Point2D.Double();
        Point2D.Double bottomRTransformed = new Point2D.Double();
        Point2D.Double bottomLTransformed = new Point2D.Double();
        Point2D.Double topLTransformed = new Point2D.Double();
        affinetransform.transform(top, topTransformed);
        affinetransform.transform(bottomR, bottomRTransformed);
        affinetransform.transform(bottomL, bottomLTransformed);
        affinetransform.transform(topL, topLTransformed);
        Polygon polygon = new Polygon();
        polygon.addPoint((int)topTransformed.x, (int)topTransformed.y);
        polygon.addPoint((int)bottomRTransformed.x, (int)bottomRTransformed.y);
        polygon.addPoint((int)topLTransformed.x, (int)topLTransformed.y);
        polygon.addPoint((int)bottomLTransformed.x, (int)bottomLTransformed.y);
        polygon.addPoint((int)topTransformed.x, (int)topTransformed.y);
        this.pfloatLozengeShape = new GeneralPath();
        this.pfloatLozengeShape.reset();
        this.pfloatLozengeShape.moveTo((float)topTransformed.x, (float)topTransformed.y);
        this.pfloatLozengeShape.lineTo((float)bottomRTransformed.x, (float)bottomRTransformed.y);
        this.pfloatLozengeShape.lineTo((float)topLTransformed.x, (float)topLTransformed.y);
        this.pfloatLozengeShape.lineTo((float)bottomLTransformed.x, (float)bottomLTransformed.y);
        this.pfloatLozengeShape.lineTo((float)topTransformed.x, (float)topTransformed.y);
        this.pfloatLozengeShape.closePath();
        Point2D.Double mp = new Point2D.Double();
        affinetransform.transform(middle, mp);
        this.modifiedPoint = mp;
        return polygon;
    }

    @Override
    public void drawModification(Graphics2D graphics2d) {
        this.drawGate(graphics2d);
        if (!this.parent.isSingleLine()) {
            return;
        }
        if (this.pfloatLozengeShape != null && this.isVisible) {
            if (this.type == 1) {
                graphics2d.fill(this.pfloatLozengeShape);
            } else {
                Color color = graphics2d.getColor();
                graphics2d.setColor(Color.white);
                graphics2d.fill(this.pfloatLozengeShape);
                graphics2d.setColor(color);
                graphics2d.draw(this.pfloatLozengeShape);
            }
        }
    }

    @Override
    public Rectangle2D.Double getModificationBounds() {
        Rectangle2D.Double gateBounds = null;
        Rectangle2D.Double modificationBounds = null;
        if (this.isDrawGate()) {
            gateBounds = this.ellipse2Bounds;
        }
        if (this.parent.isSingleLine()) {
            modificationBounds = this.polygonBounds;
        }
        return GUtil.union(gateBounds, modificationBounds);
    }

    public void setLength(double length) {
        this.length = length;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    @Override
    public Rectangle2D.Double updateModification(Point2D.Double start, Point2D.Double end, double lineWidth) {
        Rectangle2D.Double gateBounds = null;
        if (this.isDrawGate()) {
            gateBounds = this.updateGate(start, end, lineWidth);
        }
        if (!this.parent.isSingleLine()) {
            return gateBounds;
        }
        Rectangle2D.Double redrawArea = this.polygonBounds;
        if (start == null || end == null) {
            return null;
        }
        this.width = lineWidth + 3.0;
        this.length = this.width * 2.0;
        Point2D.Double modifyPoint = null;
        double offset = lineWidth / 2.0 * 0.6;
        modifyPoint = MarkInendofModificationLine.calcNewTargetPoint(this.parent, offset);
        Point2D.Double sp = start;
        Point2D.Double ep = modifyPoint != null ? modifyPoint : end;
        this.p = this.createPolygon(sp, ep, ep, this.length, this.width, this.type, lineWidth);
        if (this.p != null) {
            double extend = Math.ceil(Math.sqrt(10.0) * 0.5 * lineWidth);
            Rectangle2D rectangle2d = this.p.getBounds2D();
            this.polygonBounds = new Rectangle2D.Double(rectangle2d.getX() - extend, rectangle2d.getY() - extend, rectangle2d.getWidth() + 2.0 * extend, rectangle2d.getHeight() + 2.0 * extend);
        }
        AffineTransform at = new AffineTransform();
        at.translate(ep.x, ep.y);
        GUtil.addRotateAT(at, sp, ep);
        Point2D.Double p1 = new Point2D.Double(-this.length * 0.9, 0.0);
        Point2D.Double sp1 = new Point2D.Double();
        at.transform(p1, sp1);
        if (redrawArea == null) {
            return GUtil.union(this.polygonBounds, gateBounds);
        }
        if (redrawArea.equals(this.polygonBounds)) {
            return gateBounds;
        }
        return GUtil.union(GUtil.union(redrawArea, this.polygonBounds), gateBounds);
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public Line2D.Double modifyLine(Line2D.Double line) {
        return MarkInendofModificationLine.modifyLinkedtoLogicGateSubLineAgain(line, this.parent, false, this.modifiedPoint);
    }
}

