/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkConnectSchemeOwner;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedLineIndexPossesive;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.LinkedCreaseLineModification;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.symbol.reaction.Catalysis;
import jp.sbi.celldesigner.symbol.reaction.Inhibition;
import jp.sbi.celldesigner.symbol.reaction.Modulation;
import jp.sbi.celldesigner.symbol.reaction.PhysicalStimulation;
import jp.sbi.celldesigner.symbol.reaction.TranscriptionalActivation;
import jp.sbi.celldesigner.symbol.reaction.TranscriptionalInhibition;
import jp.sbi.celldesigner.symbol.reaction.TranslationalActivation;
import jp.sbi.celldesigner.symbol.reaction.TranslationalInhibition;
import jp.sbi.celldesigner.symbol.reaction.Trigger;
import jp.sbi.celldesigner.symbol.reaction.UnknownCatalysis;
import jp.sbi.celldesigner.symbol.reaction.UnknownInhibition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.MixedModulation;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.MixedPhysicalStimulation;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.MixedTrigger;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.NegativeInference;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.PositiveInference;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.UnknownModulation;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.UnknownNegativeInference;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.UnknownPhysicalStimulation;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.UnknownPositiveInference;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.UnknownTrigger;

public abstract class GLogicGate
implements ReactionSymbol,
SBSymbol,
GLinkedShape,
GEditable,
GLinkedLineIndexPossesive,
GLinkConnectSchemeOwner {
    private Vector childrenLink = new Vector();
    private int modificationType = 1;
    private LinkedCreaseLine realLine = null;
    GCreasePoint headerPoint = null;
    private Vector relationSpecies = new Vector();
    public static final double GATE_WIDTH = 11.0;
    public static final int GATETYPE_FontSize = 11;
    private boolean isInSBGNViewer = false;
    public static final double GATE_DIAMETER_InSBGNViewer = 24.0;

    public GLogicGate() {
        this.initRealLine();
    }

    public GLogicGate(int modificationType) {
        this.setModificationType(modificationType);
    }

    @Override
    public int destinationSize() {
        return 1;
    }

    @Override
    public void drawPreview(Graphics2D g2, Rectangle bounds, Color color, double width) {
        ((ReactionSymbol)((Object)this.realLine)).drawPreview(g2, bounds, color, width);
    }

    @Override
    public boolean isLinkable(GLinkTarget target, int index) {
        if (target instanceof SpeciesAlias) {
            return true;
        }
        if (target instanceof ReactionLink) {
            ReactionLink link = (ReactionLink)target;
            if (!(link.getSymbol() instanceof GLogicGate) && link.isBaseLink()) {
                return true;
            }
            if (GLogicGate.isModification(link.getGLinkedShape()) && ((LinkedCreaseLine)link.getGLinkedShape()).isSingleLine()) {
                return true;
            }
            if (link.getGLinkedShape() instanceof GLogicGate && this.getLogicType() == ((GLogicGate)link.getGLinkedShape()).getLogicType()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isReversible() {
        return ((ReactionSymbol)((Object)this.realLine)).isReversible();
    }

    @Override
    public void setReversible(boolean isReversible) {
        ((ReactionSymbol)((Object)this.realLine)).setReversible(isReversible);
    }

    @Override
    public int sourceSize() {
        return ((ReactionSymbol)((Object)this.realLine)).sourceSize();
    }

    @Override
    public GLinkedShape createCopy() {
        GLinkedShape shape = this.realLine.createCopy();
        try {
            GLogicGate copy = (GLogicGate)this.getClass().newInstance();
            copy.setModificationType(this.modificationType);
            copy.setRealLine((LinkedCreaseLine)shape);
            ((LinkedCreaseLine)shape).setLogicGateFlg(true);
            ((LinkedCreaseLine)shape).setLogicGate(copy);
            copy.setStartPoint(new Point2D.Double(this.headerPoint.getPosition().x, this.headerPoint.getPosition().y));
            return copy;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void drawShape(Graphics2D graphics2d) {
        this.realLine.drawLine(graphics2d);
    }

    @Override
    public void drawWhiteBaseShape(Graphics2D graphics2d) {
        this.realLine.drawWhiteBaseShape(graphics2d);
    }

    @Override
    public Color getColor() {
        return this.realLine.getColor();
    }

    @Override
    public int getCurveBindingIndex() {
        return this.realLine.getCurveBindingIndex();
    }

    @Override
    public GLinkedLineIndex getGLinkedLineIndexAt(int i) {
        return this.realLine.getGLinkedLineIndexAt(i);
    }

    @Override
    public double getLineWidth() {
        return this.realLine.getLineWidth();
    }

    @Override
    public Point2D.Double getOffset() {
        return this.realLine.getOffset();
    }

    @Override
    public GLinkPositionInfo getPointedLinkPosition(double x, double y) {
        return this.realLine.getPointedLinkPosition(x, y);
    }

    @Override
    public Rectangle2D.Double getShapeBounds() {
        return this.realLine.getShapeBounds();
    }

    @Override
    public int getTargetIndex(GEditPoint ep) {
        return this.realLine.getTargetIndex(ep);
    }

    @Override
    public GLinkPositionInfo getTargetLinkPositionInfoAt(int i) {
        return this.realLine.getTargetLinkPositionInfoAt(i);
    }

    @Override
    public void hideLinkAnchors() {
        this.realLine.hideLinkAnchors();
    }

    @Override
    public boolean inShape(double x, double y) {
        return this.realLine.inShape(x, y);
    }

    @Override
    public boolean inShapeAsTarget(double x, double y) {
        return this.realLine.inShapeAsTarget(x, y);
    }

    @Override
    public boolean isMovable() {
        return this.realLine.isMovable();
    }

    @Override
    public void setColor(Color color) {
        this.realLine.setColor(color);
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.realLine.setLineWidth(lineWidth);
    }

    @Override
    public void setOffset(double x, double y) {
        this.realLine.setOffset(x, y);
    }

    @Override
    public void setTargetAt(GLinkTarget target, int index, GLinkPositionInfo lpi) throws Exception {
        this.realLine.setTargetAt(target, index, lpi);
    }

    @Override
    public void setTargetAt(GLinkTarget target, int index, double x, double y, GLinkPositionInfo lpi) throws Exception {
        this.realLine.setTargetAt(target, index, x, y, lpi);
    }

    @Override
    public void setTargetAt(GLinkTarget target, int index, GLinkedLineIndex lineindex) throws Exception {
        this.realLine.setTargetAt(target, index, lineindex);
    }

    @Override
    public void setupAfterAllTargetsSetted() {
        this.realLine.setupAfterAllTargetsSetted();
    }

    @Override
    public void showLinkAnchors(GLinkPositionInfo lpi, boolean drawOnlyActive) {
        this.realLine.showLinkAnchors(lpi, drawOnlyActive);
    }

    @Override
    public Point2D.Double targetPoint() {
        return this.realLine.getStartPoint();
    }

    @Override
    public int targetSize() {
        return this.realLine.targetSize();
    }

    @Override
    public Rectangle2D.Double updateShape() {
        return this.realLine.updateShape();
    }

    @Override
    public Rectangle2D.Double updateShape(boolean moveCreasePoints) {
        return this.realLine.updateShape(moveCreasePoints);
    }

    public Point2D.Double getCoordinatesOfLinkPosition(GLinkPositionInfo lpi) {
        if (this.headerPoint != null) {
            return this.headerPoint.getCoordinatesOfLinkPosition(lpi);
        }
        return null;
    }

    @Override
    public abstract String getCode();

    public abstract int getLogicType();

    public int getModificationType() {
        return this.modificationType;
    }

    public LinkedCreaseLine getRealLine() {
        return this.realLine;
    }

    public void setRealLine(LinkedCreaseLine realLine) {
        this.realLine = realLine;
    }

    public void setModificationType(int modificationType) {
        this.modificationType = modificationType;
        this.initRealLine();
    }

    public void setStartPoint(Point2D.Double point) {
        this.realLine.setStartPoint(point);
        this.headerPoint = new GCreasePoint();
        this.headerPoint.setPosition(point);
        this.headerPoint.setLocalPosition(point);
        this.headerPoint.setOwner(this);
    }

    public GCreasePoint getHeaderPoint() {
        return this.headerPoint;
    }

    public void setHeaderPoint(GCreasePoint headerPoint) {
        this.headerPoint = headerPoint;
        if (headerPoint.getOwner() != this) {
            this.headerPoint.setOwner(this);
        }
    }

    public static boolean isModification(GLinkedShape shape) {
        return shape instanceof LinkedCreaseLineModification || shape instanceof LinkedCreaseLineMixedNotation;
    }

    public static int getModificationType(GLinkedShape shape) {
        if (shape.getClass() == Catalysis.class) {
            return 1;
        }
        if (shape.getClass() == UnknownCatalysis.class) {
            return 2;
        }
        if (shape.getClass() == Inhibition.class) {
            return 3;
        }
        if (shape.getClass() == UnknownInhibition.class) {
            return 4;
        }
        if (shape.getClass() == PhysicalStimulation.class) {
            return 5;
        }
        if (shape.getClass() == Modulation.class) {
            return 6;
        }
        if (shape.getClass() == TranscriptionalInhibition.class) {
            return 3;
        }
        if (shape.getClass() == TranslationalInhibition.class) {
            return 3;
        }
        if (shape.getClass() == TranscriptionalActivation.class) {
            return 1;
        }
        if (shape.getClass() == TranslationalActivation.class) {
            return 1;
        }
        if (shape.getClass() == Trigger.class) {
            return 11;
        }
        if (shape.getClass() == MixedPhysicalStimulation.class) {
            return 14;
        }
        if (shape.getClass() == UnknownPhysicalStimulation.class) {
            return 19;
        }
        if (shape.getClass() == MixedModulation.class) {
            return 15;
        }
        if (shape.getClass() == UnknownModulation.class) {
            return 20;
        }
        if (shape.getClass() == MixedTrigger.class) {
            return 16;
        }
        if (shape.getClass() == UnknownTrigger.class) {
            return 21;
        }
        if (shape.getClass() == NegativeInference.class) {
            return 13;
        }
        if (shape.getClass() == UnknownNegativeInference.class) {
            return 18;
        }
        if (shape.getClass() == PositiveInference.class) {
            return 12;
        }
        if (shape.getClass() == UnknownPositiveInference.class) {
            return 17;
        }
        return 1;
    }

    public static int getModificationTypeByString(String code) {
        if (code.equals("CATALYSIS")) {
            return 1;
        }
        if (code.equals("UNKNOWN_CATALYSIS")) {
            return 2;
        }
        if (code.equals("INHIBITION")) {
            return 3;
        }
        if (code.equals("UNKNOWN_INHIBITION")) {
            return 4;
        }
        if (code.equals("PHYSICAL_STIMULATION")) {
            return 5;
        }
        if (code.equals("MODULATION")) {
            return 6;
        }
        if (code.equals("TRANSCRIPTIONAL_INHIBITION")) {
            return 3;
        }
        if (code.equals("TRANSLATIONAL_INHIBITION")) {
            return 3;
        }
        if (code.equals("TRANSCRIPTIONAL_ACTIVATION")) {
            return 1;
        }
        if (code.equals("TRANSLATIONAL_ACTIVATION")) {
            return 1;
        }
        if (code.equals("TRIGGER")) {
            return 11;
        }
        if (code.equals("REDUCED_PHYSICAL_STIMULATION")) {
            return 14;
        }
        if (code.equals("UNKNOWN_REDUCED_PHYSICAL_STIMULATION")) {
            return 19;
        }
        if (code.equals("REDUCED_MODULATION")) {
            return 15;
        }
        if (code.equals("UNKNOWN_REDUCED_MODULATION")) {
            return 20;
        }
        if (code.equals("REDUCED_TRIGGER")) {
            return 16;
        }
        if (code.equals("UNKNOWN_REDUCED_TRIGGER")) {
            return 21;
        }
        if (code.equals("NEGATIVE_INFLUENCE")) {
            return 13;
        }
        if (code.equals("UNKNOWN_NEGATIVE_INFLUENCE")) {
            return 18;
        }
        if (code.equals("POSITIVE_INFLUENCE")) {
            return 12;
        }
        if (code.equals("UNKNOWN_POSITIVE_INFLUENCE")) {
            return 17;
        }
        return 1;
    }

    public static String getModificationTypeString(int type) {
        switch (type) {
            case 1: {
                return "CATALYSIS";
            }
            case 2: {
                return "UNKNOWN_CATALYSIS";
            }
            case 3: {
                return "INHIBITION";
            }
            case 4: {
                return "UNKNOWN_INHIBITION";
            }
            case 5: {
                return "PHYSICAL_STIMULATION";
            }
            case 6: {
                return "MODULATION";
            }
            case 11: {
                return "TRIGGER";
            }
            case 14: {
                return "REDUCED_PHYSICAL_STIMULATION";
            }
            case 19: {
                return "UNKNOWN_REDUCED_PHYSICAL_STIMULATION";
            }
            case 15: {
                return "REDUCED_MODULATION";
            }
            case 20: {
                return "UNKNOWN_REDUCED_MODULATION";
            }
            case 16: {
                return "REDUCED_TRIGGER";
            }
            case 21: {
                return "UNKNOWN_REDUCED_TRIGGER";
            }
            case 13: {
                return "NEGATIVE_INFLUENCE";
            }
            case 18: {
                return "UNKNOWN_NEGATIVE_INFLUENCE";
            }
            case 12: {
                return "POSITIVE_INFLUENCE";
            }
            case 17: {
                return "UNKNOWN_POSITIVE_INFLUENCE";
            }
        }
        return "CATALYSIS";
    }

    public static Rectangle2D.Double changeLinkBecauseGLogicGate(GLink element, boolean isAdded) {
        LinkedCreaseLine line;
        GLinkedShape shape = element.getGLinkedShape();
        if (shape instanceof GLogicGate) {
            try {
                GLogicGate gate = (GLogicGate)shape;
                Vector v = gate.getChildrenLink();
                int size = v.size();
                int i = 0;
                while (i < size) {
                    GLink link = (GLink)v.elementAt(i);
                    LinkedCreaseLine line2 = (LinkedCreaseLine)link.getGLinkedShape();
                    if (isAdded && line2.getEndTarget() != element) {
                        GLinkPositionInfo gatePointInfo = new GLinkPositionInfo(0, 0.0);
                        gatePointInfo.setElement(element);
                        link.setTargetAt(element, 1, gate.getHeaderPoint().getPosition().x, gate.getHeaderPoint().getPosition().y, gatePointInfo);
                        return (Rectangle2D.Double)link.update();
                    }
                    ++i;
                }
            }
            catch (Exception gate) {}
        } else if (GLogicGate.isModification(shape) && !(line = (LinkedCreaseLine)shape).isSingleLine()) {
            try {
                GLink link = (GLink)line.getEndTarget();
                GLogicGate gate = (GLogicGate)link.getGLinkedShape();
                Vector v = gate.getChildrenLink();
                if (isAdded) {
                    if (!v.contains(element)) {
                        gate.addChildLink(element);
                    }
                } else {
                    if (v.contains(element)) {
                        gate.removeChildLink(element);
                    }
                    if (v.size() == 1) {
                        GLink childLastLink = (GLink)v.elementAt(0);
                        LinkedCreaseLine gateLine = gate.getRealLine();
                        GLinkPositionInfo lnkPosInfoOld = gateLine.getEndLinkPositionInfo();
                        GLinkPositionInfo lnkPosInfo = null;
                        if (lnkPosInfoOld != null) {
                            lnkPosInfo = (GLinkPositionInfo)lnkPosInfoOld.clone();
                        }
                        childLastLink.setTargetAt(gateLine.getEndTarget(), 1, gateLine.getEndPoint().x, gateLine.getEndPoint().y, lnkPosInfo);
                        return (Rectangle2D.Double)childLastLink.update();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static GLink getShouldBeRemovedGate(GLink removingElement) {
        LinkedCreaseLine line;
        GLinkedShape shape = removingElement.getGLinkedShape();
        if (GLogicGate.isModification(shape) && !(line = (LinkedCreaseLine)shape).isSingleLine()) {
            try {
                GLink link = (GLink)line.getEndTarget();
                GLogicGate gate = (GLogicGate)link.getGLinkedShape();
                Vector v = gate.getChildrenLink();
                if (v.size() == 2 && v.contains(removingElement)) {
                    return link;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void changeLinkOrder(Vector structureLinks, GLink element) {
        GLinkedShape shape = element.getGLinkedShape();
        if (!(shape instanceof GLogicGate)) {
            return;
        }
        GLogicGate gate = (GLogicGate)shape;
        Vector childrenLinks = gate.getChildrenLink();
        int size = childrenLinks.size();
        int i = 0;
        while (i < size) {
            if (structureLinks.contains(childrenLinks.elementAt(i)) && structureLinks.contains(element)) {
                int childLinkPos = structureLinks.indexOf(childrenLinks.elementAt(i));
                int gateLinkPos = structureLinks.indexOf(element);
                if (gateLinkPos > childLinkPos) {
                    structureLinks.insertElementAt(element, childLinkPos);
                    structureLinks.removeElementAt(childLinkPos + 1);
                    structureLinks.insertElementAt(childrenLinks.elementAt(i), gateLinkPos);
                    structureLinks.removeElementAt(gateLinkPos + 1);
                }
            }
            ++i;
        }
    }

    public static boolean isModificationType(String code) {
        return code.equals("CATALYSIS") || code.equals("UNKNOWN_CATALYSIS") || code.equals("INHIBITION") || code.equals("UNKNOWN_INHIBITION") || code.equals("PHYSICAL_STIMULATION") || code.equals("MODULATION") || code.equals("TRIGGER") || code.equals("REDUCED_PHYSICAL_STIMULATION") || code.equals("UNKNOWN_REDUCED_PHYSICAL_STIMULATION") || code.equals("REDUCED_MODULATION") || code.equals("UNKNOWN_REDUCED_MODULATION") || code.equals("REDUCED_TRIGGER") || code.equals("UNKNOWN_REDUCED_TRIGGER") || code.equals("NEGATIVE_INFLUENCE") || code.equals("UNKNOWN_NEGATIVE_INFLUENCE") || code.equals("POSITIVE_INFLUENCE") || code.equals("UNKNOWN_POSITIVE_INFLUENCE");
    }

    public static boolean isGLogicGateType(String code) {
        return code != null && (code.equals("BOOLEAN_LOGIC_GATE_NOT") || code.equals("BOOLEAN_LOGIC_GATE_UNKNOWN") || code.equals("BOOLEAN_LOGIC_GATE_OR") || code.equals("BOOLEAN_LOGIC_GATE_AND"));
    }

    private void initRealLine() {
        switch (this.modificationType) {
            case 1: {
                this.realLine = new Catalysis();
                break;
            }
            case 2: {
                this.realLine = new UnknownCatalysis();
                break;
            }
            case 3: {
                this.realLine = new Inhibition();
                break;
            }
            case 4: {
                this.realLine = new UnknownInhibition();
                break;
            }
            case 5: {
                this.realLine = new PhysicalStimulation();
                break;
            }
            case 6: {
                this.realLine = new Modulation();
                break;
            }
            case 11: {
                this.realLine = new Trigger();
                break;
            }
            case 14: {
                this.realLine = new MixedPhysicalStimulation();
                break;
            }
            case 19: {
                this.realLine = new UnknownPhysicalStimulation();
                break;
            }
            case 15: {
                this.realLine = new MixedModulation();
                break;
            }
            case 20: {
                this.realLine = new UnknownModulation();
                break;
            }
            case 16: {
                this.realLine = new MixedTrigger();
                break;
            }
            case 21: {
                this.realLine = new UnknownTrigger();
                break;
            }
            case 13: {
                this.realLine = new NegativeInference();
                break;
            }
            case 18: {
                this.realLine = new UnknownNegativeInference();
                break;
            }
            case 12: {
                this.realLine = new PositiveInference();
                break;
            }
            case 17: {
                this.realLine = new UnknownPositiveInference();
            }
        }
        int policy = GLinkedLine.getDefaultConnectPolicy();
        this.realLine.setConnectPolicy(policy);
        int n = GLinkedLine.getDefaultCreasePointNumber() + 1;
        this.realLine.resetCreaseLineNumber(n);
        this.realLine.setLogicGateFlg(true);
        this.realLine.setLogicGate(this);
        this.setStartPoint(null);
    }

    public Vector getChildrenLink() {
        return this.childrenLink;
    }

    public void addChildLink(GLink link) {
        this.childrenLink.add(link);
    }

    public void addChildrenLink(Vector links) {
        int size = links.size();
        int i = 0;
        while (i < size) {
            GLink link = (GLink)links.elementAt(i);
            this.addChildLink(link);
            ++i;
        }
    }

    public void removeChildLink(GLink link) {
        this.childrenLink.remove(link);
    }

    public void removeChildrenLink() {
        this.childrenLink.clear();
    }

    @Override
    public void activateEditPoints(boolean val) {
        this.realLine.activateEditPoints(val);
        this.headerPoint.setActive(val);
    }

    @Override
    public void appendAdditionalMovingPointAndPosition(GEditPoint point, Vector startXYVec) {
        this.realLine.appendAdditionalMovingPointAndPosition(point, startXYVec);
    }

    @Override
    public void appendMovingPointAndPosition(GEditPoint ep1, Vector startXYVec) {
        this.realLine.appendMovingPointAndPosition(ep1, startXYVec);
    }

    @Override
    public boolean contains(GEditPoint editpoint) {
        if (this.realLine.contains(editpoint)) {
            return true;
        }
        return this.headerPoint == editpoint;
    }

    @Override
    public GEditPoint getEditPoint(double x, double y) {
        if (this.headerPoint.inShape(x, y)) {
            return this.headerPoint;
        }
        GEditPoint pt = this.realLine.getEditPoint(x, y);
        if (pt == null) {
            return pt;
        }
        pt.setOwner(this);
        if (pt == this.realLine.getStartHandlePoint()) {
            return this.headerPoint;
        }
        return pt;
    }

    @Override
    public GEditPoint[] getEditPoints() {
        GEditPoint[] temp = this.realLine.getEditPoints();
        GEditPoint[] geditpoints = new GEditPoint[temp.length + 1];
        int i = 0;
        while (i < temp.length) {
            geditpoints[i] = temp[i];
            ++i;
        }
        geditpoints[temp.length] = this.headerPoint;
        return geditpoints;
    }

    @Override
    public Rectangle2D.Double moveEditPoint(GEditPoint editpoint, double x, double y) {
        if (this.realLine.contains(editpoint)) {
            return this.realLine.moveEditPoint(editpoint, x, y);
        }
        if (this.headerPoint == editpoint) {
            Point2D.Double pos1 = new Point2D.Double(x, y);
            this.headerPoint.setLocalPosition(pos1);
            this.headerPoint.setPosition(pos1);
            GStructure structure = MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure();
            return this.updateShape(structure.getMovingElement() != this.headerPoint);
        }
        return null;
    }

    @Override
    public void restrictEditPointMoveVector(GEditPoint ep1, GEditPoint ep2, Point2D.Double dxdy) {
        this.realLine.restrictEditPointMoveVector(ep1, ep2, dxdy);
    }

    @Override
    public Vector setMovedElementPosition(double dx, double dy, Vector startXYVec) {
        return this.realLine.setMovedElementPosition(dx, dy, startXYVec);
    }

    @Override
    public GLinkedLineIndex getDefaultLineIndex() {
        return this.realLine.getDefaultLineIndex();
    }

    @Override
    public GLinkedLine getLine(GLinkedLineIndex lineindex) {
        return this.realLine.getLine(lineindex);
    }

    @Override
    public GLinkedLineIndex getLineIndex(double x, double y) {
        return this.realLine.getLineIndex(x, y);
    }

    @Override
    public boolean canTogglePolicy(GStructure structure) {
        return this.realLine.canTogglePolicy(structure);
    }

    @Override
    public int getConnectPolicy() {
        return this.realLine.getConnectPolicy();
    }

    @Override
    public GLink getReactionLink(GStructure structure) {
        Vector links = structure.getLinks();
        for (GLink rl : links) {
            GLinkedShape link1 = rl.getGLinkedShape();
            if (!(link1 instanceof GLogicGate) || link1 != this) continue;
            return rl;
        }
        return null;
    }

    @Override
    public void initLinesDirection() {
        this.realLine.initLinesDirection();
    }

    @Override
    public void reformSquareLines(GStructure structure) {
        this.realLine.reformSquareLines(structure);
    }

    @Override
    public void setConnectPolicy(int policy) {
        this.realLine.setConnectPolicy(policy);
    }

    @Override
    public void setlinesDirection(Vector vec) {
        this.realLine.setlinesDirection(vec);
    }

    @Override
    public void toggleConnectPolicy(GStructure structure) {
        this.realLine.toggleConnectPolicy(structure);
    }

    public GLinkedLine[] getLines() {
        return this.realLine.getLines();
    }

    public Vector getTargetElement() {
        Vector<GLinkTarget> v = new Vector<GLinkTarget>();
        int size = this.getChildrenLink().size();
        int i = 0;
        while (i < size) {
            GLink link = (GLink)this.getChildrenLink().elementAt(i);
            GLinkTarget target = ((LinkedCreaseLine)link.getGLinkedShape()).getStartTarget();
            v.addElement(target);
            ++i;
        }
        return v;
    }

    public void addSpecies(GElement gl) {
        this.relationSpecies.add(gl);
    }

    public void removeSpecies(GElement gl) {
        this.relationSpecies.remove(gl);
    }

    public boolean containSpecies(GElement gl) {
        return this.relationSpecies.contains(gl);
    }

    @Override
    public int getLineType() {
        return 1;
    }

    @Override
    public void setLineType(int type) {
    }

    @Override
    public void setIsInSBGNViewer(boolean flag) {
        this.isInSBGNViewer = flag;
    }

    @Override
    public boolean isInSBGNViewer() {
        return this.isInSBGNViewer;
    }

    public static final boolean isLogicGateInSBGNViewer(LinkedCreaseLine parentLine) {
        return parentLine != null && parentLine.isLogicGate() && parentLine.getLogicGate() != null && parentLine.getLogicGate().isInSBGNViewer();
    }

    public static final String getLogicGateTypeInSBGNViewer(int gatetype) {
        String s = "";
        switch (gatetype) {
            case 1: {
                return "AND";
            }
            case 2: {
                return "OR";
            }
            case 4: {
                return "NOT";
            }
            case 3: {
                return "?";
            }
        }
        return s;
    }

    public String getModificationTypeString() {
        return GLogicGate.getModificationTypeString(this.modificationType);
    }

    public static final int getDefaultMixedNotationType() {
        return 16;
    }

    public static final boolean isMixedNotationModificationType(String code) {
        if (code == null) {
            return false;
        }
        return code.equals("REDUCED_PHYSICAL_STIMULATION") || code.equals("UNKNOWN_REDUCED_PHYSICAL_STIMULATION") || code.equals("REDUCED_MODULATION") || code.equals("UNKNOWN_REDUCED_MODULATION") || code.equals("REDUCED_TRIGGER") || code.equals("UNKNOWN_REDUCED_TRIGGER") || code.equals("NEGATIVE_INFLUENCE") || code.equals("UNKNOWN_NEGATIVE_INFLUENCE") || code.equals("POSITIVE_INFLUENCE") || code.equals("UNKNOWN_POSITIVE_INFLUENCE");
    }
}

