/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GUtil;

class GLinkedLineOmittedShape
implements GLinkedLineModificationShape {
    Line2D line1 = new Line2D.Double();
    Line2D line2 = new Line2D.Double();
    Point2D.Double p1 = new Point2D.Double(0.0, -8.0);
    Point2D.Double p2 = new Point2D.Double(4.0, 8.0);
    Point2D.Double p3 = new Point2D.Double(-4.0, -8.0);
    Point2D.Double p4 = new Point2D.Double(0.0, 8.0);
    Point2D.Double sp1 = new Point2D.Double();
    Point2D.Double sp2 = new Point2D.Double();
    Point2D.Double sp3 = new Point2D.Double();
    Point2D.Double sp4 = new Point2D.Double();
    Rectangle2D.Double polygonBounds = null;
    private boolean isVisible = true;
    private int index = 0;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int indx) {
        this.index = indx;
    }

    @Override
    public Rectangle2D.Double updateModification(Point2D.Double start, Point2D.Double end, double lineWidth) {
        Rectangle2D.Double prev = this.polygonBounds;
        if (start == null || end == null) {
            return null;
        }
        double cx = (start.x + end.x) / 2.0;
        double cy = (start.y + end.y) / 2.0;
        AffineTransform at = new AffineTransform();
        at.translate(cx, cy);
        GUtil.addRotateAT(at, start, end);
        double size = lineWidth / 2.0 + 8.0;
        this.p1.y = -size;
        this.p2.y = size;
        this.p3.x = -(lineWidth + 5.0);
        this.p3.y = -size;
        this.p4.x = this.p3.x + 4.0;
        this.p4.y = size;
        at.transform(this.p1, this.sp1);
        at.transform(this.p2, this.sp2);
        at.transform(this.p3, this.sp3);
        at.transform(this.p4, this.sp4);
        this.line1.setLine(this.sp1, this.sp2);
        this.line2.setLine(this.sp3, this.sp4);
        Polygon polygon = new Polygon();
        polygon.addPoint((int)this.sp1.x, (int)this.sp1.y);
        polygon.addPoint((int)this.sp2.x, (int)this.sp2.y);
        polygon.addPoint((int)this.sp3.x, (int)this.sp3.y);
        polygon.addPoint((int)this.sp4.x, (int)this.sp4.y);
        double extend = Math.ceil(Math.sqrt(10.0) * 0.5 * lineWidth);
        Rectangle2D r2 = polygon.getBounds2D();
        this.polygonBounds = new Rectangle2D.Double(r2.getX() - extend, r2.getY() - extend, r2.getWidth() + 2.0 * extend, r2.getHeight() + 2.0 * extend);
        if (prev == null) {
            return this.polygonBounds;
        }
        if (prev.equals(this.polygonBounds)) {
            return null;
        }
        return GUtil.union(prev, this.polygonBounds);
    }

    @Override
    public Rectangle2D.Double getModificationBounds() {
        return this.polygonBounds;
    }

    @Override
    public void drawModification(Graphics2D g2) {
        if (this.polygonBounds != null) {
            BasicStroke org_stroke = new BasicStroke();
            org_stroke = (BasicStroke)g2.getStroke();
            BasicStroke tmp_stroke = new BasicStroke(org_stroke.getLineWidth(), 0, org_stroke.getLineJoin(), org_stroke.getMiterLimit(), org_stroke.getDashArray(), org_stroke.getDashPhase());
            g2.setStroke(tmp_stroke);
            g2.draw(this.line1);
            g2.draw(this.line2);
            g2.setStroke(org_stroke);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Override
    public GLinkedLineModificationShape createCopy() {
        GLinkedLineOmittedShape shape = new GLinkedLineOmittedShape();
        shape.setVisible(this.isVisible);
        shape.setIndex(this.index);
        return shape;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public Line2D.Double modifyLine(Line2D.Double modifiedLine) {
        return modifiedLine;
    }
}

