/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.MarkInendofModificationLine;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.TranscriptionalInhibition;
import jp.sbi.celldesigner.symbol.reaction.TranslationalInhibition;

class GLinkedLineInhibitionShape
implements GLinkedLineModificationShape {
    Line2D line = new Line2D.Double();
    Point2D.Double p1 = new Point2D.Double(-6.0, 0.0);
    Point2D.Double p2 = new Point2D.Double(-5.0, 5.0);
    Point2D.Double p3 = new Point2D.Double(-5.0, -5.0);
    Point2D.Double sp1 = new Point2D.Double();
    Point2D.Double sp2 = new Point2D.Double();
    Point2D.Double sp3 = new Point2D.Double();
    Rectangle2D.Double polygonBounds = null;
    double lineLineWidth = 1.0;
    private boolean isVisible = true;
    private boolean isReversed = false;
    private Point2D modifiedPoint;
    private LinkedCreaseLine parent = null;
    private Ellipse2D ellipseGate = new Ellipse2D.Double();
    private Rectangle2D.Double ellipse2Bounds = null;
    private Point2D gatePoint;
    private int index = 0;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int indx) {
        this.index = indx;
    }

    public void setParent(LinkedCreaseLine parent) {
        this.parent = parent;
    }

    private String getLogicGateType() {
        String s = "";
        if (!this.isDrawGate()) {
            return s;
        }
        int type = this.parent.getLogicGate().getLogicType();
        switch (type) {
            case 1: {
                return "&";
            }
            case 2: {
                return "|";
            }
            case 4: {
                return "!";
            }
            case 3: {
                return "?";
            }
        }
        return s;
    }

    private boolean isDrawGate() {
        if (!this.parent.isLogicGate()) {
            return false;
        }
        if (this.parent.getLogicGate() == null) {
            return false;
        }
        int type = this.parent.getLogicGate().getLogicType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private void drawGate(Graphics2D g2) {
        if (!this.isDrawGate()) {
            return;
        }
        if (this.ellipseGate != null && this.isVisible) {
            Color bu = g2.getColor();
            BasicStroke org_stroke = (BasicStroke)g2.getStroke();
            Font oldFont = g2.getFont();
            BasicStroke stroke = new BasicStroke((float)this.lineLineWidth);
            g2.setStroke(stroke);
            g2.setColor(Color.WHITE);
            g2.fill(this.ellipseGate);
            g2.setColor(bu);
            g2.draw(this.ellipseGate);
            String family = g2.getFont().getFamily();
            Font font = new Font(family, 0, 11);
            g2.setFont(font);
            String s = this.getLogicGateType();
            if (GLogicGate.isLogicGateInSBGNViewer(this.parent)) {
                s = GLogicGate.getLogicGateTypeInSBGNViewer(this.parent.getLogicGate().getLogicType());
            }
            double h = g2.getFontMetrics().getAscent();
            double h2 = g2.getFontMetrics().getDescent();
            h -= h2;
            double w = 0.0;
            int i = 0;
            while (i < s.toCharArray().length) {
                w += (double)g2.getFontMetrics().charWidth(s.toCharArray()[i]);
                ++i;
            }
            double x = this.gatePoint.getX() - w / 2.0;
            double y = this.gatePoint.getY() + h / 2.0;
            g2.drawString(s, (int)x, (int)y);
            g2.setFont(oldFont);
            g2.setStroke(org_stroke);
        }
    }

    private Rectangle2D.Double updateGate(Point2D.Double start, Point2D.Double end, double lineWidth) {
        if (!this.isDrawGate()) {
            this.ellipse2Bounds = null;
            return null;
        }
        Rectangle2D.Double prev = this.ellipse2Bounds;
        double size = lineWidth + 11.0;
        if (GLogicGate.isLogicGateInSBGNViewer(this.parent)) {
            size = lineWidth + 24.0;
        }
        GLogicGate gate = this.parent.getLogicGate();
        Point2D.Double headerPoint = null;
        headerPoint = gate.getHeaderPoint().getPosition() != null ? new Point2D.Double(gate.getHeaderPoint().getPosition().x, gate.getHeaderPoint().getPosition().y) : start;
        this.ellipseGate.setFrame(headerPoint.x - size / 2.0, headerPoint.y - size / 2.0, size, size);
        this.gatePoint = headerPoint;
        double extend = Math.ceil(0.5 * lineWidth);
        Rectangle2D r2 = this.ellipseGate.getBounds2D();
        this.ellipse2Bounds = new Rectangle2D.Double(r2.getX() - extend, r2.getY() - extend, r2.getWidth() + 2.0 * extend, r2.getHeight() + 2.0 * extend);
        if (prev == null) {
            return this.ellipse2Bounds;
        }
        if (prev.equals(this.ellipse2Bounds)) {
            return null;
        }
        return GUtil.union(prev, this.ellipse2Bounds);
    }

    public GLinkedLineInhibitionShape(LinkedCreaseLine parent) {
        this.parent = parent;
    }

    public void setReversed(boolean isReversed) {
        this.isReversed = isReversed;
    }

    @Override
    public Rectangle2D.Double updateModification(Point2D.Double start, Point2D.Double end, double lineWidth) {
        Point2D.Double ep;
        Point2D.Double sp;
        Rectangle2D.Double gateBounds = null;
        if (this.isDrawGate()) {
            gateBounds = this.updateGate(start, end, lineWidth);
        }
        if (!this.parent.isSingleLine()) {
            return gateBounds;
        }
        Rectangle2D.Double prev = this.polygonBounds;
        if (start == null || end == null) {
            return null;
        }
        Point2D.Double modifyPoint = null;
        double margin = 3.0;
        modifyPoint = MarkInendofModificationLine.calcNewTargetPoint(this.parent, margin);
        if (!this.isReversed) {
            sp = start;
            ep = modifyPoint != null ? modifyPoint : end;
        } else {
            sp = modifyPoint != null ? modifyPoint : end;
            ep = start;
        }
        AffineTransform at = new AffineTransform();
        at.translate(ep.x, ep.y);
        GUtil.addRotateAT(at, sp, ep);
        double offset = margin + lineWidth / 2.0;
        this.p1.x = -offset;
        this.p2.x = this.p3.x = this.p1.x + 1.0;
        if (this.parent instanceof TranscriptionalInhibition || this.parent instanceof TranslationalInhibition) {
            this.p1.x = -6.0;
            this.p3.x = -5.0;
            this.p2.x = -5.0;
        }
        this.p2.y = lineWidth + 4.0;
        this.p3.y = -this.p2.y;
        at.transform(this.p1, this.sp1);
        at.transform(this.p2, this.sp2);
        at.transform(this.p3, this.sp3);
        this.lineLineWidth = lineWidth;
        Point2D.Double p4 = new Point2D.Double(lineWidth, 0.0);
        Point2D.Double sp4 = new Point2D.Double();
        at.transform(p4, sp4);
        this.line.setLine(this.sp2, this.sp3);
        this.modifiedPoint = this.sp1;
        Polygon polygon = new Polygon();
        polygon.addPoint((int)this.sp1.x, (int)this.sp1.y);
        polygon.addPoint((int)this.sp2.x, (int)this.sp2.y);
        polygon.addPoint((int)this.sp3.x, (int)this.sp3.y);
        double extend = Math.ceil(Math.sqrt(10.0) * 0.5 * lineWidth);
        Rectangle2D r2 = polygon.getBounds2D();
        this.polygonBounds = new Rectangle2D.Double(r2.getX() - extend, r2.getY() - extend, r2.getWidth() + 2.0 * extend, r2.getHeight() + 2.0 * extend);
        if (prev == null) {
            return GUtil.union(this.polygonBounds, gateBounds);
        }
        if (prev.equals(this.polygonBounds)) {
            return gateBounds;
        }
        return GUtil.union(GUtil.union(prev, this.polygonBounds), gateBounds);
    }

    @Override
    public Rectangle2D.Double getModificationBounds() {
        Rectangle2D.Double gateBounds = null;
        Rectangle2D.Double modificationBounds = null;
        if (this.isDrawGate()) {
            gateBounds = this.ellipse2Bounds;
        }
        if (this.parent.isSingleLine()) {
            modificationBounds = this.polygonBounds;
        }
        return GUtil.union(gateBounds, modificationBounds);
    }

    @Override
    public void drawModification(Graphics2D g2) {
        this.drawGate(g2);
        if (!this.parent.isSingleLine()) {
            return;
        }
        if (this.polygonBounds != null && this.isVisible) {
            Color bu = g2.getColor();
            BasicStroke org_stroke = (BasicStroke)g2.getStroke();
            BasicStroke stroke = new BasicStroke((float)this.lineLineWidth, 0, 2);
            if (this.parent instanceof TranscriptionalInhibition || this.parent instanceof TranslationalInhibition) {
                stroke = new BasicStroke(1.0f, 0, 2);
            }
            g2.setStroke(stroke);
            g2.setColor(Color.white);
            g2.setColor(bu);
            g2.draw(this.line);
            g2.setStroke(org_stroke);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Override
    public GLinkedLineModificationShape createCopy() {
        GLinkedLineInhibitionShape shape = new GLinkedLineInhibitionShape(null);
        shape.setReversed(this.isReversed);
        shape.setVisible(this.isVisible);
        shape.setIndex(this.index);
        return shape;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public Line2D.Double modifyLine(Line2D.Double line2) {
        return MarkInendofModificationLine.modifyLinkedtoLogicGateSubLineAgain(line2, this.parent, this.isReversed, this.modifiedPoint);
    }
}

