/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.MarkInendofModificationLine;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;

class GLinkedLineCatalysisShape
implements GLinkedLineModificationShape {
    Ellipse2D ellipse = new Ellipse2D.Double();
    Point2D.Double p1 = new Point2D.Double(-5.0, 0.0);
    Point2D.Double sp1 = new Point2D.Double();
    Rectangle2D.Double ellipseBounds = null;
    double ellipseLineWidth = 1.0;
    private boolean isVisible = true;
    private boolean isReversed = false;
    private Point2D modifiedPoint;
    private LinkedCreaseLine parent = null;
    private Ellipse2D ellipseGate = new Ellipse2D.Double();
    private Rectangle2D.Double ellipse2Bounds = null;
    private Point2D gatePoint;
    private int index = 0;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int indx) {
        this.index = indx;
    }

    public void setParent(LinkedCreaseLine parent) {
        this.parent = parent;
    }

    private String getLogicGateType() {
        String s = "";
        if (!this.isDrawGate()) {
            return s;
        }
        int type = this.parent.getLogicGate().getLogicType();
        switch (type) {
            case 1: {
                return "&";
            }
            case 2: {
                return "|";
            }
            case 4: {
                return "!";
            }
            case 3: {
                return "?";
            }
        }
        return s;
    }

    private boolean isDrawGate() {
        if (!this.parent.isLogicGate()) {
            return false;
        }
        if (this.parent.getLogicGate() == null) {
            return false;
        }
        int type = this.parent.getLogicGate().getLogicType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private void drawGate(Graphics2D g2) {
        if (!this.isDrawGate()) {
            return;
        }
        if (this.ellipseGate != null && this.isVisible) {
            Color bu = g2.getColor();
            BasicStroke org_stroke = (BasicStroke)g2.getStroke();
            Font oldFont = g2.getFont();
            BasicStroke stroke = new BasicStroke((float)this.ellipseLineWidth);
            g2.setStroke(stroke);
            g2.setColor(Color.WHITE);
            g2.fill(this.ellipseGate);
            g2.setColor(bu);
            g2.draw(this.ellipseGate);
            String family = g2.getFont().getFamily();
            Font font = new Font(family, 0, 11);
            g2.setFont(font);
            String s = this.getLogicGateType();
            if (GLogicGate.isLogicGateInSBGNViewer(this.parent)) {
                s = GLogicGate.getLogicGateTypeInSBGNViewer(this.parent.getLogicGate().getLogicType());
            }
            double h = g2.getFontMetrics().getAscent();
            double h2 = g2.getFontMetrics().getDescent();
            h -= h2;
            double w = 0.0;
            int i = 0;
            while (i < s.toCharArray().length) {
                w += (double)g2.getFontMetrics().charWidth(s.toCharArray()[i]);
                ++i;
            }
            double x = this.gatePoint.getX() - w / 2.0;
            double y = this.gatePoint.getY() + h / 2.0;
            g2.drawString(s, (int)x, (int)y);
            g2.setFont(oldFont);
            g2.setStroke(org_stroke);
        }
    }

    private Rectangle2D.Double updateGate(Point2D.Double start, Point2D.Double end, double lineWidth) {
        if (!this.isDrawGate()) {
            this.ellipse2Bounds = null;
            return null;
        }
        Rectangle2D.Double prev = this.ellipse2Bounds;
        double size = lineWidth + 11.0;
        if (GLogicGate.isLogicGateInSBGNViewer(this.parent)) {
            size = lineWidth + 24.0;
        }
        GLogicGate gate = this.parent.getLogicGate();
        Point2D.Double headerPoint = null;
        headerPoint = gate.getHeaderPoint().getPosition() != null ? new Point2D.Double(gate.getHeaderPoint().getPosition().x, gate.getHeaderPoint().getPosition().y) : start;
        this.ellipseGate.setFrame(headerPoint.x - size / 2.0, headerPoint.y - size / 2.0, size, size);
        this.gatePoint = headerPoint;
        double extend = Math.ceil(0.5 * lineWidth);
        Rectangle2D r2 = this.ellipseGate.getBounds2D();
        this.ellipse2Bounds = new Rectangle2D.Double(r2.getX() - extend, r2.getY() - extend, r2.getWidth() + 2.0 * extend, r2.getHeight() + 2.0 * extend);
        if (prev == null) {
            return this.ellipse2Bounds;
        }
        if (prev.equals(this.ellipse2Bounds)) {
            return null;
        }
        return GUtil.union(prev, this.ellipse2Bounds);
    }

    public GLinkedLineCatalysisShape(LinkedCreaseLine parent) {
        this.parent = parent;
    }

    public void setReversed(boolean isReversed) {
        this.isReversed = isReversed;
    }

    @Override
    public Rectangle2D.Double updateModification(Point2D.Double start, Point2D.Double end, double lineWidth) {
        Point2D.Double ep;
        Point2D.Double sp;
        Rectangle2D.Double gateBounds = null;
        if (this.isDrawGate()) {
            gateBounds = this.updateGate(start, end, lineWidth);
        }
        if (!this.parent.isSingleLine()) {
            return gateBounds;
        }
        Rectangle2D.Double prev = this.ellipseBounds;
        if (start == null || end == null) {
            return null;
        }
        Point2D.Double modifyPoint = null;
        double offset = 1.0 + lineWidth + 2.5;
        modifyPoint = MarkInendofModificationLine.calcNewTargetPoint(this.parent, offset);
        if (!this.isReversed) {
            sp = start;
            ep = modifyPoint != null ? modifyPoint : end;
        } else {
            sp = modifyPoint != null ? modifyPoint : end;
            ep = start;
        }
        AffineTransform at = new AffineTransform();
        at.translate(ep.x, ep.y);
        GUtil.addRotateAT(at, sp, ep);
        this.p1.x = -offset;
        at.transform(this.p1, this.sp1);
        if (modifyPoint != null) {
            this.sp1 = modifyPoint;
        }
        double size = lineWidth + 5.0;
        this.ellipse.setFrame(this.sp1.x - size / 2.0, this.sp1.y - size / 2.0, size, size);
        this.ellipseLineWidth = lineWidth;
        this.modifiedPoint = this.sp1;
        double extend = Math.ceil(0.5 * lineWidth);
        Rectangle2D r2 = this.ellipse.getBounds2D();
        this.ellipseBounds = new Rectangle2D.Double(r2.getX() - extend, r2.getY() - extend, r2.getWidth() + 2.0 * extend, r2.getHeight() + 2.0 * extend);
        if (prev == null) {
            return GUtil.union(this.ellipseBounds, gateBounds);
        }
        if (prev.equals(this.ellipseBounds)) {
            return gateBounds;
        }
        return GUtil.union(GUtil.union(prev, this.ellipseBounds), gateBounds);
    }

    @Override
    public Rectangle2D.Double getModificationBounds() {
        Rectangle2D.Double gateBounds = null;
        Rectangle2D.Double modificationBounds = null;
        if (this.isDrawGate()) {
            gateBounds = this.ellipse2Bounds;
        }
        if (this.parent.isSingleLine()) {
            modificationBounds = this.ellipseBounds;
        }
        return GUtil.union(gateBounds, modificationBounds);
    }

    @Override
    public void drawModification(Graphics2D g2) {
        this.drawGate(g2);
        if (!this.parent.isSingleLine()) {
            return;
        }
        if (this.ellipse != null && this.isVisible) {
            Color bu = g2.getColor();
            BasicStroke org_stroke = (BasicStroke)g2.getStroke();
            BasicStroke stroke = new BasicStroke((float)this.ellipseLineWidth);
            g2.setStroke(stroke);
            g2.setColor(Color.white);
            g2.fill(this.ellipse);
            g2.setColor(bu);
            g2.draw(this.ellipse);
            g2.setStroke(org_stroke);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Override
    public GLinkedLineModificationShape createCopy() {
        GLinkedLineCatalysisShape shape = new GLinkedLineCatalysisShape(null);
        shape.setReversed(this.isReversed);
        shape.setVisible(this.isVisible);
        shape.setIndex(this.index);
        return shape;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public Line2D.Double modifyLine(Line2D.Double line) {
        return MarkInendofModificationLine.modifyLinkedtoLogicGateSubLineAgain(line, this.parent, this.isReversed, this.modifiedPoint);
    }
}

