/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.MarkInendofModificationLine;
import jp.sbi.celldesigner.LinkedCreaseLine;

class GLinkedLineActivationShape
extends MarkInendofModificationLine {
    private final double distanceDefault = 16.0;
    private final double distanceMax = 40.0;
    private final double distanceMin = 8.0;
    private final double linewidthDefault = 4.0;
    private final double rateOfMark = 0.75;
    private final double margin = 3.0;
    private GeneralPath markarea = new GeneralPath();
    private GeneralPath markInnerArea = new GeneralPath();
    private Point2D.Double p91 = new Point2D.Double();
    private Point2D.Double p92 = new Point2D.Double();
    private Point2D.Double p93 = new Point2D.Double();
    private Point2D.Double p94 = new Point2D.Double();
    private Point2D.Double p900 = new Point2D.Double();
    private Point2D.Double p910 = new Point2D.Double();
    private Point2D.Double p901 = new Point2D.Double();
    private Point2D.Double p911 = new Point2D.Double();
    private Point2D.Double p902 = new Point2D.Double();
    private Point2D.Double p912 = new Point2D.Double();
    private Point2D.Double p903 = new Point2D.Double();
    private Point2D.Double p913 = new Point2D.Double();
    private Point2D.Double p904 = new Point2D.Double();
    private Point2D.Double p914 = new Point2D.Double();
    private Point2D.Double p909 = new Point2D.Double();

    public GLinkedLineActivationShape() {
    }

    public GLinkedLineActivationShape(LinkedCreaseLine p) {
        super(p);
    }

    @Override
    public MarkInendofModificationLine createMyNewCopy() {
        return new GLinkedLineActivationShape();
    }

    @Override
    public Rectangle2D.Double updateModification(Point2D.Double start, Point2D.Double end, double lineWidth) {
        Point2D.Double ep;
        Point2D.Double sp;
        double sharptopPointX;
        this.lineLineWidth = lineWidth;
        if (start == null || end == null) {
            return null;
        }
        Rectangle2D.Double prev = this.polygonBounds;
        Rectangle2D.Double gateBounds = null;
        if (this.isDrawGate()) {
            gateBounds = this.updateGate(start, end, lineWidth);
        }
        if (this.parent.isMemberofBooleanLogicGate()) {
            return gateBounds;
        }
        double k = 4.0;
        double distance = this.lineLineWidth * k;
        if (distance > 40.0) {
            distance = 40.0;
        } else if (distance < 8.0) {
            distance = 8.0;
        }
        double sharptopPointY = sharptopPointX = 3.0 + this.lineLineWidth / 2.0;
        Point2D.Double p01 = new Point2D.Double(sharptopPointX, sharptopPointY);
        Point2D.Double p02 = new Point2D.Double();
        p02.x = p01.x + distance;
        p02.y = p01.y;
        Point2D.Double p03 = new Point2D.Double();
        p03.x = p01.x;
        p03.y = p01.y + distance;
        double shrink = distance / k;
        Point2D.Double p04 = new Point2D.Double(p01.x + shrink, p01.y + shrink);
        double marklineWidth = 1.0;
        double halfMarklineWidth = lineWidth / 2.0;
        marklineWidth = lineWidth >= 2.2 ? 1.0 : 0.5;
        Point2D.Double p000 = new Point2D.Double(-3.0, 0.0);
        Point2D.Double p010 = new Point2D.Double(p000.x - marklineWidth, p000.y);
        Point2D.Double p009 = new Point2D.Double(p010.x - lineWidth, p000.y);
        Point2D.Double p001 = new Point2D.Double(p000.x - Math.abs(p009.x - p000.x) * 0.75, halfMarklineWidth);
        Point2D.Double p011 = new Point2D.Double(p001.x, p001.y - marklineWidth);
        Point2D.Double p002 = new Point2D.Double(p009.x, p001.y);
        Point2D.Double p012 = new Point2D.Double(p002.x, p011.y);
        Point2D.Double p003 = new Point2D.Double(p001.x, -p001.y);
        Point2D.Double p013 = new Point2D.Double(p011.x, -p011.y);
        Point2D.Double p004 = new Point2D.Double(p002.x, -p002.y);
        Point2D.Double p014 = new Point2D.Double(p012.x, -p012.y);
        AffineTransform at01 = new AffineTransform();
        at01.rotate(-0.7853981633974483);
        at01.rotate(Math.PI);
        Point2D.Double p11 = new Point2D.Double();
        Point2D.Double p12 = new Point2D.Double();
        Point2D.Double p13 = new Point2D.Double();
        Point2D.Double p14 = new Point2D.Double();
        at01.transform(p01, p11);
        at01.transform(p02, p12);
        at01.transform(p03, p13);
        at01.transform(p04, p14);
        if (!this.isReversed) {
            sp = start;
            ep = end;
        } else {
            sp = end;
            ep = start;
        }
        AffineTransform at02 = new AffineTransform();
        at02.translate(ep.x, ep.y);
        GUtil.addRotateAT(at02, sp, ep);
        at02.transform(p11, this.p91);
        at02.transform(p12, this.p92);
        at02.transform(p13, this.p93);
        at02.transform(p000, this.p900);
        at02.transform(p010, this.p910);
        at02.transform(p001, this.p901);
        at02.transform(p011, this.p911);
        at02.transform(p002, this.p902);
        at02.transform(p012, this.p912);
        at02.transform(p003, this.p903);
        at02.transform(p013, this.p913);
        at02.transform(p004, this.p904);
        at02.transform(p014, this.p914);
        at02.transform(p009, this.p909);
        this.markarea.reset();
        this.markarea.moveTo((float)this.p902.x, (float)this.p902.y);
        this.markarea.lineTo((float)this.p901.x, (float)this.p901.y);
        this.markarea.lineTo((float)this.p900.x, (float)this.p900.y);
        this.markarea.lineTo((float)this.p903.x, (float)this.p903.y);
        this.markarea.lineTo((float)this.p904.x, (float)this.p904.y);
        this.markarea.lineTo((float)this.p914.x, (float)this.p914.y);
        this.markarea.lineTo((float)this.p913.x, (float)this.p913.y);
        this.markarea.lineTo((float)this.p910.x, (float)this.p910.y);
        this.markarea.lineTo((float)this.p911.x, (float)this.p911.y);
        this.markarea.lineTo((float)this.p912.x, (float)this.p912.y);
        this.markarea.lineTo((float)this.p902.x, (float)this.p902.y);
        this.markInnerArea.reset();
        this.markInnerArea.moveTo((float)this.p902.x, (float)this.p902.y);
        this.markInnerArea.lineTo((float)this.p901.x, (float)this.p901.y);
        this.markInnerArea.lineTo((float)this.p900.x, (float)this.p900.y);
        this.markInnerArea.lineTo((float)this.p903.x, (float)this.p903.y);
        this.markInnerArea.lineTo((float)this.p904.x, (float)this.p904.y);
        this.markInnerArea.lineTo((float)this.p902.x, (float)this.p902.y);
        at02.transform(p14, this.p94);
        this.modifiedPoint = this.p909;
        this.polygonBounds = new Rectangle2D.Double();
        this.polygonBounds.setFrame(this.markarea.getBounds());
        if (prev == null) {
            return GUtil.union(this.polygonBounds, gateBounds);
        }
        if (prev.equals(this.polygonBounds)) {
            return gateBounds;
        }
        return GUtil.union(GUtil.union(prev, this.polygonBounds), gateBounds);
    }

    @Override
    public void dobeforeDrawModification(Graphics2D g2) {
    }

    @Override
    public void drawMyMARK(Graphics2D g2) {
        Color color = g2.getColor();
        BasicStroke org_stroke = (BasicStroke)g2.getStroke();
        double marklineWidth = 1.0;
        double halfMarklineWidth = this.lineLineWidth / 2.0;
        boolean bLineIsTooThin = false;
        if (this.lineLineWidth >= 2.2) {
            marklineWidth = 1.0;
        } else {
            bLineIsTooThin = true;
            marklineWidth = 0.5;
        }
        BasicStroke stroke = new BasicStroke((float)marklineWidth, 0, 0);
        g2.setStroke(stroke);
        g2.setColor(Color.WHITE);
        g2.fill(this.markInnerArea);
        g2.setColor(color);
        if (!bLineIsTooThin) {
            g2.fill(this.markarea);
        } else {
            g2.fill(this.markInnerArea);
        }
        g2.setStroke(org_stroke);
        g2.setColor(color);
    }

    public void drawCenterLine(Graphics2D g2) {
        Color color = g2.getColor();
        BasicStroke org_stroke = (BasicStroke)g2.getStroke();
        GLinkedStraightLine[] lines = this.parent.getLines();
        if (lines != null) {
            int i = 0;
            while (i < lines.length) {
                lines[i].drawCenterLine(g2);
                ++i;
            }
        }
        g2.setStroke(org_stroke);
        g2.setColor(color);
    }

    @Override
    public void doafterDrawModification(Graphics2D g2) {
        Color color = g2.getColor();
        BasicStroke org_stroke = (BasicStroke)g2.getStroke();
        g2.setStroke(org_stroke);
        g2.setColor(color);
    }
}

