/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineArrowShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.SBSymbol;

public class DirectSingleLine
extends GLinkedStraightLine
implements SBSymbol,
ReactionSymbol {
    public static final String CODENAME = "DIRECT_SINGLE_LINE";
    protected GLinkedLineArrowShape arrowShape1 = new GLinkedLineArrowShape();
    protected GLinkedLineArrowShape arrowShape3;
    private boolean isReversible = false;

    public DirectSingleLine() {
        this.arrowShape1.setType(1);
        this.arrowShape1.setReversed(true);
        this.arrowShape1.setVisible(false);
        this.addModificationShape(this.arrowShape1);
        this.arrowShape3 = new GLinkedLineArrowShape();
        this.arrowShape3.setType(1);
        this.arrowShape3.setVisible(false);
        this.addModificationShape(this.arrowShape3);
        this.arrowShape1.setIndex(1);
        this.arrowShape3.setIndex(3);
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public void setReversible(boolean isReversible) {
        this.isReversible = false;
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public int sourceSize() {
        return 1;
    }

    @Override
    public int destinationSize() {
        return 1;
    }

    @Override
    public boolean isLinkable(GLinkTarget elem, int index) {
        return false;
    }

    @Override
    public void drawPreview(Graphics2D g2, Rectangle bounds, Color color, double width) {
        Point2D.Double pt1 = new Point2D.Double();
        Point2D.Double pt2 = new Point2D.Double();
        pt1.x = (double)bounds.x + (double)bounds.width * 0.2;
        pt1.y = (double)bounds.y + (double)bounds.height * 0.5;
        pt2.x = (double)bounds.x + (double)bounds.width * 0.8;
        pt2.y = (double)bounds.y + (double)bounds.height * 0.5;
        Point2D.Double ptStart = (Point2D.Double)pt1.clone();
        Point2D.Double ptEnd = (Point2D.Double)pt2.clone();
        GLinkedLineArrowShape arrowShape = new GLinkedLineArrowShape();
        arrowShape.updateModification(pt1, pt2, width);
        boolean candraw = true;
        if (arrowShape != null) {
            double maxlength;
            double wdt = arrowShape.getModificationBounds().getWidth() / 2.0;
            if (wdt > (maxlength = (pt2.x - pt1.x) * 80.0 / 100.0)) {
                candraw = false;
                pt2.x -= maxlength;
            } else {
                pt2.x -= wdt;
            }
        }
        Line2D.Double line = new Line2D.Double(ptStart, ptEnd);
        BasicStroke stroke = new BasicStroke((float)width, 0, 1);
        g2.setStroke(stroke);
        g2.setColor(color);
        if (candraw) {
            g2.draw(line);
        }
    }

    @Override
    public GLinkPositionInfo getTargetLinkPositionInfoAt(int i) {
        if (i == 0) {
            return this.startLinkPositionInfo;
        }
        if (i == 1) {
            return null;
        }
        return null;
    }

    @Override
    public GLinkPositionInfo getPointedLinkPosition(double x, double y) {
        return null;
    }

    @Override
    public GLinkedLine createCopiedLine() {
        GLinkedLine line = super.createCopiedLine();
        ((ReactionSymbol)((Object)line)).setReversible(this.isReversible);
        return line;
    }

    @Override
    public boolean inLine(double x, double y) {
        return super.inLine(x, y);
    }
}

