/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.reaction;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedShape;
import jp.sbi.celldesigner.LinkedCreaseLineForComplex3;
import jp.sbi.celldesigner.LinkedLineComplex3;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;

public class DimerFormation
extends LinkedLineComplex3
implements SBSymbol,
ReactionSymbol {
    public static final double dOutterD = 6.0;
    public static final String CODENAME = "HETERODIMER_ASSOCIATION";
    private boolean isReversible = false;
    private Ellipse2D ellipse = new Ellipse2D.Double();

    public DimerFormation() {
        this.init();
    }

    private void myinit() {
        ((LinkedCreaseLineForComplex3)this.line1).setArrowShape(this.arrowShape13);
        this.arrowShape13.setVisible(false);
        ((LinkedCreaseLineForComplex3)this.line2).setArrowShape(this.arrowShape23);
        this.arrowShape23.setVisible(false);
        ((LinkedCreaseLineForComplex3)this.line3).setArrowShape(this.arrowShape33);
        this.line1.setCurveBindingIndex(1);
        this.line2.setCurveBindingIndex(1);
        this.line3.setCurveBindingIndex(0);
        this.resetProcessNode(this, 0);
    }

    @Override
    protected void init(int num0, int num1, int num2) {
        super.init(num0, num1, num2);
        this.myinit();
    }

    @Override
    public GLinkedShape createCopy() {
        GLinkedShape shepe = super.createCopy();
        ((ReactionSymbol)((Object)shepe)).setReversible(this.isReversible);
        return shepe;
    }

    @Override
    public void drawCenterMark(Graphics2D g2) {
        Color color;
        super.drawCenterMark(g2);
        Point2D.Double p = super.getMidPoint();
        if (p == null) {
            return;
        }
        try {
            Point2D.Double[] ps;
            if (this.getProcessNode() != null && this.getProcessNode().isInSBGNViewer() && (ps = this.setupLinkAnchorCoord()) != null && ps[2] != null) {
                p = ps[2];
            }
        }
        catch (Exception ps) {
            // empty catch block
        }
        if ((color = g2.getColor()) != GColor.HIGHLIGHTED_COLOR) {
            color = super.getColor();
        }
        this.drawCenterMark1(g2, p, super.getOffset(), color, super.getLineWidth());
    }

    public void drawCenterMark1(Graphics2D g2, Point2D.Double pt, Point2D.Double offset, Color color, double lineWidth) {
        Color org_color = g2.getColor();
        if (org_color != GColor.HIGHLIGHTED_COLOR) {
            g2.setColor(color);
        }
        double size = lineWidth + 6.0;
        this.ellipse.setFrame(pt.x + offset.x - size / 2.0, pt.y + offset.y - size / 2.0, size, size);
        g2.fill(this.ellipse);
        g2.setColor(org_color);
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public void setReversible(boolean isReversible) {
        if (isReversible) {
            this.arrowShape13.setVisible(true);
            this.arrowShape23.setVisible(true);
        } else {
            this.arrowShape13.setVisible(false);
            this.arrowShape23.setVisible(false);
        }
        this.isReversible = isReversible;
    }

    @Override
    public boolean isReversible() {
        return this.isReversible;
    }

    @Override
    public int sourceSize() {
        return 2;
    }

    @Override
    public int destinationSize() {
        return 1;
    }

    @Override
    public boolean isLinkable(GLinkTarget elem, int index) {
        if (index == 0 || index == 1) {
            if (elem instanceof SpeciesAlias) {
                return true;
            }
        } else if (index == 2) {
            if (elem instanceof SpeciesAlias) {
                return true;
            }
            if (elem instanceof ReactionLink && ((ReactionLink)elem).isBaseLink()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Point2D.Double[] getPointsForPrview(Rectangle bounds) {
        Point2D.Double pt1 = new Point2D.Double();
        Point2D.Double pt2 = new Point2D.Double();
        Point2D.Double pt3 = new Point2D.Double();
        Point2D.Double ptc = new Point2D.Double();
        pt2.x = (double)bounds.x + (double)bounds.width * 0.2;
        pt2.y = (double)bounds.y + (double)bounds.height * 0.3;
        pt1.x = (double)bounds.x + (double)bounds.width * 0.2;
        pt1.y = (double)bounds.y + (double)bounds.height * 0.7;
        pt3.x = (double)bounds.x + (double)bounds.width * 0.8;
        pt3.y = (double)bounds.y + (double)bounds.height * 0.5;
        ptc.x = (double)bounds.x + (double)bounds.width * 0.5;
        ptc.y = (double)bounds.y + (double)bounds.height * 0.5;
        Point2D.Double[] array = new Point2D.Double[]{pt1, pt2, pt3, ptc};
        return array;
    }

    @Override
    public void setLineWidth(double lineWidth) {
        super.setLineWidth(lineWidth);
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
    }

    @Override
    public double getLineWidth() {
        return super.getLineWidth();
    }

    @Override
    public Color getColor() {
        return super.getColor();
    }

    @Override
    public int getTheArmIDwhichProcessNodeIn() {
        return 2;
    }

    @Override
    public boolean getChangeRightLeftFLGofProcessNode() {
        return true;
    }
}

