/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.creator;

import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.JOptionPane;
import jp.fric.graphics.draw.GCreater;
import jp.fric.graphics.draw.GCreaterResult;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramedShape;
import jp.sbi.celldesigner.ComplexSpeciesProperty;
import jp.sbi.celldesigner.ComplexSpeciesShape;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesSymbolCreater;

public class ReleaseHeterodimer
implements SBSymbol,
SpeciesSymbolCreater,
GCreater {
    public static final String CODENAME = "RELEASE_HETEROMULTIMER";

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public boolean isSelectable(GElement elem) {
        if (elem instanceof SpeciesAlias) {
            GFramedShape shape = ((SpeciesAlias)elem).getGFramedShape();
            return shape instanceof ComplexSpeciesShape;
        }
        return false;
    }

    @Override
    public GCreaterResult doCreate(GElement selected) {
        if (MainWindow.getLastInstance() != null && MainWindow.getLastInstance().getTargetControlPanelWindow() != null) {
            if (JOptionPane.showConfirmDialog(null, "It becomes impossible to take ControlPanel and adjustment. Is it all right?") != 0) {
                GCreaterResult rslt = new GCreaterResult();
                rslt.setEndOfCreation(true);
                return rslt;
            }
            MainWindow win = MainWindow.getLastInstance();
            win.removeListOfCP(win.getTargetControlPanelWindow());
        }
        GCreaterResult rslt = new GCreaterResult();
        SpeciesAlias complexAlias = (SpeciesAlias)selected;
        ComplexSpeciesShape complex = (ComplexSpeciesShape)complexAlias.getGFramedShape();
        Vector innerAliases = ((ComplexSpeciesProperty)complex.getProperty()).getSpeciesAliases();
        Point2D.Double m = complexAlias.targetPoint();
        int i = 0;
        while (i < innerAliases.size()) {
            SpeciesAlias a = (SpeciesAlias)innerAliases.elementAt(i);
            SpeciesAlias alias = a.duplicate();
            alias.setHistoricalSpecies(alias.getOriginalSpecies());
            Point2D.Double c = alias.targetPoint();
            Point2D.Double p = alias.getFramePosition();
            alias.setFramePosition(p.x + (c.x - m.x) * 0.5, p.y + (c.y - m.y) * 0.5);
            alias.update();
            rslt.add(alias);
            ++i;
        }
        rslt.remove(selected);
        rslt.setEndOfCreation(true);
        return rslt;
    }

    @Override
    public GCreaterResult interrupt() {
        return null;
    }
}

