/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.creator;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;
import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GCreater;
import jp.fric.graphics.draw.GCreaterResult;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedLine;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.ReactionSymbolCreater;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.Complex;
import jp.sbi.celldesigner.symbol.species.ComplexBrief;
import jp.sbi.celldesigner.symbol.species.Tag;

public class HomodimerFormation
implements SBSymbol,
ReactionSymbolCreater,
GCreater {
    public static final String CODENAME = "HOMODIMER_FORMATION";
    private GLinkPositionInfo posinfTargetTmp = new GLinkPositionInfo(4, 0.0);

    public GLinkPositionInfo getPosinfTargetTmp() {
        return this.posinfTargetTmp;
    }

    public void setPosinfTargetTmp(GLinkPositionInfo pos) {
        if (pos != null) {
            this.posinfTargetTmp = pos;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public boolean isSelectable(GElement elem) {
        SpeciesShape shape;
        if (elem instanceof GAtom) {
            int view = ((GAtom)elem).getCurrentView();
            if (view == -1) {
                return false;
            }
            if (view == 3) {
                return false;
            }
        }
        if (elem instanceof SpeciesAlias && (shape = (SpeciesShape)((Object)((SpeciesAlias)elem).getGFramedShape())) instanceof MonoSpeciesShape) {
            SpeciesSymbol sbm = ((MonoSpeciesShape)shape).getSpeciesSymbol();
            if (sbm instanceof Tag) {
                return false;
            }
            MonoSpeciesProperty property = (MonoSpeciesProperty)shape.getProperty();
            String type = property.getType();
            int homodimer = property.getHomodimer();
            if (!type.equals("DEGRADED") && homodimer < 2) {
                return true;
            }
        }
        return false;
    }

    private GCreaterResult doCreatePrivate(GElement selected) {
        SBSymbol rSymbol;
        if (MainWindow.getLastInstance() != null && MainWindow.getLastInstance().getTargetControlPanelWindow() != null) {
            if (JOptionPane.showConfirmDialog(null, "It becomes impossible to take ControlPanel and adjustment. Is it all right?") != 0) {
                GCreaterResult rslt = new GCreaterResult();
                rslt.setEndOfCreation(true);
                return rslt;
            }
            MainWindow win = MainWindow.getLastInstance();
            win.removeListOfCP(win.getTargetControlPanelWindow());
        }
        SpeciesAlias alias = (SpeciesAlias)selected;
        MonoSpeciesShape mono = (MonoSpeciesShape)alias.getGFramedShape();
        MonoSpeciesProperty property = (MonoSpeciesProperty)mono.getProperty();
        Rectangle2D.Double b1 = mono.getFrameBounds();
        MonoSpeciesProperty property2 = (MonoSpeciesProperty)property.deepClone();
        property2.setHomodimer(2);
        SpeciesAlias alias2 = alias.duplicate();
        MonoSpeciesShape mono2 = (MonoSpeciesShape)alias2.getGFramedShape();
        Rectangle2D.Double b2 = mono2.setProperty(property2);
        double cy1 = b1.getCenterY();
        double cy2 = b2.getCenterY();
        double shiftY = cy2 - cy1;
        alias2.setFramePosition(b2.x + b2.width + 50.0, b2.y - shiftY);
        alias2.setFrameSize(b2.width, b2.height);
        if (alias instanceof ComplexSpeciesAlias) {
            Point2D.Double usualFrameSize = alias.getFrameSize(0);
            if (usualFrameSize == null || usualFrameSize.x < 16.0 || usualFrameSize.y < 16.0) {
                Complex smbl = (Complex)SBFactory.createSymbol("COMPLEX");
                double frameWidth = smbl.defaultSize().width;
                double frameHeight = smbl.defaultSize().height;
                usualFrameSize = new Point2D.Double(frameWidth, frameHeight);
            }
            alias2.setFrameSize(0, usualFrameSize.x, usualFrameSize.y);
            Point2D.Double briefFrameSize = alias.getFrameSize(1);
            if (briefFrameSize == null || briefFrameSize.x < 16.0 || briefFrameSize.y < 16.0) {
                ComplexBrief smbl = (ComplexBrief)SBFactory.createSymbol("COMPLEX_PACKED");
                double frameWidth = smbl.defaultSize().width;
                double frameHeight = smbl.defaultSize().height;
                briefFrameSize = new Point2D.Double(frameWidth, frameHeight);
            }
            alias2.setFrameSize(1, briefFrameSize.x, briefFrameSize.y);
        }
        alias2.update();
        alias2.setOriginalSpecies(null);
        if (alias instanceof ComplexSpeciesAlias) {
            ComplexSpeciesAlias cmpx = (ComplexSpeciesAlias)alias2;
            cmpx.changeView(0);
        }
        if ((rSymbol = SBFactory.createSymbol("STATE_TRANSITION")) == null) {
            return null;
        }
        int s = ((ReactionSymbol)((Object)rSymbol)).sourceSize();
        int t = ((ReactionSymbol)((Object)rSymbol)).destinationSize();
        ReactionLink link = new ReactionLink(s, t);
        try {
            link.setSymbol(rSymbol);
            link.setTargetAt((GLinkTarget)alias, 0, this.posinfTargetTmp);
            link.setTargetAt((GLinkTarget)alias2, 1, new GLinkPositionInfo(12, 0.0));
        }
        catch (Exception e) {
            return null;
        }
        link.update();
        link.setTmpInfo(CODENAME);
        GCreaterResult rslt = new GCreaterResult();
        rslt.add(alias2);
        rslt.add(link);
        rslt.setEndOfCreation(true);
        return rslt;
    }

    @Override
    public GCreaterResult doCreate(GElement selected) {
        int backupConnectPolicy = GLinkedLine.getDefaultConnectPolicy();
        GLinkedLine.setDefaultConnectPolicy(0);
        try {
            GCreaterResult gCreaterResult = this.doCreatePrivate(selected);
            return gCreaterResult;
        }
        finally {
            GLinkedLine.setDefaultConnectPolicy(backupConnectPolicy);
        }
    }

    @Override
    public GCreaterResult interrupt() {
        return null;
    }
}

