/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.creator;

import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;
import jp.fric.graphics.draw.GCreater;
import jp.fric.graphics.draw.GCreaterResult;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.ReactionSymbolCreater;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.Tag;

public class Degradation
implements SBSymbol,
ReactionSymbolCreater,
GCreater {
    public static final String CODENAME = "DEGRADATION";
    private GLinkPositionInfo posinfTargetTmp = new GLinkPositionInfo(4, 0.0);

    public GLinkPositionInfo getPosinfTargetTmp() {
        return this.posinfTargetTmp;
    }

    public void setPosinfTargetTmp(GLinkPositionInfo pos) {
        if (pos != null) {
            this.posinfTargetTmp = pos;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public boolean isSelectable(GElement elem) {
        if (elem instanceof SpeciesAlias) {
            SpeciesSymbol sbm;
            SpeciesAlias selected = (SpeciesAlias)elem;
            GFramedShape gfshp = selected.getGFramedShape();
            return !(gfshp instanceof MonoSpeciesShape) || !((sbm = ((MonoSpeciesShape)gfshp).getSpeciesSymbol()) instanceof Tag);
        }
        return false;
    }

    @Override
    public GCreaterResult doCreate(GElement selected) {
        if (MainWindow.getLastInstance() != null && MainWindow.getLastInstance().getTargetControlPanelWindow() != null) {
            if (JOptionPane.showConfirmDialog(null, "It becomes impossible to take ControlPanel and adjustment. Is it all right?") != 0) {
                GCreaterResult rslt = new GCreaterResult();
                rslt.setEndOfCreation(true);
                return rslt;
            }
            MainWindow win = MainWindow.getLastInstance();
            win.removeListOfCP(win.getTargetControlPanelWindow());
        }
        SpeciesAlias alias = (SpeciesAlias)selected;
        MonoSpeciesProperty property = new MonoSpeciesProperty();
        String name = String.valueOf(alias.getName()) + "_degraded";
        property.setName(name);
        property.setType("DEGRADED");
        MonoSpeciesShape mono = new MonoSpeciesShape("DEGRADED");
        mono.setProperty(property);
        ElementSpeciesAlias alias2 = new ElementSpeciesAlias();
        alias2.setGFramedShape(mono);
        Rectangle2D.Double b = alias.getFrameBounds();
        alias2.setFramePosition(b.x + b.width + 50.0, b.y + (b.height - 30.0) / 2.0);
        alias2.setFrameSize(30.0, 30.0);
        alias2.update();
        SBSymbol rSymbol = SBFactory.createSymbol("STATE_TRANSITION");
        if (rSymbol == null) {
            return null;
        }
        int s = ((ReactionSymbol)((Object)rSymbol)).sourceSize();
        int t = ((ReactionSymbol)((Object)rSymbol)).destinationSize();
        ReactionLink link = new ReactionLink(s, t);
        try {
            link.setSymbol(rSymbol);
            link.setTargetAt((GLinkTarget)alias, 0, this.posinfTargetTmp);
            link.setTargetAt((GLinkTarget)alias2, 1, new GLinkPositionInfo(12, 0.0));
        }
        catch (Exception e) {
            return null;
        }
        link.update();
        GCreaterResult rslt = new GCreaterResult();
        rslt.add(alias2);
        rslt.add(link);
        rslt.setEndOfCreation(true);
        return rslt;
    }

    @Override
    public GCreaterResult interrupt() {
        return null;
    }
}

