/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.creator;

import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;
import jp.fric.graphics.draw.GCreater;
import jp.fric.graphics.draw.GCreaterResult;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.sbi.celldesigner.ComplexSpeciesShape;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.ReactionSymbolCreater;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.species.Tag;

public class CreateTagWithLine
implements SBSymbol,
ReactionSymbolCreater,
GCreater {
    public static final String CODENAME = "AUTO_CREATE_TAG";
    private static final double marginFromSelectToTag = 50.0;
    private GLinkPositionInfo posinfTargetTmp = new GLinkPositionInfo(4, 0.0);

    public GLinkPositionInfo getPosinfTargetTmp() {
        return this.posinfTargetTmp;
    }

    public void setPosinfTargetTmp(GLinkPositionInfo pos) {
        this.posinfTargetTmp = pos;
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public boolean isSelectable(GElement elem) {
        if (elem == null) {
            return false;
        }
        if (elem instanceof SpeciesAlias) {
            SpeciesSymbol sbm;
            SpeciesAlias selected = (SpeciesAlias)elem;
            GFramedShape gfshp = selected.getGFramedShape();
            return !(gfshp instanceof MonoSpeciesShape) || !((sbm = ((MonoSpeciesShape)gfshp).getSpeciesSymbol()) instanceof Tag);
        }
        return false;
    }

    @Override
    public GCreaterResult doCreate(GElement ge) {
        try {
            if (MainWindow.getLastInstance() != null && MainWindow.getLastInstance().getTargetControlPanelWindow() != null) {
                int result = JOptionPane.showConfirmDialog(null, "It becomes impossible to take ControlPanel and adjustment. Is it all right?");
                if (result != 0) {
                    throw new Exception();
                }
                MainWindow win = MainWindow.getLastInstance();
                win.removeListOfCP(win.getTargetControlPanelWindow());
            }
            SpeciesAlias selected = (SpeciesAlias)ge;
            MonoSpeciesProperty mselectedProperty = null;
            GFramedShape gfshp = selected.getGFramedShape();
            if (gfshp instanceof MonoSpeciesShape) {
                mselectedProperty = (MonoSpeciesProperty)((MonoSpeciesShape)gfshp).getProperty();
            } else if (gfshp instanceof ComplexSpeciesShape) {
                mselectedProperty = (MonoSpeciesProperty)((ComplexSpeciesShape)gfshp).getProperty();
            }
            String name = String.valueOf(selected.getName()) + "_tag";
            if (mselectedProperty != null) {
                name = String.valueOf(mselectedProperty.getName()) + "_tag";
            }
            MonoSpeciesProperty property = new MonoSpeciesProperty();
            property.setName(name);
            property.setType("TAG");
            MonoSpeciesShape mono = new MonoSpeciesShape("TAG");
            mono.setProperty(property);
            ElementSpeciesAlias tag = new ElementSpeciesAlias();
            tag.setGFramedShape(mono);
            SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol("TAG"));
            double frameWidth = briefSymbol01.defaultSize().width;
            double frameHeight = briefSymbol01.defaultSize().height;
            String tagdirect = "";
            if (this.posinfTargetTmp == null) {
                tagdirect = "RIGHT";
            } else {
                int pos = this.posinfTargetTmp.getPosition();
                switch (pos) {
                    case 0: 
                    case 1: 
                    case 15: {
                        tagdirect = "DOWN";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        tagdirect = "LEFT";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        tagdirect = "UP";
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        tagdirect = "RIGHT";
                        break;
                    }
                    default: {
                        tagdirect = "RIGHT";
                    }
                }
            }
            if (tagdirect.equals("UP") || tagdirect.equals("DOWN")) {
                double tmp = frameWidth;
                frameWidth = frameHeight;
                frameHeight = tmp;
            }
            Rectangle2D.Double selectedBound = selected.getFrameBounds();
            double frameStartX = 0.0;
            double frameStartY = 0.0;
            if (tagdirect.equals("UP")) {
                frameStartX = selectedBound.getCenterX() - frameWidth / 2.0;
                frameStartY = selectedBound.y + selectedBound.height + 50.0;
            } else if (tagdirect.equals("DOWN")) {
                frameStartX = selectedBound.getCenterX() - frameWidth / 2.0;
                frameStartY = selectedBound.y - 50.0 - frameHeight;
            } else if (tagdirect.equals("RIGHT")) {
                frameStartX = selectedBound.x - 50.0 - frameWidth;
                frameStartY = selectedBound.getCenterY() - frameHeight / 2.0;
            } else if (tagdirect.equals("LEFT")) {
                frameStartX = selectedBound.x + selectedBound.width + 50.0;
                frameStartY = selectedBound.getCenterY() - frameHeight / 2.0;
            }
            tag.setFramePosition(frameStartX, frameStartY);
            tag.setFrameSize(frameWidth, frameHeight);
            tag.update();
            Tag tagSymbol = (Tag)mono.getSpeciesSymbol();
            tagSymbol.resetSymbolBounds(frameStartX, frameStartY, frameWidth, frameHeight, tagdirect);
            GLinkPositionInfo tagPosInf = new GLinkPositionInfo(tagSymbol.getSharpPoint().indexAnchorpoint, 0.0);
            SBSymbol rSymbol = SBFactory.createSymbol("DIRECT_SINGLE_LINE");
            if (rSymbol == null) {
                throw new Exception();
            }
            int s = ((ReactionSymbol)((Object)rSymbol)).sourceSize();
            int t = ((ReactionSymbol)((Object)rSymbol)).destinationSize();
            ReactionLink link = new ReactionLink(s, t);
            link.setSymbol(rSymbol);
            link.setTargetAt((GLinkTarget)tag, 0, tagPosInf);
            link.setTargetAt((GLinkTarget)selected, 1, (GLinkPositionInfo)null);
            link.update();
            link.setTmpInfo(CODENAME);
            GCreaterResult rslt = new GCreaterResult();
            rslt.add(tag);
            rslt.add(link);
            rslt.setEndOfCreation(true);
            rslt.setEndedWithError(false);
            return rslt;
        }
        catch (Exception myErr) {
            GCreaterResult rslt = new GCreaterResult();
            rslt.setEndOfCreation(true);
            rslt.setEndedWithError(true);
            return rslt;
        }
    }

    @Override
    public GCreaterResult interrupt() {
        return null;
    }
}

