/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.creator;

import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;
import jp.fric.graphics.draw.GCreater;
import jp.fric.graphics.draw.GCreaterResult;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.sbi.celldesigner.ComplexSpeciesShape;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.ReactionSymbolCreater;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionLink;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerTagFreeLineSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerMonoSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerTagSymbol;
import jp.sbi.celldesigner.symbol.species.AntiSenseRNA;
import jp.sbi.celldesigner.symbol.species.Degraded;
import jp.sbi.celldesigner.symbol.species.Ion;
import jp.sbi.celldesigner.symbol.species.RNA;
import jp.sbi.celldesigner.symbol.species.Receptor;
import jp.sbi.celldesigner.symbol.species.Truncated;

public class CreateLayerTagWithLine
implements SBSymbol,
ReactionSymbolCreater,
GCreater {
    public static final String CODENAME = "AUTO_CREATE_TAG";
    public static final int LayerTag = -99;
    public static final String LayerForTag = "LayerForTag";
    private static final double marginFromSelectToTag = 50.0;
    private GLinkPositionInfo posinfTargetTmp = new GLinkPositionInfo(4, 0.0);

    public GLinkPositionInfo getPosinfTargetTmp() {
        return this.posinfTargetTmp;
    }

    public void setPosinfTargetTmp(GLinkPositionInfo pos) {
        this.posinfTargetTmp = pos;
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public boolean isSelectable(GElement elem) {
        if (elem == null) {
            return false;
        }
        return elem instanceof SpeciesAlias;
    }

    @Override
    public GCreaterResult doCreate(GElement ge) {
        try {
            if (MainWindow.getLastInstance() != null && MainWindow.getLastInstance().getTargetControlPanelWindow() != null) {
                int result = JOptionPane.showConfirmDialog(null, "It becomes impossible to take ControlPanel and adjustment. Is it all right?");
                if (result != 0) {
                    throw new Exception();
                }
                MainWindow win = MainWindow.getLastInstance();
                win.removeListOfCP(win.getTargetControlPanelWindow());
            }
            SpeciesAlias selected = (SpeciesAlias)ge;
            MonoSpeciesProperty mselectedProperty = null;
            GFramedShape gfshp = selected.getGFramedShape();
            if (gfshp instanceof MonoSpeciesShape) {
                mselectedProperty = (MonoSpeciesProperty)((MonoSpeciesShape)gfshp).getProperty();
            } else if (gfshp instanceof ComplexSpeciesShape) {
                mselectedProperty = (MonoSpeciesProperty)((ComplexSpeciesShape)gfshp).getProperty();
            }
            String name = String.valueOf(selected.getName()) + "_tag";
            if (mselectedProperty != null) {
                name = String.valueOf(mselectedProperty.getName()) + "_tag";
            }
            LayerMonoSpeciesShape mono = new LayerMonoSpeciesShape("TAG");
            LayerSpeciesAlias tag = new LayerSpeciesAlias();
            tag.setGFramedShape(mono);
            LayerSpeciesSymbol briefSymbol01 = (LayerSpeciesSymbol)((Object)SBFactory.createSymbol("TAG"));
            double frameWidth = briefSymbol01.defaultSize().width;
            double frameHeight = briefSymbol01.defaultSize().height;
            String tagdirect = this.getTagdirection();
            if (tagdirect.equals("UP") || tagdirect.equals("DOWN")) {
                double tmp = frameWidth;
                frameWidth = frameHeight;
                frameHeight = tmp;
            }
            Rectangle2D.Double selectedBound = selected.getFrameBounds();
            double frameStartX = 0.0;
            double frameStartY = 0.0;
            GLinkPositionInfo linkPosition = new GLinkPositionInfo(4, 0.0);
            double selectedSpeciesWidth = selected.getFrameBounds().getWidth();
            double selectedSpeciesHeigth = selected.getFrameBounds().getHeight();
            if (selected.getGFramedShape() instanceof MonoSpeciesShape) {
                double speciesWidth = ((MonoSpeciesShape)selected.getGFramedShape()).getSpeciesSymbol().getSymbolBounds().getWidth();
                double speciesHeight = ((MonoSpeciesShape)selected.getGFramedShape()).getSpeciesSymbol().getSymbolBounds().getHeight();
                double ionFrameWidth = selectedSpeciesWidth < selectedSpeciesHeigth ? selectedSpeciesWidth : selectedSpeciesHeigth;
                selectedSpeciesWidth = speciesWidth;
                selectedSpeciesHeigth = speciesHeight;
                if (((MonoSpeciesShape)selected.getGFramedShape()).getSpeciesSymbol() instanceof Ion) {
                    selectedSpeciesWidth = selected.getFrameBounds().getWidth() - ionFrameWidth + speciesWidth;
                }
                if (((MonoSpeciesShape)selected.getGFramedShape()).getSpeciesSymbol() instanceof Degraded) {
                    selectedSpeciesWidth = selected.getFrameBounds().getWidth() - ionFrameWidth + speciesWidth + 10.0;
                    selectedSpeciesHeigth = speciesHeight + 10.0;
                }
            }
            if (tagdirect.equals("UP")) {
                frameStartX = selectedBound.getX() + selectedSpeciesWidth * 0.5 - frameWidth / 2.0;
                frameStartY = selectedBound.getY() + selectedSpeciesHeigth + 50.0;
                try {
                    if (((MonoSpeciesShape)gfshp).getSpeciesSymbol() instanceof Truncated) {
                        frameStartX = (selectedBound.getX() + 0.8 * selectedSpeciesWidth) * 0.666666666666666 + selectedBound.getX() * 0.333333333333333 - frameWidth / 2.0;
                    } else if (((MonoSpeciesShape)gfshp).getSpeciesSymbol() instanceof RNA) {
                        frameStartX = ((MonoSpeciesShape)gfshp).getSpeciesSymbol() instanceof AntiSenseRNA ? selectedBound.getX() + selectedSpeciesHeigth + (selectedSpeciesWidth - selectedSpeciesHeigth) / 2.0 - frameWidth / 2.0 : selectedBound.getX() + (selectedSpeciesWidth - selectedSpeciesHeigth) / 2.0 - frameWidth / 2.0;
                    }
                }
                catch (Exception speciesWidth) {
                    // empty catch block
                }
                linkPosition = new GLinkPositionInfo(8, 0.0);
                this.posinfTargetTmp = new GLinkPositionInfo(0, 0.0);
            } else if (tagdirect.equals("DOWN")) {
                frameStartX = selectedBound.getX() + selectedSpeciesWidth * 0.5 - frameWidth / 2.0;
                frameStartY = selectedBound.getY() - 50.0 - frameHeight;
                try {
                    if (((MonoSpeciesShape)gfshp).getSpeciesSymbol() instanceof RNA) {
                        frameStartX = ((MonoSpeciesShape)gfshp).getSpeciesSymbol() instanceof AntiSenseRNA ? selectedBound.getX() + (selectedSpeciesWidth - selectedSpeciesHeigth) / 2.0 - frameWidth / 2.0 : selectedBound.getX() + selectedSpeciesHeigth + (selectedSpeciesWidth - selectedSpeciesHeigth) / 2.0 - frameWidth / 2.0;
                    }
                }
                catch (Exception speciesWidth) {
                    // empty catch block
                }
                linkPosition = new GLinkPositionInfo(0, 0.0);
                this.posinfTargetTmp = new GLinkPositionInfo(8, 0.0);
            } else if (tagdirect.equals("RIGHT")) {
                frameStartX = selectedBound.getX() - 50.0 - frameWidth;
                frameStartY = selectedBound.getY() + selectedSpeciesHeigth * 0.5 - frameHeight / 2.0;
                try {
                    if (((MonoSpeciesShape)gfshp).getSpeciesSymbol() instanceof Receptor) {
                        frameStartY = selectedBound.getY() + selectedSpeciesHeigth * 0.4 - frameHeight / 2.0;
                    }
                }
                catch (Exception speciesWidth) {
                    // empty catch block
                }
                linkPosition = new GLinkPositionInfo(12, 0.0);
                this.posinfTargetTmp = new GLinkPositionInfo(4, 0.0);
            } else if (tagdirect.equals("LEFT")) {
                frameStartX = selectedBound.getX() + selectedSpeciesWidth + 50.0;
                frameStartY = selectedBound.getY() + selectedSpeciesHeigth * 0.5 - frameHeight / 2.0;
                try {
                    if (((MonoSpeciesShape)gfshp).getSpeciesSymbol() instanceof Receptor) {
                        frameStartY = selectedBound.getY() + selectedSpeciesHeigth * 0.4 - frameHeight / 2.0;
                    } else if (((MonoSpeciesShape)gfshp).getSpeciesSymbol() instanceof Truncated) {
                        frameStartY = selectedBound.getY() + selectedSpeciesHeigth * 0.6 - frameHeight / 2.0;
                    }
                }
                catch (Exception speciesWidth) {
                    // empty catch block
                }
                linkPosition = new GLinkPositionInfo(4, 0.0);
                this.posinfTargetTmp = new GLinkPositionInfo(12, 0.0);
            } else {
                throw new Exception();
            }
            tag.setFramePosition(frameStartX, frameStartY);
            tag.setFrameSize(frameWidth, frameHeight);
            tag.setBelong_layer_id(-99);
            tag.setName(name);
            tag.setText(name);
            tag.setTargetAlias(selected);
            tag.update();
            LayerTagSymbol tagSymbol = (LayerTagSymbol)mono.getSpeciesSymbol();
            tagSymbol.resetSymbolBounds(frameStartX, frameStartY, frameWidth, frameHeight, tagdirect);
            SBSymbol rSymbol = SBFactory.createSymbol("TAG_LINE");
            if (rSymbol == null) {
                throw new Exception();
            }
            int s = ((LayerTagFreeLineSymbol)rSymbol).sourceSize();
            int t = ((LayerTagFreeLineSymbol)rSymbol).destinationSize();
            LayerReactionLink link = new LayerReactionLink(s, t);
            link.setSymbol(rSymbol);
            link.setTargetAt((GLinkTarget)tag, 0, this.posinfTargetTmp);
            link.setTargetAt((GLinkTarget)selected, 1, linkPosition);
            link.setBelong_layer_id(-99);
            link.setTmpInfo(CODENAME);
            GCreaterResult rslt = new GCreaterResult();
            rslt.add(tag);
            rslt.add(link);
            rslt.setEndOfCreation(true);
            rslt.setEndedWithError(false);
            return rslt;
        }
        catch (Exception myErr) {
            GCreaterResult rslt = new GCreaterResult();
            rslt.setEndOfCreation(true);
            rslt.setEndedWithError(true);
            return rslt;
        }
    }

    @Override
    public GCreaterResult interrupt() {
        return null;
    }

    private String getTagdirection() {
        String tagdirect = "";
        if (this.posinfTargetTmp == null) {
            tagdirect = "RIGHT";
        } else {
            int pos = this.posinfTargetTmp.getPosition();
            switch (pos) {
                case 0: 
                case 1: 
                case 15: {
                    tagdirect = "DOWN";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    tagdirect = "LEFT";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    tagdirect = "UP";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    tagdirect = "RIGHT";
                    break;
                }
                default: {
                    tagdirect = "";
                }
            }
        }
        return tagdirect;
    }
}

