/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.creator;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;
import jp.fric.graphics.draw.GCreater;
import jp.fric.graphics.draw.GCreaterResult;
import jp.fric.graphics.draw.GElement;
import jp.sbi.celldesigner.ComplexSpeciesShape;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.SpeciesSymbolCreater;

public class CreateHeterodimer
implements SBSymbol,
SpeciesSymbolCreater,
GCreater {
    public static final String CODENAME = "CREATE_HETEROMULTIMER";
    private int selectedCount = 0;
    private SpeciesAlias firstAlias = null;
    private SpeciesAlias creatingAlias = null;

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public boolean isSelectable(GElement elem) {
        String type;
        SpeciesShape shape;
        return elem instanceof SpeciesAlias && (shape = (SpeciesShape)((Object)((SpeciesAlias)elem).getGFramedShape())) instanceof MonoSpeciesShape && !(type = ((MonoSpeciesProperty)shape.getProperty()).getType()).equals("DEGRADED");
    }

    @Override
    public GCreaterResult doCreate(GElement selected) {
        if (MainWindow.getLastInstance() != null && MainWindow.getLastInstance().getTargetControlPanelWindow() != null) {
            if (JOptionPane.showConfirmDialog(null, "It becomes impossible to take ControlPanel and adjustment. Is it all right?") != 0) {
                GCreaterResult rslt = new GCreaterResult();
                rslt.setEndOfCreation(true);
                return rslt;
            }
            MainWindow win = MainWindow.getLastInstance();
            win.removeListOfCP(win.getTargetControlPanelWindow());
        }
        GCreaterResult rslt = new GCreaterResult();
        rslt.setEndOfCreation(false);
        ++this.selectedCount;
        if (this.selectedCount == 1) {
            this.firstAlias = (SpeciesAlias)selected;
        } else if (this.selectedCount == 2) {
            SpeciesAlias alias1 = this.firstAlias.duplicate();
            SpeciesAlias alias2 = ((SpeciesAlias)selected).duplicate();
            this.attachTo(alias1, alias2);
            ComplexSpeciesShape complex = new ComplexSpeciesShape();
            Rectangle2D.Double r1 = complex.add(alias1);
            Rectangle2D.Double r2 = complex.add(alias2);
            this.creatingAlias = new ElementSpeciesAlias();
            this.creatingAlias.setGFramedShape(complex);
            this.creatingAlias.setFramePosition(r2.x, r2.y);
            this.creatingAlias.setFrameSize(r2.width, r2.height);
            this.creatingAlias.update();
            this.creatingAlias.setHighlighted(true);
            rslt.add(this.creatingAlias);
            rslt.remove(this.firstAlias);
            rslt.remove(selected);
        } else {
            SpeciesAlias alias3 = ((SpeciesAlias)selected).duplicate();
            this.attachTo(this.creatingAlias, alias3);
            SpeciesAlias alias4 = this.creatingAlias.duplicate();
            alias4.setOriginalSpecies(null);
            ComplexSpeciesShape complex = (ComplexSpeciesShape)alias4.getGFramedShape();
            Rectangle2D.Double r = complex.add(alias3);
            alias4.setFramePosition(r.x, r.y);
            alias4.setFrameSize(r.width, r.height);
            alias4.update();
            alias4.setHighlighted(true);
            rslt.add(alias4);
            rslt.remove(this.creatingAlias);
            rslt.remove(selected);
            this.creatingAlias = alias4;
        }
        return rslt;
    }

    private void attachTo(SpeciesAlias alias1, SpeciesAlias alias2) {
        Point2D.Double point1 = alias1.targetPoint();
        Point2D.Double point2 = alias2.targetPoint();
        double dx = (point2.x - point1.x) / Math.abs(point2.x - point1.x);
        double dy = (point2.y - point1.y) / Math.abs(point2.y - point1.y);
        double a = (point2.y - point1.y) / (point2.x - point1.x);
        int debugCnt = 0;
        String debugStr = "DEBUG CAUTION! [CreateHeterodimer] seems to be forever-loop. p1=" + point1.toString() + " p2=" + point2.toString();
        Point2D.Double touchPoint = new Point2D.Double(point1.x, point1.y);
        Rectangle2D.Double bounds = alias1.getFrameBounds();
        debugStr = String.valueOf(debugStr) + " bounds1=" + bounds.toString();
        while (bounds.contains(touchPoint.x, touchPoint.y)) {
            if (debugCnt > 1000) break;
            if (Math.abs(a) < 1.0) {
                touchPoint.x += dx;
                touchPoint.y += a * dx;
            } else {
                touchPoint.y += dy;
                touchPoint.x += dy / a;
            }
            ++debugCnt;
        }
        debugCnt = 0;
        while (!alias1.inShapeAsTarget(touchPoint.x, touchPoint.y)) {
            if (debugCnt > 1000) break;
            if (Math.abs(a) < 1.0) {
                touchPoint.x -= dx;
                touchPoint.y -= a * dx;
            } else {
                touchPoint.y -= dy;
                touchPoint.x -= dy / a;
            }
            ++debugCnt;
        }
        Point2D.Double size2 = alias2.getFrameSize();
        debugStr = String.valueOf(debugStr) + " size2=" + size2.toString();
        double x = touchPoint.x - size2.x / 2.0;
        double y = touchPoint.y - size2.y / 2.0;
        for (debugCnt = 0; debugCnt <= 1000; ++debugCnt) {
            alias2.setFramePosition(x, y);
            alias2.update();
            if (!alias2.inShapeAsTarget(touchPoint.x, touchPoint.y)) break;
            if (Math.abs(a) < 1.0) {
                x += dx;
                y += a * dx;
                continue;
            }
            y += dy;
            x += dy / a;
        }
    }

    @Override
    public GCreaterResult interrupt() {
        this.selectedCount = 0;
        this.firstAlias = null;
        this.creatingAlias = null;
        GCreaterResult rslt = new GCreaterResult();
        rslt.setEndOfCreation(true);
        return rslt;
    }
}

