/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.compartment;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import jp.fric.graphics.draw.GColoredShape;
import jp.fric.graphics.draw.GContainerShape;
import jp.fric.graphics.draw.GPointedShape;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.CompartmentShapePainting;
import jp.sbi.celldesigner.CompartmentSymbol;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.symbol.color.CompartmentColorScheme;
import jp.sbi.celldesigner.symbol.compartment.Membrane;

public abstract class OpenedCompartment
implements SBSymbol,
CompartmentSymbol,
GPointedShape,
GContainerShape,
GColoredShape {
    protected Color color = new Color(0, 0, 0);
    protected PaintScheme painter = null;
    private Membrane membrane = null;
    protected double thickness = 12.0;
    protected Stroke outerStroke = new BasicStroke(2.0f, 0, 1);
    private Stroke innerStroke = new BasicStroke(1.0f, 0, 1);
    protected Point2D.Double point = null;
    protected Shape outerShape = null;
    protected Shape innerShape = null;
    protected Shape outerLine = null;
    protected Shape innerLine = null;
    private Area membraneArea = null;
    protected static final double margin = 50.0;

    protected void initialize() {
        this.color = CompartmentColorScheme.getColor(this.getCode());
        this.painter = CompartmentColorScheme.getScheme(this.getCode());
        this.setMembrane(CompartmentColorScheme.getMembrane(this.getCode()));
        this.painter.setColor(this.color);
    }

    @Override
    public double getThickness() {
        return this.thickness;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean inOutsideOfEdge(double x, double y) {
        return this.outerShape.contains(x, y);
    }

    @Override
    public boolean inInsideOfEdge(double x, double y) {
        return this.innerShape.contains(x, y);
    }

    @Override
    public boolean onEdge(double x, double y) {
        if (this.outerShape == null || this.innerShape == null) {
            return false;
        }
        return this.outerShape.contains(x, y) && !this.innerShape.contains(x, y);
    }

    @Override
    public boolean inShape(double x, double y) {
        return this.inOutsideOfEdge(x, y);
    }

    protected void updateMembraneArea() {
        this.membraneArea = new Area(this.outerShape);
        this.membraneArea.subtract(new Area(this.innerShape));
    }

    @Override
    public void drawShape(Graphics2D g2, int colorflg) {
        if (this.point != null) {
            this.painter.fillHalfTransparentPaint(g2, this.membraneArea, colorflg);
            this.painter.setStroke(this.outerStroke);
            this.painter.drawEdge(g2, this.outerLine, colorflg);
            this.painter.setStroke(this.innerStroke);
            this.painter.drawEdge(g2, this.innerLine, colorflg);
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        if (this.painter != null) {
            this.painter.setColor(color);
        }
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public void setPaintScheme(PaintScheme painterin) {
        this.painter = painterin;
        this.painter.setColor(this.color);
    }

    @Override
    public Membrane getMembrane() {
        return this.membrane;
    }

    @Override
    public void setMembrane(Membrane mem) {
        this.membrane = mem;
        this.thickness = this.membrane.getThickness();
        this.outerStroke = new BasicStroke((float)this.membrane.getOuterLineWidth(), 0, 1);
        this.innerStroke = new BasicStroke((float)this.membrane.getInnerLineWidth(), 0, 1);
    }

    @Override
    public CompartmentShapePainting getComparmentShapePainting() {
        return new CompartmentShapePainting(this.membrane, this.color, this.painter);
    }

    @Override
    public void setCompartmentShapePainting(CompartmentShapePainting painting) {
        this.setMembrane(painting.getMembrane());
        this.setColor(painting.getColor());
        this.setPaintScheme(painting.getPaintScheme());
    }

    public Point2D.Double getHandleppointPostion() {
        if (this.point == null) {
            return null;
        }
        return (Point2D.Double)this.point.clone();
    }

    @Override
    public Area getOutterShape() {
        return new Area(this.outerShape);
    }
}

