/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.compartment;

import javax.swing.JOptionPane;

public class Membrane {
    private double thickness = 0.0;
    private double outerLineWidth = 0.0;
    private double innerLineWidth = 0.0;
    public final double minimumThickness = 2.0;

    public Membrane() {
    }

    public Membrane(double thickness, double outerLineWidth, double innerLineWidth) {
        this.thickness = thickness;
        this.outerLineWidth = outerLineWidth;
        this.innerLineWidth = innerLineWidth;
    }

    public Membrane(Membrane m) {
        this.thickness = m.thickness;
        this.outerLineWidth = m.outerLineWidth;
        this.innerLineWidth = m.innerLineWidth;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public void setOuterLineWidth(double outerLineWidth) {
        this.outerLineWidth = outerLineWidth;
    }

    public void setInnerLineWidth(double innerLineWidth) {
        this.innerLineWidth = innerLineWidth;
    }

    public double getThickness() {
        return this.thickness;
    }

    public double getOuterLineWidth() {
        return this.outerLineWidth;
    }

    public double getInnerLineWidth() {
        return this.innerLineWidth;
    }

    public String toString() {
        return String.valueOf(Double.toString(this.thickness)) + "," + Double.toString(this.outerLineWidth) + "," + Double.toString(this.innerLineWidth);
    }

    public boolean isValid() {
        return this.isValid(false);
    }

    public boolean isAllHaveBeenInputed(String thick_str, String w1_str, String w2_str, boolean bShowMessage) {
        if (thick_str == null || w1_str == null || w2_str == null) {
            return false;
        }
        if (thick_str.trim().equals("")) {
            if (bShowMessage) {
                String Message = "Please input 'Thickness' by the positive number.";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        if (w1_str.trim().equals("")) {
            if (bShowMessage) {
                String Message = "Please input 'Outer' by the positive number.";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        if (w2_str.trim().equals("")) {
            if (bShowMessage) {
                String Message = "Please input 'Inner' by the positive number.";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        double dNum = 0.0;
        try {
            dNum = Double.parseDouble(thick_str);
        }
        catch (Exception myErr) {
            if (bShowMessage) {
                String Message = "Please input 'Thickness' by the positive number.";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        try {
            dNum = Double.parseDouble(w1_str);
        }
        catch (Exception myErr) {
            if (bShowMessage) {
                String Message = "Please input 'Outer' by the positive number.";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        try {
            dNum = Double.parseDouble(w2_str);
        }
        catch (Exception myErr) {
            if (bShowMessage) {
                String Message = "Please input 'Inner' by the positive number.";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        return true;
    }

    public boolean isValid(boolean bShowMessage) {
        if (this.thickness <= 0.0) {
            if (bShowMessage) {
                String Message = "Please input 'Thickness' by the positive number.";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        if (this.outerLineWidth <= 0.0) {
            if (bShowMessage) {
                String Message = "Please input 'Outer' by the positive number.";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        if (this.innerLineWidth <= 0.0) {
            if (bShowMessage) {
                String Message = "Please input 'Inner' by the positive number.";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        if (!(this.thickness >= 2.0)) {
            if (bShowMessage) {
                String Message = "'Thickness' must be not less than '2.0' .";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        if (!(this.outerLineWidth >= this.innerLineWidth + 1.0)) {
            if (bShowMessage) {
                String Message = "The expression below is not satisfied.\n";
                Message = String.valueOf(Message) + "[Outer >= (Inner + 1)] ?";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        if (!(this.thickness >= (this.outerLineWidth + this.innerLineWidth) / 2.0 + 1.0)) {
            if (bShowMessage) {
                String Message = "The expression below is not satisfied.\n";
                Message = String.valueOf(Message) + "[Thickness >= (Outer + Inner) / 2 + 1] ?";
                this.showNoticeMsg(Message, 2);
            }
            return false;
        }
        return true;
    }

    public void showNoticeMsg(String Message, int MsgType) {
        JOptionPane.showMessageDialog(null, Message, "Bad Input", MsgType);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Membrane)) {
            return false;
        }
        Membrane mem = (Membrane)obj;
        return this.thickness == mem.thickness && this.outerLineWidth == mem.outerLineWidth && this.innerLineWidth == mem.innerLineWidth;
    }
}

