/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.compartment;

import java.awt.BasicStroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GPointedShape;
import jp.sbi.celldesigner.symbol.compartment.OpenedCompartment;

public class CompartmentSquareSW
extends OpenedCompartment {
    public static final String CODENAME = "SQUARE_CLOSEUP_SOUTHWEST";
    double R;
    public static final double defaultAngle = Math.PI;

    public CompartmentSquareSW() {
        this.initialize();
        this.outerShape = new GeneralPath();
        this.innerShape = new GeneralPath();
        this.outerLine = new GeneralPath();
        this.innerLine = new GeneralPath();
        this.R = 40.0;
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int getHandleLocation() {
        return 3;
    }

    @Override
    public Rectangle2D.Double updateShape(double x, double y, Rectangle2D.Double maxArea) {
        double minY;
        if (maxArea == null) {
            return null;
        }
        if (this.point == null) {
            this.point = new Point2D.Double();
        }
        this.point.x = x;
        this.point.y = y;
        double maxX = maxArea.x + maxArea.width;
        double localMargin = (this.thickness > this.R ? this.thickness : this.R) + 10.0;
        if (maxX - this.point.x < localMargin) {
            maxX = this.point.x + localMargin;
        }
        if (this.point.y - (minY = maxArea.y) < localMargin) {
            minY = this.point.y - localMargin;
        }
        Point2D.Double size = new Point2D.Double(maxX - this.point.x, this.point.y - minY);
        double innerRound = this.R - this.thickness;
        if (innerRound < 0.0) {
            innerRound = 0.0;
        }
        this.setShape((GeneralPath)this.outerShape, this.point.x, minY, size.x, size.y, this.R);
        this.setShape((GeneralPath)this.innerShape, this.point.x + this.thickness, minY, size.x - this.thickness, size.y - this.thickness, innerRound);
        this.setLine((GeneralPath)this.outerLine, this.point.x, minY, size.x, size.y, this.R);
        this.setLine((GeneralPath)this.innerLine, this.point.x + this.thickness, minY, size.x - this.thickness, size.y - this.thickness, innerRound);
        this.updateMembraneArea();
        int linewidth = 2 + (int)((BasicStroke)this.outerStroke).getLineWidth();
        return new Rectangle2D.Double(this.point.x - (double)(linewidth /= 2), minY, size.x + (double)linewidth, size.y + (double)linewidth);
    }

    private void setShape(GeneralPath path, double X, double Y, double W, double H, double R) {
        float x = (float)X;
        float y = (float)Y;
        float w = (float)W;
        float h = (float)H;
        float r = (float)R;
        path.reset();
        path.moveTo(x, y);
        path.lineTo(x, y + h - r);
        path.quadTo(x, y + h, x + r, y + h);
        path.lineTo(x + w, y + h);
        path.lineTo(x + w, y);
        path.closePath();
    }

    private void setLine(GeneralPath path, double X, double Y, double W, double H, double R) {
        float x = (float)X;
        float y = (float)Y;
        float w = (float)W;
        float h = (float)H;
        float r = (float)R;
        path.reset();
        path.moveTo(x, y);
        path.lineTo(x, y + h - r);
        path.quadTo(x, y + h, x + r, y + h);
        path.lineTo(x + w, y + h);
    }

    @Override
    public GPointedShape createCopy() {
        return new CompartmentSquareSW();
    }

    @Override
    public double getDefaultAngle() {
        return Math.PI;
    }
}

