/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.compartment;

import java.awt.BasicStroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GPointedShape;
import jp.sbi.celldesigner.symbol.compartment.OpenedCompartment;

public class CompartmentSquareSE
extends OpenedCompartment {
    public static final String CODENAME = "SQUARE_CLOSEUP_SOUTHEAST";
    double R;
    public static final double defaultAngle = 0.0;

    public CompartmentSquareSE() {
        this.initialize();
        this.outerShape = new GeneralPath();
        this.innerShape = new GeneralPath();
        this.outerLine = new GeneralPath();
        this.innerLine = new GeneralPath();
        this.R = 40.0;
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int getHandleLocation() {
        return 4;
    }

    @Override
    public Rectangle2D.Double updateShape(double x, double y, Rectangle2D.Double maxArea) {
        double minY;
        if (maxArea == null) {
            return null;
        }
        if (this.point == null) {
            this.point = new Point2D.Double();
        }
        this.point.x = x;
        this.point.y = y;
        double minX = maxArea.x;
        double localMargin = (this.thickness > this.R ? this.thickness : this.R) + 10.0;
        if (this.point.x - minX < localMargin) {
            minX = this.point.x - localMargin;
        }
        if (this.point.y - (minY = maxArea.y) < localMargin) {
            minY = this.point.y - localMargin;
        }
        Point2D.Double size = new Point2D.Double(this.point.x - minX, this.point.y - minY);
        double innerRound = this.R - this.thickness;
        if (innerRound < 0.0) {
            innerRound = 0.0;
        }
        this.setShape((GeneralPath)this.outerShape, minX, minY, size.x, size.y, this.R);
        this.setShape((GeneralPath)this.innerShape, minX, minY, size.x - this.thickness, size.y - this.thickness, innerRound);
        this.setLine((GeneralPath)this.outerLine, minX, minY, size.x, size.y, this.R);
        this.setLine((GeneralPath)this.innerLine, minX, minY, size.x - this.thickness, size.y - this.thickness, innerRound);
        this.updateMembraneArea();
        int linewidth = 2 + (int)((BasicStroke)this.outerStroke).getLineWidth();
        return new Rectangle2D.Double(minX, minY, size.x + (double)(linewidth /= 2), size.y + (double)linewidth);
    }

    private void setShape(GeneralPath path, double X, double Y, double W, double H, double R) {
        float x = (float)X;
        float y = (float)Y;
        float w = (float)W;
        float h = (float)H;
        float r = (float)R;
        path.reset();
        path.moveTo(x, y + h);
        path.lineTo(x + w - r, y + h);
        path.quadTo(x + w, y + h, x + w, y + h - r);
        path.lineTo(x + w, y);
        path.lineTo(x, y);
        path.closePath();
    }

    private void setLine(GeneralPath path, double X, double Y, double W, double H, double R) {
        float x = (float)X;
        float y = (float)Y;
        float w = (float)W;
        float h = (float)H;
        float r = (float)R;
        path.reset();
        path.moveTo(x, y + h);
        path.lineTo(x + w - r, y + h);
        path.quadTo(x + w, y + h, x + w, y + h - r);
        path.lineTo(x + w, y);
    }

    @Override
    public GPointedShape createCopy() {
        return new CompartmentSquareSE();
    }

    @Override
    public double getDefaultAngle() {
        return 0.0;
    }
}

