/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.compartment;

import java.awt.BasicStroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GPointedShape;
import jp.sbi.celldesigner.symbol.compartment.OpenedCompartment;

public class CompartmentSquareNW
extends OpenedCompartment {
    public static final String CODENAME = "SQUARE_CLOSEUP_NORTHWEST";
    private double R;
    public static final double defaultAngle = Math.PI;

    public CompartmentSquareNW() {
        this.initialize();
        this.outerShape = new GeneralPath();
        this.innerShape = new GeneralPath();
        this.outerLine = new GeneralPath();
        this.innerLine = new GeneralPath();
        this.R = 40.0;
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int getHandleLocation() {
        return 1;
    }

    @Override
    public Rectangle2D.Double updateShape(double x, double y, Rectangle2D.Double maxArea) {
        double maxY;
        if (maxArea == null) {
            return null;
        }
        if (this.point == null) {
            this.point = new Point2D.Double();
        }
        this.point.x = x;
        this.point.y = y;
        double maxX = maxArea.x + maxArea.width;
        double localMargin = (this.thickness > this.R ? this.thickness : this.R) + 10.0;
        if (maxX - this.point.x < localMargin) {
            maxX = this.point.x + localMargin;
        }
        if ((maxY = maxArea.y + maxArea.height) - this.point.y < localMargin) {
            maxY = this.point.y + localMargin;
        }
        Point2D.Double size = new Point2D.Double(maxX - this.point.x, maxY - this.point.y);
        double innerRound = this.R - this.thickness;
        if (innerRound < 0.0) {
            innerRound = 0.0;
        }
        this.setShape((GeneralPath)this.outerShape, this.point.x, this.point.y, size.x, size.y, this.R);
        this.setShape((GeneralPath)this.innerShape, this.point.x + this.thickness, this.point.y + this.thickness, size.x - this.thickness, size.y - this.thickness, innerRound);
        this.setLine((GeneralPath)this.outerLine, this.point.x, this.point.y, size.x, size.y, this.R);
        this.setLine((GeneralPath)this.innerLine, this.point.x + this.thickness, this.point.y + this.thickness, size.x - this.thickness, size.y - this.thickness, innerRound);
        this.updateMembraneArea();
        int linewidth = 2 + (int)((BasicStroke)this.outerStroke).getLineWidth();
        return new Rectangle2D.Double(this.point.x - (double)(linewidth /= 2), this.point.y - (double)linewidth, size.x + (double)linewidth, size.y + (double)linewidth);
    }

    private void setShape(GeneralPath path, double X, double Y, double W, double H, double R) {
        float x = (float)X;
        float y = (float)Y;
        float w = (float)W;
        float h = (float)H;
        float r = (float)R;
        path.reset();
        path.moveTo(x + w, y);
        path.lineTo(x + r, y);
        path.quadTo(x, y, x, y + r);
        path.lineTo(x, y + h);
        path.lineTo(x + w, y + h);
        path.closePath();
    }

    private void setLine(GeneralPath path, double X, double Y, double W, double H, double R) {
        float x = (float)X;
        float y = (float)Y;
        float w = (float)W;
        float h = (float)H;
        float r = (float)R;
        path.reset();
        path.moveTo(x + w, y);
        path.lineTo(x + r, y);
        path.quadTo(x, y, x, y + r);
        path.lineTo(x, y + h);
    }

    @Override
    public GPointedShape createCopy() {
        return new CompartmentSquareNW();
    }

    @Override
    public double getDefaultAngle() {
        return Math.PI;
    }
}

