/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.compartment;

import java.awt.BasicStroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GPointedShape;
import jp.sbi.celldesigner.symbol.compartment.OpenedCompartment;

public class CompartmentSquareN
extends OpenedCompartment {
    public static final String CODENAME = "SQUARE_CLOSEUP_NORTH";
    public static final double defaultAngle = 4.71238898038469;

    public CompartmentSquareN() {
        this.initialize();
        this.outerShape = new Rectangle2D.Double();
        this.innerShape = new Rectangle2D.Double();
        this.outerLine = new Line2D.Double();
        this.innerLine = new Line2D.Double();
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int getHandleLocation() {
        return 5;
    }

    @Override
    public Rectangle2D.Double updateShape(double x, double y, Rectangle2D.Double maxArea) {
        if (maxArea == null) {
            return null;
        }
        if (this.point == null) {
            this.point = new Point2D.Double();
        }
        this.point.x = x;
        this.point.y = y;
        double maxY = maxArea.y + maxArea.height;
        if (maxY - this.point.y < 50.0) {
            maxY = this.point.y + 50.0;
        }
        Point2D.Double size = new Point2D.Double(maxArea.width, maxY - this.point.y);
        ((Rectangle2D)this.outerShape).setFrame(maxArea.x, this.point.y, size.x, size.y);
        ((Rectangle2D)this.innerShape).setFrame(maxArea.x, this.point.y + this.thickness, size.x, size.y - this.thickness);
        ((Line2D)this.outerLine).setLine(maxArea.x, this.point.y, maxArea.x + maxArea.width, this.point.y);
        ((Line2D)this.innerLine).setLine(maxArea.x, this.point.y + this.thickness, maxArea.x + maxArea.width, this.point.y + this.thickness);
        this.updateMembraneArea();
        int linewidth = 2 + (int)((BasicStroke)this.outerStroke).getLineWidth();
        return new Rectangle2D.Double(maxArea.x, this.point.y - (double)(linewidth /= 2), size.x, size.y + (double)linewidth);
    }

    @Override
    public GPointedShape createCopy() {
        return new CompartmentSquareN();
    }

    @Override
    public double getDefaultAngle() {
        return 4.71238898038469;
    }
}

