/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.compartment;

import java.awt.BasicStroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GPointedShape;
import jp.sbi.celldesigner.symbol.compartment.OpenedCompartment;

public class CompartmentSquareE
extends OpenedCompartment {
    public static final String CODENAME = "SQUARE_CLOSEUP_EAST";
    public static final double defaultAngle = 0.0;

    public CompartmentSquareE() {
        this.initialize();
        this.outerShape = new Rectangle2D.Double();
        this.innerShape = new Rectangle2D.Double();
        this.outerLine = new Line2D.Double();
        this.innerLine = new Line2D.Double();
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int getHandleLocation() {
        return 6;
    }

    @Override
    public Rectangle2D.Double updateShape(double x, double y, Rectangle2D.Double maxArea) {
        if (maxArea == null) {
            return null;
        }
        if (this.point == null) {
            this.point = new Point2D.Double();
        }
        this.point.x = x;
        this.point.y = y;
        double minX = maxArea.x;
        if (this.point.x - minX < 50.0) {
            minX = this.point.x - 50.0;
        }
        Point2D.Double size = new Point2D.Double(this.point.x - minX, maxArea.height);
        ((Rectangle2D)this.outerShape).setFrame(minX, maxArea.y, size.x, size.y);
        ((Rectangle2D)this.innerShape).setFrame(minX, maxArea.y, size.x - this.thickness, size.y);
        ((Line2D)this.outerLine).setLine(this.point.x, maxArea.y, this.point.x, maxArea.y + maxArea.height);
        ((Line2D)this.innerLine).setLine(this.point.x - this.thickness, maxArea.y, this.point.x - this.thickness, maxArea.y + maxArea.height);
        this.updateMembraneArea();
        int linewidth = 2 + (int)((BasicStroke)this.outerStroke).getLineWidth();
        return new Rectangle2D.Double(minX, maxArea.y, size.x + (double)(linewidth /= 2), size.y);
    }

    @Override
    public GPointedShape createCopy() {
        return new CompartmentSquareE();
    }

    @Override
    public double getDefaultAngle() {
        return 0.0;
    }
}

