/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.color;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import jp.fric.graphics.draw.ColorPaint;
import jp.fric.graphics.draw.PaintScheme;

public class SpeciesColorScheme {
    protected static HashMap codeToColor = new HashMap();
    protected static HashMap codeToPainter = new HashMap();
    protected static HashMap codeToLineWidth = new HashMap();
    protected static HashMap codeToIndex = new HashMap();
    protected static String packageName = "jp.sbi.celldesigner.symbol.species";
    protected static final String[] ClassNames = new String[]{"Generic", "Receptor", "IonChannel", "Truncated", "Gene", "RNA", "AntiSenseRNA", "Phenotype", "Ion", "SimpleMolecule", "Drug", "Unknown", "Tag", "Complex", "ComplexBrief", "GeneralBrief", "Degraded"};
    protected static final Color[] DefaultColors = new Color[]{new Color(204, 255, 204, 255), new Color(255, 255, 204, 255), new Color(204, 255, 255, 255), new Color(255, 204, 204, 255), new Color(255, 255, 102, 255), new Color(102, 255, 102, 255), new Color(255, 102, 102, 255), new Color(204, 153, 255, 255), new Color(153, 153, 255, 255), new Color(204, 255, 102, 255), new Color(255, 0, 255, 255), new Color(204, 204, 204, 127), new Color(0, 255, 150, 255), new Color(247, 247, 247, 255), new Color(247, 247, 247, 255), new Color(255, 0, 0, 63), new Color(255, 204, 204, 255)};
    protected static final PaintScheme[] DefaultPainters = new PaintScheme[]{new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint()};
    protected static final Double[] DefaultLineWidths = new Double[]{new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0)};
    protected static final Color unpecifiedColor = new Color(127, 127, 127);
    protected static final PaintScheme unspecifiedScheme = new ColorPaint();
    protected static final Double unspecifiedLineWidth = new Double(1.0);

    static {
        SpeciesColorScheme.initialize();
    }

    public static void initialize() {
        int i = 0;
        while (i < ClassNames.length) {
            try {
                Class<?> cl = Class.forName(String.valueOf(packageName) + "." + ClassNames[i]);
                Field fd = cl.getField("CODENAME");
                String code = (String)fd.get(null);
                codeToColor.put(code, DefaultColors[i]);
                codeToPainter.put(code, DefaultPainters[i]);
                codeToLineWidth.put(code, DefaultLineWidths[i]);
                codeToIndex.put(code, new Integer(i));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void setColor(String code, Color color) {
        codeToColor.put(code, color);
    }

    public static Color getColor(String code) {
        Color color = (Color)codeToColor.get(code);
        if (color == null) {
            color = unpecifiedColor;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static Color getDefaultColor(String code) {
        int index = (Integer)codeToIndex.get(code);
        Color color = DefaultColors[index];
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static Color resetColor(String code) {
        int index = (Integer)codeToIndex.get(code);
        codeToColor.put(code, DefaultColors[index]);
        Color color = DefaultColors[index];
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static void setScheme(String code, PaintScheme scheme) {
        codeToPainter.put(code, scheme);
    }

    public static PaintScheme getScheme(String code) {
        PaintScheme scheme = (PaintScheme)codeToPainter.get(code);
        if (scheme == null) {
            scheme = unspecifiedScheme;
        }
        try {
            scheme = (PaintScheme)scheme.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return scheme;
    }

    public static PaintScheme getDefaultScheme(String code) {
        int index = (Integer)codeToIndex.get(code);
        try {
            return (PaintScheme)DefaultPainters[index].getClass().newInstance();
        }
        catch (Exception e) {
            return unspecifiedScheme;
        }
    }

    public static PaintScheme resetScheme(String code) {
        int index = (Integer)codeToIndex.get(code);
        codeToPainter.put(code, DefaultPainters[index]);
        try {
            return (PaintScheme)DefaultPainters[index].getClass().newInstance();
        }
        catch (Exception e) {
            return unspecifiedScheme;
        }
    }

    public static void setLineWidth(String code, double lineWidth) {
        codeToLineWidth.put(code, new Double(lineWidth));
    }

    public static double getLineWidth(String code) {
        Double width = (Double)codeToLineWidth.get(code);
        if (width == null) {
            width = unspecifiedLineWidth;
        }
        return width;
    }

    public static double getDefaultLineWidth(String code) {
        int index = (Integer)codeToIndex.get(code);
        return DefaultLineWidths[index];
    }

    public static double resetLineWidth(String code) {
        int index = (Integer)codeToIndex.get(code);
        codeToLineWidth.put(code, DefaultLineWidths[index]);
        return DefaultLineWidths[index];
    }

    public static String serialize() {
        Object[] codes = codeToColor.keySet().toArray();
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        int i = 0;
        while (i < codes.length) {
            Color color = (Color)codeToColor.get(codes[i]);
            PaintScheme scheme = (PaintScheme)codeToPainter.get(codes[i]);
            Double width = (Double)codeToLineWidth.get(codes[i]);
            try {
                bw.write(String.valueOf((String)codes[i]) + " ");
                bw.write(String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha());
                bw.write("," + scheme.getClass().getName());
                bw.write("," + width.toString());
                if (i != codes.length - 1) {
                    bw.newLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        try {
            bw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

