/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.color;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.HashMap;

public class ReactionColorScheme {
    protected static HashMap codeToColor = new HashMap();
    protected static HashMap codeToLineWidth = new HashMap();
    protected static HashMap codeToIndex = new HashMap();
    protected static HashMap codeToLineType = new HashMap();
    protected static String packageName = "jp.sbi.celldesigner.symbol.reaction";
    protected static final String[] ClassNames = new String[]{"StateTransition", "KnownTransitionOmitted", "UnknownTransition", "Transcription", "Translation", "Transport", "DimerFormation", "Dissociation", "Truncation", "AddReactant", "AddProduct", "Catalysis", "UnknownCatalysis", "Inhibition", "UnknownInhibition", "PhysicalStimulation", "Modulation", "TranscriptionalActivation", "TranscriptionalInhibition", "TranslationalActivation", "TranslationalInhibition", "Trigger"};
    protected static final Color[] DefaultColors = new Color[]{new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(128, 128, 128, 255), new Color(128, 128, 128, 255), new Color(128, 128, 128, 255), new Color(128, 128, 128, 255), new Color(0, 0, 0, 255)};
    protected static final Double[] DefaultLineWidths = new Double[]{new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(4.0), new Double(4.0), new Double(4.0), new Double(4.0), new Double(1.0)};
    protected static final Integer[] DefaultLineTypes = new Integer[]{new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Integer(1)};
    protected static final Integer unspecifiedLineType = new Integer(1);
    protected static final Integer undefinedLineType = new Integer(1);
    protected static final Color unspecifiedColor = new Color(0, 0, 0);
    protected static final Color undefinedColor = new Color(0, 0, 0, 255);
    protected static final Double unspecifiedLineWidth = new Double(1.0);
    protected static final Double undefinedLineWidth = new Double(1.0);

    static {
        ReactionColorScheme.initialize();
    }

    public static void initialize() {
        int i = 0;
        while (i < ClassNames.length) {
            try {
                Class<?> cl = Class.forName(String.valueOf(packageName) + "." + ClassNames[i]);
                Field fd = cl.getField("CODENAME");
                String code = (String)fd.get(null);
                codeToColor.put(code, DefaultColors[i]);
                codeToLineWidth.put(code, DefaultLineWidths[i]);
                codeToIndex.put(code, new Integer(i));
                codeToLineType.put(code, DefaultLineTypes[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void setColor(String code, Color color) {
        codeToColor.put(code, color);
    }

    public static Color getColor(String code) {
        Color color = (Color)codeToColor.get(code);
        if (color == null) {
            color = unspecifiedColor;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static Color getDefaultColor(String code) {
        int index = (Integer)codeToIndex.get(code);
        Color color = DefaultColors[index];
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static Color resetColor(String code) {
        try {
            int index = (Integer)codeToIndex.get(code);
            codeToColor.put(code, DefaultColors[index]);
            Color color = DefaultColors[index];
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        catch (Exception e) {
            return undefinedColor;
        }
    }

    public static void setLineWidth(String code, double lineWidth) {
        codeToLineWidth.put(code, new Double(lineWidth));
    }

    public static double getLineWidth(String code) {
        Double width = (Double)codeToLineWidth.get(code);
        if (width == null) {
            width = unspecifiedLineWidth;
        }
        return width;
    }

    public static double getDefaultLineWidth(String code) {
        int index = (Integer)codeToIndex.get(code);
        return DefaultLineWidths[index];
    }

    public static double resetLineWidth(String code) {
        try {
            int index = (Integer)codeToIndex.get(code);
            codeToLineWidth.put(code, DefaultLineWidths[index]);
            return DefaultLineWidths[index];
        }
        catch (Exception e) {
            return undefinedLineWidth;
        }
    }

    public static void setLineType(String code, int lineType) {
        codeToLineType.put(code, new Integer(lineType));
    }

    public static int getLineType(String code) {
        Integer type = (Integer)codeToLineType.get(code);
        if (type == null) {
            type = unspecifiedLineType;
        }
        return type;
    }

    public static int getDefaultLineType(String code) {
        int index = (Integer)codeToIndex.get(code);
        return DefaultLineTypes[index];
    }

    public static int resetLineType(String code) {
        try {
            int index = (Integer)codeToIndex.get(code);
            codeToLineType.put(code, DefaultLineTypes[index]);
            return DefaultLineTypes[index];
        }
        catch (Exception e) {
            return undefinedLineType;
        }
    }

    public static String serialize() {
        Object[] codes = codeToColor.keySet().toArray();
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        int i = 0;
        while (i < codes.length) {
            Color color = (Color)codeToColor.get(codes[i]);
            Double width = (Double)codeToLineWidth.get(codes[i]);
            Integer type = (Integer)codeToLineType.get(codes[i]);
            try {
                bw.write(String.valueOf((String)codes[i]) + " ");
                bw.write(String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha());
                bw.write("," + width.toString());
                bw.write("," + type.toString());
                if (i != codes.length - 1) {
                    bw.newLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        try {
            bw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

