/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.symbol.color;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import jp.fric.graphics.draw.ColorPaint;
import jp.fric.graphics.draw.GradationPaint;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.symbol.compartment.Membrane;

public class CompartmentColorScheme {
    protected static HashMap codeToColor = new HashMap();
    protected static HashMap codeToPainter = new HashMap();
    protected static HashMap codeToMembrane = new HashMap();
    protected static HashMap codeToIndex = new HashMap();
    protected static String packageName = "jp.sbi.celldesigner.symbol.compartment";
    protected static final String[] ClassNames = new String[]{"CompartmentSquare", "CompartmentOval", "CompartmentSquareNW", "CompartmentSquareNE", "CompartmentSquareSW", "CompartmentSquareSE", "CompartmentSquareN", "CompartmentSquareE", "CompartmentSquareW", "CompartmentSquareS"};
    protected static final Color[] DefaultColors = new Color[]{new Color(204, 204, 0, 255), new Color(204, 204, 0, 255), new Color(204, 204, 0, 255), new Color(204, 204, 0, 255), new Color(204, 204, 0, 255), new Color(204, 204, 0, 255), new Color(204, 204, 0, 255), new Color(204, 204, 0, 255), new Color(204, 204, 0, 255), new Color(204, 204, 0, 255)};
    protected static final PaintScheme[] DefaultPainters = new PaintScheme[]{new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint(), new ColorPaint()};
    protected static final Membrane[] DefaultMembranes = new Membrane[]{new Membrane(12.0, 2.0, 1.0), new Membrane(12.0, 2.0, 1.0), new Membrane(12.0, 2.0, 1.0), new Membrane(12.0, 2.0, 1.0), new Membrane(12.0, 2.0, 1.0), new Membrane(12.0, 2.0, 1.0), new Membrane(12.0, 2.0, 1.0), new Membrane(12.0, 2.0, 1.0), new Membrane(12.0, 2.0, 1.0), new Membrane(12.0, 2.0, 1.0)};
    protected static final Color unpecifiedColor = new Color(0, 0, 0);
    protected static final PaintScheme unspecifiedScheme = new GradationPaint();
    protected static final Membrane unspecifiedMembrane = new Membrane(12.0, 2.0, 1.0);

    static {
        CompartmentColorScheme.initialize();
    }

    public static void initialize() {
        int i = 0;
        while (i < ClassNames.length) {
            try {
                Class<?> cl = Class.forName(String.valueOf(packageName) + "." + ClassNames[i]);
                Field fd = cl.getField("CODENAME");
                String code = (String)fd.get(null);
                codeToColor.put(code, DefaultColors[i]);
                codeToPainter.put(code, DefaultPainters[i]);
                codeToMembrane.put(code, DefaultMembranes[i]);
                codeToIndex.put(code, new Integer(i));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void setColor(String code, Color color) {
        codeToColor.put(code, color);
    }

    public static Color getColor(String code) {
        Color color = (Color)codeToColor.get(code);
        if (color == null) {
            color = unpecifiedColor;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static Color getDefaultColor(String code) {
        int index = (Integer)codeToIndex.get(code);
        Color color = DefaultColors[index];
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static Color resetColor(String code) {
        int index = (Integer)codeToIndex.get(code);
        codeToColor.put(code, DefaultColors[index]);
        Color color = DefaultColors[index];
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static void setScheme(String code, PaintScheme scheme) {
        codeToPainter.put(code, scheme);
    }

    public static PaintScheme getScheme(String code) {
        PaintScheme scheme = (PaintScheme)codeToPainter.get(code);
        if (scheme == null) {
            scheme = unspecifiedScheme;
        }
        try {
            scheme = (PaintScheme)scheme.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return scheme;
    }

    public static PaintScheme getDefaultScheme(String code) {
        int index = (Integer)codeToIndex.get(code);
        try {
            return (PaintScheme)DefaultPainters[index].getClass().newInstance();
        }
        catch (Exception e) {
            return unspecifiedScheme;
        }
    }

    public static PaintScheme resetScheme(String code) {
        int index = (Integer)codeToIndex.get(code);
        codeToPainter.put(code, DefaultPainters[index]);
        try {
            return (PaintScheme)DefaultPainters[index].getClass().newInstance();
        }
        catch (Exception e) {
            return unspecifiedScheme;
        }
    }

    public static void setMembrane(String code, Membrane m) {
        codeToMembrane.put(code, m);
    }

    public static Membrane getMembrane(String code) {
        Membrane m = (Membrane)codeToMembrane.get(code);
        if (m == null) {
            m = unspecifiedMembrane;
        }
        return new Membrane(m.getThickness(), m.getOuterLineWidth(), m.getInnerLineWidth());
    }

    public static Membrane getDefaultMembrane(String code) {
        int index = (Integer)codeToIndex.get(code);
        Membrane m = DefaultMembranes[index];
        return new Membrane(m.getThickness(), m.getOuterLineWidth(), m.getInnerLineWidth());
    }

    public static Membrane resetMembrane(String code) {
        int index = (Integer)codeToIndex.get(code);
        codeToMembrane.put(code, DefaultMembranes[index]);
        Membrane m = DefaultMembranes[index];
        return new Membrane(m.getThickness(), m.getOuterLineWidth(), m.getInnerLineWidth());
    }

    public static String serialize() {
        Object[] codes = codeToColor.keySet().toArray();
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        int i = 0;
        while (i < codes.length) {
            Color color = (Color)codeToColor.get(codes[i]);
            PaintScheme scheme = (PaintScheme)codeToPainter.get(codes[i]);
            Membrane membrane = (Membrane)codeToMembrane.get(codes[i]);
            try {
                bw.write(String.valueOf((String)codes[i]) + " ");
                bw.write(String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha());
                bw.write("," + scheme.getClass().getName());
                bw.write("," + membrane.toString());
                if (i != codes.length - 1) {
                    bw.newLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        try {
            bw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

