/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.soslib;

import java.io.IOException;
import jp.co.mki.celldesigner.simulation.CvodeResults;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.TimeCourse;
import jp.sbi.celldesigner.soslib.SOSlibException;
import org.sbml.soslib._SBMLResults;
import org.sbml.soslib._SBMLResultsArray;
import org.sbml.soslib.cvodeSettings;
import org.sbml.soslib.soslib;
import org.sbml.soslib.timeCourse;
import org.sbml.soslib.timeCourseArray;
import org.sbml.soslib.varySettings;

public class SOSlib {
    static boolean isDebug = false;

    static {
        System.loadLibrary("SOSlibJava");
    }

    public static void main(String[] args) {
        String[] cvodeSet = new String[15];
        String inputFileName = "test.xml";
        String endTime = "10000";
        String printStep = "10";
        String relativeTolerance = "1e-10";
        cvodeSet[0] = "dummy";
        cvodeSet[1] = inputFileName;
        cvodeSet[2] = endTime;
        cvodeSet[3] = printStep;
        cvodeSet[4] = relativeTolerance;
        System.out.println("========== solveOde2 ==========");
        try {
            SBMLResults sbmlResults = SOSlib.solveOde2(cvodeSet);
            sbmlResults.outputFile("test_result_solveode2.txt");
        }
        catch (IOException sbmlResults) {
        }
        catch (SOSlibException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        String reactionId1 = "J0";
        String localParaId = "V1";
        String designPoints1 = "10";
        String startPVal1 = "1";
        String endPVal1 = "10";
        cvodeSet[5] = reactionId1;
        cvodeSet[6] = localParaId;
        cvodeSet[7] = designPoints1;
        cvodeSet[8] = startPVal1;
        cvodeSet[9] = endPVal1;
        System.out.println("========== solveOde3 ==========");
        try {
            SOSlib.solveOde3(cvodeSet);
        }
        catch (SOSlibException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        String notreaction = "";
        String initValId = "MKKK";
        String designPoints2 = "10";
        String startPVal2 = "50";
        String endPVal2 = "100";
        cvodeSet[10] = notreaction;
        cvodeSet[11] = initValId;
        cvodeSet[12] = designPoints2;
        cvodeSet[13] = startPVal2;
        cvodeSet[14] = endPVal2;
        System.out.println("========== solveOde4 ==========");
        try {
            SOSlib.solveOde4(cvodeSet);
        }
        catch (SOSlibException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public static CvodeResults solveOde(String[] args) {
        return null;
    }

    public static SBMLResults solveOde2(String[] args) throws SOSlibException {
        String filename = args[1];
        double endTime = Double.valueOf(args[2]);
        int printStep = Double.valueOf(args[3]).intValue();
        double relativeError = Double.valueOf(args[4]);
        cvodeSettings cvodeSet = soslib.CvodeSettings_create();
        soslib.CvodeSettings_setRError((cvodeSettings)cvodeSet, (double)relativeError);
        soslib.CvodeSettings_setTime((cvodeSettings)cvodeSet, (double)endTime, (int)printStep);
        _SBMLResults sbmlResult = soslib.s_odeSolver2((String)filename, (cvodeSettings)cvodeSet);
        soslib.CvodeSettings_free((cvodeSettings)cvodeSet);
        if (soslib.SolverError_getNum((int)soslib.FATAL_ERROR_TYPE) > 0 || soslib.SolverError_getNum((int)soslib.ERROR_ERROR_TYPE) > 0) {
            System.err.println("Simulation failed!!");
            String errMsg = SOSlib.getErrorMessages();
            soslib.SolverError_clear();
            soslib.SBMLResults_free((_SBMLResults)sbmlResult);
            throw new SOSlibException(errMsg);
        }
        if (sbmlResult == null) {
            throw new SOSlibException("[solveOde2] No _SBMLResults.");
        }
        if (isDebug) {
            System.out.println("### solveOde2 RESULTS");
            SOSlib.printSBMLResults(sbmlResult);
        }
        SBMLResults newSBMLResults = SOSlib.convertToSBMLResults(sbmlResult);
        soslib.SBMLResults_free((_SBMLResults)sbmlResult);
        return newSBMLResults;
    }

    public static Object[] solveOde3(String[] args) throws SOSlibException {
        String filename = args[1];
        double endTime = Double.valueOf(args[2]);
        int printStep = Double.valueOf(args[3]).intValue();
        double relativeError = Double.valueOf(args[4]);
        String rid = args[5];
        String id = args[6];
        double startVal = Double.valueOf(args[7]);
        double endVal = Double.valueOf(args[8]);
        int designPoint = Double.valueOf(args[9]).intValue();
        int vnum = designPoint + 1;
        cvodeSettings cvodeSet = soslib.CvodeSettings_create();
        soslib.CvodeSettings_setRError((cvodeSettings)cvodeSet, (double)relativeError);
        soslib.CvodeSettings_setTime((cvodeSettings)cvodeSet, (double)endTime, (int)printStep);
        varySettings varySet = soslib.VarySettings_allocate((int)1, (int)vnum);
        soslib.VarySettings_addParameter((varySettings)varySet, (String)id, (String)rid);
        double[] val = new double[]{0.0};
        int i = 0;
        while (i < vnum) {
            val[0] = startVal + (double)i * (endVal - startVal) / (double)designPoint;
            soslib.VarySettings_addDesignPoint((varySettings)varySet, (double[])val);
            ++i;
        }
        _SBMLResultsArray sbmlResults = soslib.s_odeSolver3((String)filename, (cvodeSettings)cvodeSet, (varySettings)varySet);
        soslib.CvodeSettings_free((cvodeSettings)cvodeSet);
        if (soslib.SolverError_getNum((int)soslib.FATAL_ERROR_TYPE) > 0 || soslib.SolverError_getNum((int)soslib.ERROR_ERROR_TYPE) > 0) {
            System.err.println("Simulation failed!!");
            String errMsg = SOSlib.getErrorMessages();
            soslib.SolverError_clear();
            int i2 = 0;
            while (i2 < vnum) {
                _SBMLResults sbmlResult = soslib.SBMLResultsArray_getResults((_SBMLResultsArray)sbmlResults, (int)i2);
                soslib.SBMLResults_free((_SBMLResults)sbmlResult);
                ++i2;
            }
            throw new SOSlibException(errMsg);
        }
        if (sbmlResults == null) {
            throw new SOSlibException("[solveOde3] No _SBMLResultsArray.");
        }
        if (isDebug) {
            System.out.println("### solveOde3 RESULTS");
        }
        Object[] newSBMLResultsArray = new SBMLResults[vnum];
        int i3 = 0;
        while (i3 < vnum) {
            if (isDebug) {
                System.out.print("### " + id);
                if (rid != null) {
                    System.out.print(":" + rid);
                }
                System.out.println(" -> " + soslib.VarySettings_getValue((varySettings)varySet, (int)i3, (int)0));
            }
            _SBMLResults sbmlResult = soslib.SBMLResultsArray_getResults((_SBMLResultsArray)sbmlResults, (int)i3);
            if (isDebug) {
                SOSlib.printSBMLResults(sbmlResult);
            }
            newSBMLResultsArray[i3] = SOSlib.convertToSBMLResults(sbmlResult);
            soslib.SBMLResults_free((_SBMLResults)sbmlResult);
            ++i3;
        }
        return newSBMLResultsArray;
    }

    public static Object[] solveOde4(String[] args) throws SOSlibException {
        String filename = args[1];
        double endTime = Double.valueOf(args[2]);
        int printStep = Double.valueOf(args[3]).intValue();
        double relativeError = Double.valueOf(args[4]);
        String rid = args[5];
        String id = args[6];
        double startVal = Double.valueOf(args[7]);
        double endVal = Double.valueOf(args[8]);
        int designPoint = Double.valueOf(args[9]).intValue();
        int vnum = designPoint + 1;
        String rid2 = args[10];
        String id2 = args[11];
        double startVal2 = Double.valueOf(args[12]);
        double endVal2 = Double.valueOf(args[13]);
        int designPoint2 = Double.valueOf(args[14]).intValue();
        int vnum2 = designPoint2 + 1;
        cvodeSettings cvodeSet = soslib.CvodeSettings_create();
        soslib.CvodeSettings_setRError((cvodeSettings)cvodeSet, (double)relativeError);
        soslib.CvodeSettings_setTime((cvodeSettings)cvodeSet, (double)endTime, (int)printStep);
        varySettings varySet = soslib.VarySettings_allocate((int)2, (int)(vnum * vnum2));
        soslib.VarySettings_addParameter((varySettings)varySet, (String)id, (String)rid);
        soslib.VarySettings_addParameter((varySettings)varySet, (String)id2, (String)rid2);
        double[] val = new double[2];
        int i = 0;
        while (i < vnum) {
            val[0] = startVal + (double)i * (endVal - startVal) / (double)designPoint;
            int j = 0;
            while (j < vnum2) {
                val[1] = startVal2 + (double)j * (endVal2 - startVal2) / (double)designPoint2;
                soslib.VarySettings_addDesignPoint((varySettings)varySet, (double[])val);
                ++j;
            }
            ++i;
        }
        _SBMLResultsArray sbmlResults = soslib.s_odeSolver4((String)filename, (cvodeSettings)cvodeSet, (varySettings)varySet);
        soslib.CvodeSettings_free((cvodeSettings)cvodeSet);
        if (soslib.SolverError_getNum((int)soslib.FATAL_ERROR_TYPE) > 0 || soslib.SolverError_getNum((int)soslib.ERROR_ERROR_TYPE) > 0) {
            System.err.println("Simulation failed!!");
            String errMsg = SOSlib.getErrorMessages();
            soslib.SolverError_clear();
            int i2 = 0;
            while (i2 < vnum) {
                int j = 0;
                while (j < vnum2) {
                    _SBMLResults sbmlResult = soslib.SBMLResultsArray_getResults((_SBMLResultsArray)sbmlResults, (int)(i2 * vnum2 + j));
                    soslib.SBMLResults_free((_SBMLResults)sbmlResult);
                    ++j;
                }
                ++i2;
            }
            throw new SOSlibException(errMsg);
        }
        if (sbmlResults == null) {
            throw new SOSlibException("[solveOde4] No _SBMLResultsArray.");
        }
        if (isDebug) {
            System.out.println("### solveOde4 RESULTS");
        }
        Object[] newSBMLResultsArrayMatrix = new Object[vnum];
        int i3 = 0;
        while (i3 < vnum) {
            SBMLResults[] newSBMLResultsArray = new SBMLResults[vnum2];
            int j = 0;
            while (j < vnum2) {
                if (isDebug) {
                    double p1dp = soslib.VarySettings_getValue((varySettings)varySet, (int)i3, (int)0);
                    double p2dp = soslib.VarySettings_getValue((varySettings)varySet, (int)j, (int)1);
                    System.out.print("### para1 [" + id + "] " + p1dp + " para2 [" + id2 + "] " + p2dp);
                    System.out.print("### reac1 [");
                    if (rid != null) {
                        System.out.print(rid);
                    }
                    System.out.print("] reac2 [");
                    if (rid2 != null) {
                        System.out.print(rid2);
                    }
                    System.out.print("]");
                    System.out.println();
                }
                _SBMLResults sbmlResult = soslib.SBMLResultsArray_getResults((_SBMLResultsArray)sbmlResults, (int)(i3 * vnum2 + j));
                newSBMLResultsArray[j] = SOSlib.convertToSBMLResults(sbmlResult);
                if (isDebug) {
                    SOSlib.printSBMLResults(sbmlResult);
                }
                soslib.SBMLResults_free((_SBMLResults)sbmlResult);
                ++j;
            }
            newSBMLResultsArrayMatrix[i3] = newSBMLResultsArray;
            ++i3;
        }
        return newSBMLResultsArrayMatrix;
    }

    public static synchronized String getErrorMessages() {
        String msg = "";
        int numfatal = soslib.SolverError_getNum((int)soslib.FATAL_ERROR_TYPE);
        int numerror = soslib.SolverError_getNum((int)soslib.ERROR_ERROR_TYPE);
        int numwarn = soslib.SolverError_getNum((int)soslib.WARNING_ERROR_TYPE);
        int i = 0;
        while (i < numfatal) {
            msg = String.valueOf(msg) + "[Fatal ";
            msg = String.valueOf(msg) + soslib.SolverError_getCode((int)soslib.FATAL_ERROR_TYPE, (int)i) + "(" + SOSlib.getErrorCategoryString(soslib.SolverError_getCode((int)soslib.FATAL_ERROR_TYPE, (int)i)) + ")] ";
            msg = String.valueOf(msg) + soslib.SolverError_getMessage((int)soslib.FATAL_ERROR_TYPE, (int)i) + "\n";
            ++i;
        }
        i = 0;
        while (i < numerror) {
            msg = String.valueOf(msg) + "[Error ";
            msg = String.valueOf(msg) + soslib.SolverError_getCode((int)soslib.ERROR_ERROR_TYPE, (int)i) + "(" + SOSlib.getErrorCategoryString(soslib.SolverError_getCode((int)soslib.ERROR_ERROR_TYPE, (int)i)) + ")] ";
            msg = String.valueOf(msg) + soslib.SolverError_getMessage((int)soslib.ERROR_ERROR_TYPE, (int)i) + "\n";
            ++i;
        }
        i = 0;
        while (i < numwarn) {
            msg = String.valueOf(msg) + "[Warning ";
            msg = String.valueOf(msg) + soslib.SolverError_getCode((int)soslib.WARNING_ERROR_TYPE, (int)i) + "(" + SOSlib.getErrorCategoryString(soslib.SolverError_getCode((int)soslib.WARNING_ERROR_TYPE, (int)i)) + ")] ";
            msg = String.valueOf(msg) + soslib.SolverError_getMessage((int)soslib.WARNING_ERROR_TYPE, (int)i) + "\n";
            ++i;
        }
        return msg;
    }

    public static String getErrorCategoryString(int errcode) {
        if (errcode >= 100000) {
            return "Solver";
        }
        if (errcode >= 10000) {
            return "SBML";
        }
        if (errcode >= 0) {
            return "XML";
        }
        return "CVODE";
    }

    public static void printSBMLResults(_SBMLResults result) {
        if (result == null) {
            return;
        }
        timeCourse time = soslib.SBMLResults_getTime((_SBMLResults)result);
        timeCourseArray tcSpecies = result.getSpecies();
        timeCourseArray tcCompartments = result.getCompartments();
        timeCourseArray tcParameters = result.getParameters();
        timeCourseArray tcFluxes = result.getFluxes();
        System.out.println("# Printing Species time courses");
        SOSlib.printTimeCourseArray(tcSpecies, time);
        System.out.println("# Printing Compartments time courses");
        SOSlib.printTimeCourseArray(tcCompartments, time);
        System.out.println("# Printing Parameters time courses");
        SOSlib.printTimeCourseArray(tcParameters, time);
        System.out.println("# Printing Fluxes time courses");
        SOSlib.printTimeCourseArray(tcFluxes, time);
        System.out.println();
    }

    public static void printTimeCourseArray(timeCourseArray tca, timeCourse time) {
        if (tca == null) {
            return;
        }
        if (tca.getNum_val() == 0) {
            return;
        }
        System.out.print("#time ");
        int timePoints = time.getTimepoints();
        int numNames = tca.getNum_val();
        int i = 0;
        while (i < numNames) {
            String nameSpecies = soslib.TimeCourseArray_getTimeCourse((timeCourseArray)tca, (int)i).getName();
            System.out.print(String.valueOf(nameSpecies) + " ");
            ++i;
        }
        System.out.println();
        int t = 0;
        while (t < timePoints) {
            System.out.print(String.valueOf(soslib.TimeCourse_getValue((timeCourse)time, (int)t)) + " ");
            int i2 = 0;
            while (i2 < numNames) {
                timeCourse tc = soslib.TimeCourseArray_getTimeCourse((timeCourseArray)tca, (int)i2);
                double value = soslib.TimeCourse_getValue((timeCourse)tc, (int)t);
                System.out.print(String.valueOf(value) + " ");
                ++i2;
            }
            System.out.println();
            ++t;
        }
    }

    public static TimeCourse convertToTimeCourse(timeCourseArray tca, int timePoints) {
        if (tca == null) {
            return null;
        }
        if (tca.getNum_val() == 0) {
            return null;
        }
        int numVal = tca.getNum_val();
        TimeCourse newTimeCourse = new TimeCourse(timePoints, numVal);
        String[] names = new String[numVal];
        int i = 0;
        while (i < numVal) {
            timeCourse tc = soslib.TimeCourseArray_getTimeCourse((timeCourseArray)tca, (int)i);
            names[i] = tc.getName();
            int t = 0;
            while (t < timePoints) {
                double value = soslib.TimeCourse_getValue((timeCourse)tc, (int)t);
                newTimeCourse.setValues(t, i, value);
                ++t;
            }
            ++i;
        }
        newTimeCourse.setNames(names);
        return newTimeCourse;
    }

    public static SBMLResults convertToSBMLResults(_SBMLResults result) {
        if (result == null) {
            return null;
        }
        timeCourse tc = result.getTime();
        int timepoints = tc.getTimepoints();
        double[] times = new double[timepoints];
        int t = 0;
        while (t < timepoints) {
            times[t] = soslib.TimeCourse_getValue((timeCourse)tc, (int)t);
            ++t;
        }
        SBMLResults newSBMLResults = new SBMLResults(timepoints, times);
        timeCourseArray tca = result.getSpecies();
        newSBMLResults.setSpecies(SOSlib.convertToTimeCourse(tca, timepoints));
        tca = result.getCompartments();
        newSBMLResults.setCompartments(SOSlib.convertToTimeCourse(tca, timepoints));
        tca = result.getParameters();
        newSBMLResults.setParameters(SOSlib.convertToTimeCourse(tca, timepoints));
        tca = result.getFluxes();
        newSBMLResults.setFluxes(SOSlib.convertToTimeCourse(tca, timepoints));
        return newSBMLResults;
    }
}

