/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.simulationcore;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.sbi.celldesigner.simulation.ExecuteSolver;
import jp.sbi.sbml.util.Preference;
import org.apache.commons.math.ode.DerivativeException;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.LocalParameter;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.validator.ModelOverdeterminedException;
import org.sbml.jsbml.xml.stax.SBMLReader;
import org.simulator.math.odes.AbstractDESSolver;
import org.simulator.math.odes.DESystem;
import org.simulator.math.odes.MultiTable;
import org.simulator.math.odes.RosenbrockSolver;
import org.simulator.sbml.SBMLinterpreter;

public class ExecuteSimulationCore
extends ExecuteSolver {
    private String[] args;
    private int solverType;
    public static final int NORMAL_SOLVER = 0;
    public static final int PARAMETER_SCAN1 = 1;
    public static final int PARAMETER_SCAN2 = 2;
    private AbstractDESSolver solver;
    private SBMLinterpreter interpreter;
    private Model model;
    private ListOf<Species> los;
    private double timeEnd;

    public ExecuteSimulationCore(String[] args, int solverType) {
        this.solverType = solverType;
        this.args = args;
        String fileName = args[1];
        this.timeEnd = Double.valueOf(args[2]);
        double stepSize = this.timeEnd / Double.valueOf(args[3]);
        if (Preference.isDebug) {
            System.err.println("Stepsize: " + stepSize);
        }
        try {
            this.model = new SBMLReader().readSBML(fileName).getModel();
            this.los = this.model.getListOfSpecies();
            this.solver = new RosenbrockSolver();
            this.solver.setStepSize(stepSize);
            this.interpreter = new SBMLinterpreter(this.model);
            this.solver.setStepSize(stepSize);
            if (this.solver instanceof AbstractDESSolver) {
                this.solver.setIncludeIntermediates(false);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (ModelOverdeterminedException e) {
            e.printStackTrace();
        }
        catch (SBMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            if (this.solverType == 0) {
                MultiTable solution = this.solver.solve((DESystem)this.interpreter, this.interpreter.getInitialValues(), 0.0, this.timeEnd);
                this.results = new SBMLResults(solution, this.los);
                this.isEnd = true;
            } else if (this.solverType == 1) {
                String rid = this.args[5];
                String id = this.args[6];
                double startVal = Double.valueOf(this.args[7]);
                double endVal = Double.valueOf(this.args[8]);
                int designPoint = Double.valueOf(this.args[9]).intValue();
                int vnum = designPoint + 1;
                SBMLResults[] newSBMLResultsArray = new SBMLResults[vnum];
                int i = 0;
                while (i < vnum) {
                    double val = startVal + (double)i * (endVal - startVal) / (double)designPoint;
                    this.setParameterOrInitialConcentration(rid, id, val);
                    this.interpreter = new SBMLinterpreter(this.model);
                    MultiTable solution = this.solver.solve((DESystem)this.interpreter, this.interpreter.getInitialValues(), 0.0, this.timeEnd);
                    newSBMLResultsArray[i] = this.results = new SBMLResults(solution, this.los);
                    ++i;
                }
                this.listOfResults = newSBMLResultsArray;
            } else if (this.solverType == 2) {
                String rid = this.args[5];
                String id = this.args[6];
                double startVal = Double.valueOf(this.args[7]);
                double endVal = Double.valueOf(this.args[8]);
                int designPoint = Double.valueOf(this.args[9]).intValue();
                int vnum = designPoint + 1;
                String rid2 = this.args[10];
                String id2 = this.args[11];
                double startVal2 = Double.valueOf(this.args[12]);
                double endVal2 = Double.valueOf(this.args[13]);
                int designPoint2 = Double.valueOf(this.args[14]).intValue();
                int vnum2 = designPoint2 + 1;
                Object[] newSBMLResultsArrayMatrix = new Object[vnum];
                int i = 0;
                while (i < vnum) {
                    SBMLResults[] newSBMLResultsArray = new SBMLResults[vnum2];
                    double val = startVal + (double)i * (endVal - startVal) / (double)designPoint;
                    this.setParameterOrInitialConcentration(rid, id, val);
                    int j = 0;
                    while (j < vnum2) {
                        double val2 = startVal2 + (double)j * (endVal2 - startVal2) / (double)designPoint2;
                        this.setParameterOrInitialConcentration(rid2, id2, val2);
                        this.interpreter = new SBMLinterpreter(this.model);
                        MultiTable solution = this.solver.solve((DESystem)this.interpreter, this.interpreter.getInitialValues(), 0.0, this.timeEnd);
                        newSBMLResultsArray[j] = this.results = new SBMLResults(solution, this.los);
                        ++j;
                    }
                    newSBMLResultsArrayMatrix[i] = newSBMLResultsArray;
                    ++i;
                }
                this.listOfResults = newSBMLResultsArrayMatrix;
            }
        }
        catch (DerivativeException e) {
            this.errMsg = e.getMessage();
        }
        catch (ModelOverdeterminedException e) {
            e.printStackTrace();
        }
        catch (SBMLException e) {
            e.printStackTrace();
        }
        this.isEnd = true;
    }

    private boolean setParameterOrInitialConcentration(String rid, String id, double val) {
        if (rid.equals("")) {
            return this.setInitialConcentration(id, val);
        }
        return this.setParameterValue(rid, id, val);
    }

    private boolean setInitialConcentration(String id, double val) {
        Species s = (Species)this.los.get(id);
        if (s != null) {
            s.setInitialConcentration(val);
            return true;
        }
        return false;
    }

    private boolean setParameterValue(String rid, String id, double val) {
        LocalParameter lp = this.getLocalParameter(rid, id);
        if (lp != null) {
            lp.setValue(val);
            return true;
        }
        Parameter p = this.model.getParameter(id);
        if (p != null) {
            p.setValue(val);
            return true;
        }
        return false;
    }

    private LocalParameter getLocalParameter(String rid, String id) {
        ListOf lor = this.model.getListOfReactions();
        Reaction r = (Reaction)lor.get(rid);
        if (r != null) {
            return (LocalParameter)r.getKineticLaw().getListOfLocalParameters().get(id);
        }
        return null;
    }
}

