/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.sbmlExtension;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import jp.sbi.celldesigner.plugin.PluginStructuralState;
import jp.sbi.celldesigner.sbmlExtension.ModificationImpl;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;

public class StructuralState
implements ModificationImpl {
    public static final String STR_EMPTY = "empty";
    public static final String STR_OPEN = "open";
    public static final String STR_CLOSED = "closed";
    public static final String STR_USER_DEFINED = "user defined text";
    public static final String STR_ACTIVED = "Active";
    private String state = "";
    public static final double StructuralStateDEFAULT_ANGLE = 1.5707963267948966;
    private double angle = 1.5707963267948966;
    public static final double activedStateShowOnlyInSBGNViewerDEFAULT_ANGLE = 4.71238898038469;
    private boolean isAutoAddedInSBGNViewer = false;

    public StructuralState() {
        this.state = STR_EMPTY;
        this.angle = 1.5707963267948966;
        this.isAutoAddedInSBGNViewer = false;
    }

    public StructuralState(String state, double angle, boolean isAutoAddedInSBGNViewer) {
        this.state = state;
        this.angle = angle;
        this.isAutoAddedInSBGNViewer = isAutoAddedInSBGNViewer;
    }

    public boolean isAutoAddedInSBGNViewer() {
        return this.isAutoAddedInSBGNViewer;
    }

    public void setIsAutoAddedInSBGNViewer(boolean flg) {
        this.isAutoAddedInSBGNViewer = flg;
    }

    public Object clone() {
        StructuralState s = new StructuralState();
        s.setState(this.state);
        s.setAngle(this.angle);
        return s;
    }

    public void clone(PluginStructuralState pstate) {
        this.setState(pstate.getState());
        this.setAngle(pstate.getAngle());
    }

    public boolean equals(StructuralState target) {
        return target.getState().equals(this.state);
    }

    public static boolean isEmptyState(StructuralState target) {
        if (target == null) {
            return true;
        }
        if (target.getState() == null) {
            return true;
        }
        return target.getState().equals(STR_EMPTY);
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public Rectangle2D.Double getNameBounds(ModificationShape mShape, Graphics2D g2, Ellipse2D.Double ellipse, Rectangle2D.Double rect) {
        g2.setFont(ModificationShape.getStructuralStateInnerLableFont(g2));
        FontMetrics fmOutside = g2.getFontMetrics();
        if (this.state != null && !this.state.equals("")) {
            int w = fmOutside.stringWidth(this.state);
            int h = fmOutside.getAscent() - fmOutside.getDescent();
            int x = (int)(ellipse.getX() + (ellipse.getWidth() - (double)w) / 2.0);
            int y = (int)(ellipse.getY() + (ellipse.getHeight() + (double)h) / 2.0);
            return new Rectangle2D.Double(x, y - h, w, h);
        }
        return null;
    }
}

